/******************************************************************************
* Bzr-Gen.c - Bezier generic routines.					      *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#include "cagd_loc.h"

/******************************************************************************
* Allocates the memory required for a new Bezier surface.			      *
******************************************************************************/
CagdSrfStruct *BzrSrfNew(int ULength, int VLength, CagdPointType PType)
{
    CagdSrfStruct *Srf = CagdSrfNew(CAGD_SBEZIER_TYPE, PType, ULength,
								VLength);

    Srf -> UOrder = ULength;
    Srf -> VOrder = VLength;

    Srf -> UKnotVector = Srf -> VKnotVector = NULL;

    return Srf;
}

/******************************************************************************
* Allocates the memory required for a new Bezier curve.			      *
******************************************************************************/
CagdCrvStruct *BzrCrvNew(int Length, CagdPointType PType)
{
    CagdCrvStruct *Crv = CagdCrvNew(CAGD_CBEZIER_TYPE, PType, Length);

    Crv -> Order = Length;

    Crv -> KnotVector = NULL;

    return Crv;
}
