;; CLICK.ASM  v1.0
;;
;; This is a small TSR program that produces a click each time
;; a key is pressed (and optionally when it is released).
;; Repeating keys cause repeating clicks.
;; The program hooks interrupt 9h (keyboard).
;;
;; Adjust volume by changing duration of click (above label `delay')
;;
;; Written in February 1990 by Erik Tamboer, Amsterdam, The Netherlands
;; email: tamboer@cs.vu.nl  (probably until July 1991)
;;
;; Usage: just type CLICK at the DOS prompt or include a line
;; with only the word CLICK in your \AUTOEXEC.BAT file. There are
;; no command line switches.
;;
;; This program is free. You may use it for anything you like.
;; I have had no problems whatsoever with this program, but I
;; cannot guarantee that it will work in every environment.
;;
;; This code covers about everything I know about assembler programming
;; (I am a C programmer, really) so I am not claiming perfection ;-)

 
cseg    segment byte
        assume  cs:cseg,ds:cseg,es:cseg,ss:cseg
        org     100h

start:  jmp     install

old_int9_vector label   dword
old_int9_off    dw      ?
old_int9_seg    dw      ?


new_int9:
        push    ax
        in      al,60h                  ; get key scan code

        ; Delete the next two lines if you want keys to click also
        ; when they are released.

;	 test	 al,80h
;	 jnz	 noclick

        ; You can disable the clicking of keys such as NumLock and Shift.
        ; For each of these special keys that you DO want to click,
        ; delete the corresponding test and jump.
        ; Note that some of these keys may actually repeat!

        cmp     al,1dh                  ; Ctrl
        jz      noclick
        cmp     al,2ah                  ; Left Shift
        jz      noclick
        cmp     al,36h                  ; Right Shift
        jz      noclick
        cmp     al,38h                  ; Alt
        jz      noclick
        cmp     al,3ah                  ; Caps Lock
        jz      noclick
        cmp     al,45h                  ; Num Lock
        jz      noclick
        cmp     al,46h                  ; Scroll Lock
        jz      noclick
        pop     ax

click:
        push    ax
        push    cx
        mov     al,0b6h
        out     43h,al
        mov     cx,180h                 ; frequency
        mov     al,cl
        out     42h,al
        mov     al,ch
        out     42h,al
        in      al,61h
        or      al,3
        out     61h,al
        mov     cx,28h                  ; duration (controls volume)
delay:  loop    delay
        in      al,61h
        and     al,0fch
        out     61h,al
        pop     cx

noclick:
        pop     ax
        pushf
        call    cs:old_int9_vector      ; call original int 9 handler
        iret

keep    label   byte

msg1    db      'Keyboard CLICK ',04h,' Written by Erik Tamboer, 1990'
        db      0dh,0ah,'$'
msg2    db      'CLICK installed',0dh,0ah,'$'
msg3    db      'CLICK already installed',0dh,0ah,'$'

install:
        mov     es,ds:2ch               ; free our environment,
        mov     ah,49h                  ;  this makes us
        int     21h                     ;   even smaller
        mov     dx,offset msg1          ; identify ourselves
        mov     ah,9
        int     21h
        mov     ah,35h
        mov     al,9
        int     21h                     ; get keyboard interrupt vector
        cmp     bx,offset new_int9      ; are we installed yet? (unreliable!)
        jne     install1                ; if not, install
        mov     dx,offset msg3          ; else say so and exit
        mov     ah,9
        int     21h
        int     20h                     ; exit
        
install1:
        mov     old_int9_off,bx         ; save old keyboard interrupt vector
        mov     old_int9_seg,es

; set keyboard interrupt to point to new_int9

        mov     ah,25h
        mov     al,9
        mov     dx,offset new_int9
        int     21h


        mov     dx,offset msg2          ; say we're installed
        mov     ah,9
        int     21h

; terminate and stay partially resident

        mov     dx,offset keep+1
        int     27h

        cseg    ends
        end     start
