#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       fergie.mak
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION:
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.1  $
#* WORKFILE:    $Workfile:   SNMP.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/APS/SNMP/VCS/SNMP.MAV  $
#  
#     Rev 1.1   01 Feb 1991 16:40:04   etstjan
#  No explicit note
#  
#     Rev 1.0   01 Feb 1991 16:37:34   etstjan
#  tNo explicit note
#************************************************************************
HOMEDIR = ..\..
NEWTREE = .^\
MODEL=L
MODE=r
CFLAGS=/W4 /Ox /A$(MODEL) /L$(MODE) /I$(HOMEDIR)\INCLUDE /I..\INCLUDE /Fmsnmp.map
LFLAGS=/MAP /STACK:8000  
MFLAGS=HOMEDIR="$(HOMEDIR)" CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
LIB=$(LD);$(LIB)
ED=$(HOMEDIR)\EXE
PUTNOTE="No explicit note"

SYSTEM=FERGIE

ALIBS = $(MODEL)POWER3$(MODE).LIB 

BLIBS= $(MODEL)PKT$(MODE).LIB    $(MODEL)DP$(MODE).LIB \
      $(MODEL)ML$(MODE).LIB      $(MODEL)DpaIP$(MODE).LIB \
      $(MODEL)IP$(MODE).LIB     $(MODEL)UDP$(MODE).LIB \
      $(MODEL)IFACE$(MODE).LIB  $(MODEL)SOCK$(MODE).LIB \
      $(MODEL)TFTP$(MODE).LIB   $(MODEL)SDM$(MODE).LIB\
      $(MODEL)FUTIL$(MODE).LIB  $(MODEL)BUFM$(MODE).LIB \
      $(MODEL)PING$(MODE).LIB   $(MODEL)ECHO$(MODE).LIB \
      $(MODEL)dperr$(MODE).LIB  $(MODEL)ASN1$(MODE).LIB \
      $(MODEL)SNMP$(MODE).LIB   $(MODEL)MIB2$(MODE).LIB \
      $(MODEL)DSNMP$(MODE).LIB  $(MODEL)MAT$(MODE).LIB \
      $(MODEL)LOAD$(MODE).LIB   $(MODEL)CONTROL$(MODE).LIB \
      $(MODEL)DOG$(MODE).LIB    $(MODEL)DISP$(MODE).LIB \
      $(MODEL)PORT$(MODE).LIB

LIBS = $(ALIBS) $(BLIBS)

CS=FERGIE.C LINK.C
AS=
CTS=
HS=
MAKS=FERGIE.mak
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) $(CTS) 
OBJS=FERGIE.OBJ LINK.OBJ
TOBJS=
EXES=$(SYSTEM).exe
TEXES= 
EXPORTS= $(ED)\$(SYSTEM).EXE
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  exe 
    @echo (3) Ready


compile:    $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe:   $(EXES) $(TEXES)

clean:
    @-del *.obj 2>nul
    @-del *.lib 2>nul
    @-del *.bak 2>nul
    @-del *.err 2>nul
    @-del *.exe 2>nul


collect: $(EXPORTS)
    !-copy $(**F) $**


put:    $(SRCS)
    !@-PUT -l -n -m$(PUTNOTE) $**
    @-PUT  -l -n -m$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l $**


get:    $(SRCS)
    !GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(SYSTEM).exe : $(OBJS)
    cl $(CFLAGS) /F 8000 /Fe$@ $** $(LIBS) /link $(LOPTS)
    copy $@ $(ED)

$(SRCS) :

$(EXPORTS) :

$(LIBS) :
    @$(MAKE) /NOLOGO $(MFLAGS) -f "$(HOMEDIR)\beholder.mak"  $@

