/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPAPC2.C
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Tirza van Rijn
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1991/9/2
**
** DESCRIPTION: Packet capture application for the online BEHOLDER
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   dpapc2.c  $
** LOGINFO:     $Log:   I:/tirza/cprog/beholder/baps/dpapc/dpapc2.c_v  $
**              
**                 Rev 1.0   2 Sep 1991 15:26:54   tirza
**              Initial revision.
*************************************************************************/
#if !defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/tirza/cprog/beholder/baps/dpapc/dpapc2.c_v   1.0   16 Sep 1991 13:32:48   unknown  $";
#endif


#include <stdio.h>                          
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <dp.h>
#include <error.h>
#include <power3.h>
#include <dpu.h>
#include <dpfpkt.h>


#define DEFAULT_DUMPFILE_SIZE       10240   /* limit = 10K = 10240 bytes */ 
#define DEFAULT_NR_OF_PACKETS         100   /* limit = 100 packets */
#define DEFAULT_RUNTIME               100   /* limit = 100 s */
#define DEFAULT_DUMPFILE_NAME       "pktcapt.dmp" 
#define REC_HEADER          0xfe            /* Dump file record types */
#define REC_VERSION         0xfd
#define REC_HDRINFO         0xfc
#define REC_TIMESTAMP       0xfb
#define REC_FRAME           0xf8            /* Marks start of a frame */
#define FR_DUMP_HDRSIZE     (1+sizeof(unsigned int)) /* ID + len */


typedef struct _DISP_DATA
{
    BYTE Src[6];
    BYTE Dst[6];
    BYTE PktType[2];
} DISP_DATA;


/*Function prototypes */
static int  ProcessEvent(DPEVENT Event);
static void ReceivePkt(void);
static void EverySecond(void);
static void Init(void);
static void End(void);
static int  Start(void);
static void Stop(void);
static void Reset(void);
static void Show(void);
static void Hide(void);
static void FreeTime(void);
static void KeyPressed(void);
static int PwmCaptureMenu(int Element);
static int PwmFileViewMenu(int Element);


DPAPPS DpaPktCapt = {
    "PktCapt",                              /* application name */
    ProcessEvent,                           /* event processing function */
    0,                                      /* status bits, must be 0 */
/* accept event mask, tells the beholder which events this */
/* application wishes to handle                              */
/*   DPE_DEFAULT = DPE_INIT | DPE_END | DPE_START | DPE_STOP */
    DPE_DEFAULT | DPE_RESET | DPE_FREETIME | DPE_EVERYSECOND | DPE_RECEIVEPKT | DPE_KEYPRESSED,
/* start event mask, tells the beholder which events to          */
/* generate for this application during the 'DpStart()' function  */
    DPE_RESET | DPE_START | DPE_SHOW,           
    0,                                           /* timer event mask */
    0,                                           /* timer value */
    0,                                           /* timer start */
    0,                                           /* timer stop */
    0,                                           /* timer timer */
    1,                                           /* # of active filters */
    0,                                           /* active filter # */
    {0}                                          /* list of active filters */
};
struct rec_hdr {
    unsigned char type;
    int len;
};
static char *CaptureMenu[] = {
    "Max. dumpfile size",
    "Max. number of packets",
    "Max. runtime",
    "Dumpfile name",
    "Filters",
    NULL
};
static int CaptureElem;
static int FiltersElem;
static char Figures[] = "0123456789";
static int PacketsVisible = 0;
static PWWIN *DispWin;
static DISP_DATA DisplayList[10];
static PWWIN *pCaptWin;
static DPSTAT *pStat;
static struct rec_hdr hdr;
static char rec_header[] = "FRAME dumpfile";
static char rec_version[] = "v1.00";
static char rec_timestamp[18];
static long max_DumpfileSize;
static long DumpfileSize;
static unsigned long max_NrOfPackets;
static unsigned long nPkts;
static long max_Runtime;
static long Seconds;
static FILE *dumpfile;
static char DumpfileName[80];
static int DumpfileNameLength;
static char ViewfileName[80];
static long InitTotalPackets;
static long InitMissedPackets;


static int ProcessEvent(DPEVENT Event)
{
    int ret = 0;

    switch(Event)
    {
        case DPE_RECEIVEPKT:    ReceivePkt();   break;
        case DPE_EVERYSECOND:   EverySecond();  break;
        case DPE_INIT:          Init();         break;
        case DPE_END:           End();          break;
        case DPE_START:   ret = Start();        break;
        case DPE_STOP:          Stop();         break;
        case DPE_SHOW:          Show();         break;
        case DPE_HIDE:          Hide();         break;
        case DPE_RESET:         Reset();        break;
        case DPE_FREETIME:      FreeTime();     break;
        case DPE_KEYPRESSED:    KeyPressed();   break;
    }
    return ret;
}

static void ReceivePkt()
{
    DPBUF *frame = DpReceivePkt();

    if ((dumpfile != NULL) &&
        ((DumpfileSize + 3 + sizeof(DPBUF) + frame->Size) <= max_DumpfileSize) &&
        (nPkts <= max_NrOfPackets) &&
        (Seconds <= max_Runtime))
    {
        hdr.type = REC_FRAME;
        hdr.len = sizeof(DPBUF) + frame->Size + FR_DUMP_HDRSIZE;
        fwrite(&hdr.type, sizeof(hdr.type), 1, dumpfile);
        fwrite(&hdr.len, sizeof(hdr.len), 1, dumpfile);
        fwrite(frame, sizeof(DPBUF), 1, dumpfile);
        fwrite(frame->pBuf, sizeof(BYTE), (frame->Size), dumpfile);
        DumpfileSize = DumpfileSize + 3 + sizeof(DPBUF) + frame->Size;

        memcpy(DisplayList[nPkts%10].Dst, frame->pBuf, 6);
        memcpy(DisplayList[nPkts%10].Src, frame->pBuf+6, 6);
        memcpy(DisplayList[nPkts%10].PktType, frame->pBuf+12, 2); 

        nPkts++;

        pw_printfat(pCaptWin, 1, 11, "%ld", DumpfileSize);
        pw_printfat(pCaptWin, 2, 10, "%ld", Seconds);
        pw_printfat(pCaptWin, 3, 11, "%ld", nPkts);

    }
    else
        DpAppsEvent(DpAppsGetApps("PktCapt"), DPE_STOP);
}

static void EverySecond(void)
{
    Seconds++;                         
}

static void Init(void)
{
    max_DumpfileSize = DEFAULT_DUMPFILE_SIZE;
    max_NrOfPackets  = DEFAULT_NR_OF_PACKETS;
    max_Runtime      = DEFAULT_RUNTIME;
    strcpy (DumpfileName, DEFAULT_DUMPFILE_NAME);
    nPkts = 0L;
    Seconds = 0L;
    pCaptWin = pw_open(2, 44, 10, 35, "Capture Status", PWM_NOSHADE, PWW_DATA);
}

static void End(void)
{
}

static int Start(void)
{
    int j;

    if (((pStat = DpDevGetStatistics(0)) != NULL) || ((pStat = DpDevGetStatistics(1)) != NULL))
    {
        InitTotalPackets = pStat->TotalPackets;
        InitMissedPackets = pStat->MissedPackets;
    }

    pw_menu(8, 12, 0, 0, "Capture", CaptureMenu, PwmCaptureMenu, &CaptureElem); 

    dumpfile = fopen(DumpfileName, "wb");
    if (dumpfile != NULL)
    {
        hdr.type = REC_HEADER;
        hdr.len = sizeof(rec_header) + FR_DUMP_HDRSIZE;
        fwrite(&hdr.type, sizeof(hdr.type), 1, dumpfile);
        fwrite(&hdr.len, sizeof(hdr.len), 1, dumpfile);
        fwrite(rec_header, sizeof(rec_header), 1, dumpfile);

        hdr.type = REC_VERSION;
        hdr.len = sizeof(rec_version) + FR_DUMP_HDRSIZE;
        fwrite(&hdr.type, sizeof(hdr.type), 1, dumpfile);
        fwrite(&hdr.len, sizeof(hdr.len), 1, dumpfile);
        fwrite(rec_version, sizeof(rec_version), 1, dumpfile);

        hdr.type = REC_HDRINFO;
        hdr.len = sizeof(DPHDRINFO) + FR_DUMP_HDRSIZE;
        fwrite(&hdr.type, sizeof(hdr.type), 1, dumpfile);
        fwrite(&hdr.len, sizeof(hdr.len), 1, dumpfile);
        fwrite(hdrinfo, sizeof(DPHDRINFO), 1, dumpfile);

        hdr.type = REC_TIMESTAMP;
        hdr.len = sizeof(rec_timestamp) + FR_DUMP_HDRSIZE;
        _strdate(rec_timestamp);
        rec_timestamp[8] = ' ';
        _strtime(rec_timestamp+9);
        fwrite(&hdr.type, sizeof(hdr.type), 1, dumpfile);
        fwrite(&hdr.len, sizeof(hdr.len), 1, dumpfile);
        fwrite(rec_timestamp, sizeof(rec_timestamp), 1, dumpfile);

        fflush(dumpfile);
        DumpfileSize = filelength(fileno(dumpfile));


        for (j=0; j<10; j++)
            pw_printfat(pCaptWin, j, 0, "                                   ");
        pw_putsat(pCaptWin, 0, 1, "Dumpfile: ");
        pw_puts(pCaptWin, DumpfileName);
        pw_putsat(pCaptWin, 1, 1, "Filesize: ");
        pw_printf(pCaptWin, "%ld", DumpfileSize);
        pw_putsat(pCaptWin, 1, 21, "Max: ");
        pw_printf(pCaptWin, "%ld", max_DumpfileSize);
        pw_putsat(pCaptWin, 2, 1, "Runtime: ");
        pw_printf(pCaptWin, "%ld", Seconds);
        pw_putsat(pCaptWin, 2, 21, "Max: ");
        pw_printf(pCaptWin, "%ld", max_Runtime);
        pw_putsat(pCaptWin, 3, 1, "#Packets: ");
        pw_printf(pCaptWin, "%ld", nPkts);
        pw_putsat(pCaptWin, 3, 21, "Max: ");
        pw_printf(pCaptWin, "%ld", max_NrOfPackets);
        pw_putsat(pCaptWin, 4, 1, "Positive filters: ");
        pw_printfat(pCaptWin, 5, 1, "%d", NrOf_P_StartFs);
        pw_puts(pCaptWin, " start"); 
        pw_printfat(pCaptWin, 5, 13, "%d", NrOf_P_PktFs);
        pw_puts(pCaptWin, " packet");
        pw_printfat(pCaptWin, 5, 26, "%d", NrOf_P_StopFs);
        pw_puts(pCaptWin, " stop");
        pw_putsat(pCaptWin, 6, 1, "Negative filters: ");
        pw_printfat(pCaptWin, 7, 1, "%d", NrOf_N_StartFs);
        pw_puts(pCaptWin, " start"); 
        pw_printfat(pCaptWin, 7, 13, "%d", NrOf_N_PktFs);
        pw_puts(pCaptWin, " packet");
        pw_printfat(pCaptWin, 7, 26, "%d", NrOf_N_StopFs);
        pw_puts(pCaptWin, " stop"); 

    }
    else
        return -1;
}

static void Stop(void)
{
/*    pw_close(pCaptWin);  */
    nPkts = 0L;
    Seconds = 0L;
    if (dumpfile != NULL)
        fclose(dumpfile);
}

static void Reset(void)
{
    int j, i = 0;

    for (j=0; j<10; j++)
        pw_printfat(pCaptWin, j, 0, "                                   ");
    if (dumpfile != NULL)
        fclose(dumpfile);
    max_DumpfileSize = DEFAULT_DUMPFILE_SIZE;
    max_NrOfPackets  = DEFAULT_NR_OF_PACKETS;
    max_Runtime      = DEFAULT_RUNTIME;
    strcpy (DumpfileName, DEFAULT_DUMPFILE_NAME);
    nPkts = 0L;
    Seconds = 0L;
    pCaptWin = pw_open(2, 44, 10, 35, "Capture Status", PWM_NOSHADE, PWW_DATA);
    pw_putsat(pCaptWin, 0, 1, "Dumpfile: ");
    pw_puts(pCaptWin, DumpfileName);
    pw_putsat(pCaptWin, 1, 1, "Filesize: ");
    pw_printf(pCaptWin, "%ld", i);
    pw_putsat(pCaptWin, 1, 21, "Max: ");
    pw_printf(pCaptWin, "%ld", max_DumpfileSize);
    pw_putsat(pCaptWin, 2, 1, "Runtime: ");
    pw_printf(pCaptWin, "%ld", Seconds);
    pw_putsat(pCaptWin, 2, 21, "Max: ");
    pw_printf(pCaptWin, "%ld", max_Runtime);
    pw_putsat(pCaptWin, 3, 1, "#Packets: ");
    pw_printf(pCaptWin, "%ld", i);
    pw_putsat(pCaptWin, 3, 21, "Max: ");
    pw_printf(pCaptWin, "%ld", max_NrOfPackets);
    pw_putsat(pCaptWin, 4, 1, "Positive filters: ");
    pw_printfat(pCaptWin, 5, 1, "%d", NrOf_P_StartFs);
    pw_puts(pCaptWin, " start"); 
    pw_printfat(pCaptWin, 5, 13, "%d", NrOf_P_PktFs);
    pw_puts(pCaptWin, " packet");
    pw_printfat(pCaptWin, 5, 26, "%d", NrOf_P_StopFs);
    pw_puts(pCaptWin, " stop");
    pw_putsat(pCaptWin, 6, 1, "Negative filters: ");
    pw_printfat(pCaptWin, 7, 1, "%d", NrOf_N_StartFs);
    pw_puts(pCaptWin, " start"); 
    pw_printfat(pCaptWin, 7, 13, "%d", NrOf_N_PktFs);
    pw_puts(pCaptWin, " packet");
    pw_printfat(pCaptWin, 7, 26, "%d", NrOf_N_StopFs);
    pw_puts(pCaptWin, " stop"); 
}

static void Show(void)
{
    DispWin = pw_open (2, 1, 10, 41, "Received packets", PWM_NOSHADE, PWW_NORMAL);
    pw_printfat (DispWin, -1, 0, "SourceDestinationProt");
    PacketsVisible = 1;
}

static void Hide(void)
{
    pw_close (DispWin);
    PacketsVisible = 0;
}

static void FreeTime()
{
    int i,j;

    if (Seconds > max_Runtime)
        DpAppsEvent(DpAppsGetApps("PktCapt"), DPE_STOP);
    else                                                     
    {
        if (((pStat = DpDevGetStatistics(0)) != NULL) || ((pStat = DpDevGetStatistics(1)) != NULL))
        {
            pw_printfat(pCaptWin, 8, 1, "Received packets: %ld", pStat->TotalPackets - InitTotalPackets);
            pw_printfat(pCaptWin, 9, 1, "Missed packets: %ld", pStat->MissedPackets - InitMissedPackets);
        }
        pw_putsat(pCaptWin, 2, 1, "Runtime: ");
        pw_printf(pCaptWin, "%ld", Seconds); 
        if (!PacketsVisible)
            return;
        for (j=0, i=((int)nPkts > 10 ? (int)nPkts%10 : 0); j<((int)nPkts > 10 ? 10 : (int)nPkts); j++, i=(i+1)%10)
        {
            pw_printfat(DispWin, j, 0, "%02x:%02x:%02x:%02x:%02x:%02x%02x:%02x:%02x:%02x:%02x:%02x%02x%02x",
            DisplayList[i].Src[0], DisplayList[i].Src[1], DisplayList[i].Src[2], DisplayList[i].Src[3], DisplayList[i].Src[4], DisplayList[i].Src[5],
            DisplayList[i].Dst[0], DisplayList[i].Dst[1], DisplayList[i].Dst[2], DisplayList[i].Dst[3], DisplayList[i].Dst[4], DisplayList[i].Dst[5],
            DisplayList[i].PktType[0], DisplayList[i].PktType[1]);
        }
    }
}

static void KeyPressed()
{
}

static int PwmCaptureMenu(int Element)
{
    PWWIN *pTempWin;
    char InputString[80];

    switch (Element)
    {                  
        case 0: /* Max. dumpfile size */
            pTempWin = pw_open(10, 12, 1, 52, "Max. dumpfile size", PWM_DEFAULT, PWW_DATA);
            pw_shade(pTempWin); 
            ltoa(max_DumpfileSize, InputString, 10);
            pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 10, Figures, PWM_UPROMPT);
            pw_close(pTempWin);
            max_DumpfileSize = atol(InputString);
            Element = PWA_UPDATELINE;
            break;
        case 1: /* Max. number of packets */
            pTempWin = pw_open(10, 12, 1, 52, "Max. number of packets", PWM_DEFAULT, PWW_NORMAL);
            pw_shade(pTempWin);
            ultoa(max_NrOfPackets, InputString, 10);
            pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 10, Figures, PWM_UPROMPT);
            pw_close(pTempWin);
            max_NrOfPackets = atol(InputString);
            Element = PWA_UPDATELINE;
            break;
        case 2: /* Max. runtime */
            pTempWin = pw_open(10, 12, 1, 52, "Max. runtime", PWM_DEFAULT, PWW_NORMAL);
            pw_shade(pTempWin);
            ultoa(max_Runtime, InputString, 10);
            pw_input(pTempWin, 0, 1, "", 0, 1, 50, InputString, 10, Figures, PWM_UPROMPT);
            pw_close(pTempWin);
            max_Runtime = atol(InputString);
            Element = PWA_UPDATELINE;
            break;                                             
        case 3: /* Dumpfile name */
            pTempWin = pw_open(10, 12, 1, 52, "Dumpfile name", PWM_DEFAULT, PWW_NORMAL);
            pw_shade(pTempWin);
            pw_input(pTempWin, 0, 1, "", 0, 1, 50, DumpfileName, 80, NULL, PWM_UPROMPT);
            pw_close(pTempWin);
            Element = PWA_UPDATELINE;
            break;
        case 4: /* Filters */
            pw_menu(10, 14, 0, 0, "Filters", FiltersMenu, PwmFiltersMenu, &FiltersElem);
            break;
    }
    return Element;
}
