/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DSNMP.C
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1990/7/30
**
** DESCRIPTION: Dispatcher Application file for SNMP Agent
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DSNMP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DSNMP/VCS/DSNMP.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:45:00   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/DSNMP/VCS/DSNMP.C_V   1.0   31 Jan 1991 16:45:00   etstjan  $";
#endif
#include      <stdio.h>              
#include      <string.h>
#include      <power3.h>
/* #include      "ip.h" */
#include      <error.h>
#include      <beholder.h>
#include      <snmp.h>
#include      <mib2.h>
 
/* prototyping of static functions                                          */
static int  ProcessEvents (DPEVENT Event);
static void SnmpInit (void);            /* Snmp application init            */
static void SnmpFreeTime (void);        /* Snmp application free time       */
static void SnmpStart (void);           /* Snmp application start            */
static void SnmpStop (void);            /* Snmp application stop             */

DPAPPS DpaSnmp = {
    "Snmp Agent",                           /* Application name             */
    ProcessEvents,                          /* Event processing function    */
    0,                                      /* Status, must be 0            */
    DPE_FREETIME | DPE_START | DPE_STOP | DPE_INIT, 
    DPE_START,
    0,
    -1,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
    }; 

int
    SnmpAct = 0;

/**************************************************************
** NAME:        ProcessEvents
** SYNOPSIS:    static int ProcessEvents(DPEVENTS Event);
**
** DESCRIPTION: Processes dispatcher events.
**
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
static int ProcessEvents(DPEVENT Event)
{
    switch (Event)
    {
        case DPE_INIT:          SnmpInit();           break;
        case DPE_START:         SnmpStart();          break;
        case DPE_STOP:          SnmpStop();           break;
        case DPE_FREETIME:      SnmpFreeTime();       break;
    }
    return 0;
}

/**************************************************************
** NAME:        SnmpInit
** SYNOPSIS:    static void SnmpInit (void);
**           
** DESCRIPTION: Initializes the Snmp Agent.
** RETURNS:  
**************************************************************/
static void SnmpInit (void)
{
    ERR_DEB (ERR_DPA, 5, "Init\n");
    MibIni ();
}

/**************************************************************
** NAME:        SnmpFreeTime
** SYNOPSIS:    static void SnmpFreeTime (void);
** 
** DESCRIPTION: Handles the Snmp request packets
** RETURNS:  
**************************************************************/
static void SnmpFreeTime (void)
{
    if (SnmpAct)
    {
        MibPol ();
    }
}

/**************************************************************
** NAME:        SnmpStart
** SYNOPSIS:    static void SnmpStart (void);
**           
** DESCRIPTION: Starts the Snmp Agent.
** RETURNS:  
**************************************************************/
static void SnmpStart (void)
{
    if (SnmpAct == 0)
    {
        ERR_DEB (ERR_DPA, 5, "Start\n");
        if (AgtOpn () < 0)
            return;
        SnmpAct = 1;
    }
}  

/**************************************************************
** NAME:        SnmpStop
** SYNOPSIS:    static void SnmpStop (void);
**           
** DESCRIPTION: Stops the Snmp Agent.
** RETURNS:  
**************************************************************/
static void SnmpStop (void)
{
    ERR_DEB (ERR_DPA, 5, "Stop\n");
    if (SnmpAct != 0)
    {
      AgtCls ();
      SnmpAct = 0;
    }
}




