/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       port.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/14
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   PORT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/PORT/VCS/PORT.C_V  $
**              
**                 Rev 1.0   31 Jan 1991 16:47:02   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/PORT/VCS/PORT.C_V   1.0   31 Jan 1991 16:47:02   etstjan  $";
#endif

#define IPS_DOS

#include <stdlib.h>
#include <stdio.h>
#include <beholder.h>
#include <power3.h>
#include <bufm.h>
#include <snmp.h>
#include <mib2.h>
#include <dp.h>
#include <futil.h>
#include <ml.h>
#include <error.h>


#define SIZE_UDP 257
#define SIZE_TCP 257

#define OJILEN(Oji)        (sizeof((Oji))/sizeof(int))

static unsigned PortTcpOji[] = {1,3,6,1,4,1,99,4,1,1,1,1};
static unsigned PortUdpOji[] = {1,3,6,1,4,1,99,4,1,2,1,1};

typedef struct _PORT_DATA
{
    unsigned long Packets;
    unsigned long Bytes;
    unsigned long TimeLast;
}   PORT_DATA;


static PORT_DATA PortTcpTot,PortUdpTot,PortIpTot; 
static PORT_DATA *PortTcp,*PortUdp;
static unsigned PortApps;


static int  ProcessEvent (DPEVENT Event);
static void Init (void);
static void ReceivePkt (void);
static void Reset (void);

static unsigned PortGetUdp(pkt_obj *Obj, void *Arg);
static unsigned PortNxtUdp(pkt_obj *Obj, void *Arg);
static unsigned PortGetTcp(pkt_obj *Obj, void *Arg);
static unsigned PortNxtTcp(pkt_obj *Obj, void *Arg);


DPAPPS DpaPort = {
    "Port",
    ProcessEvent,
    0,                                     
    DPE_START | DPE_STOP | DPE_RESET | DPE_RECEIVEPKT | DPE_INIT,
    DPE_START | DPE_RESET,
    DPE_RESET,
    5000,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
};



static int ProcessEvent (DPEVENT Event)
{
    switch (Event)
    {
        case DPE_INIT:          Init();         break;
        case DPE_RECEIVEPKT:    ReceivePkt();   break;
        case DPE_RESET:         Reset ();       break;
    }
    return 0;
}



static void Reset (void)
{
    memset(PortTcp,0,sizeof(PORT_DATA)*SIZE_TCP);
    memset(PortUdp,0,sizeof(PORT_DATA)*SIZE_UDP);
}

    
static void Init (void)
{
    mib_prf *Prf;
    
    PortApps=DpAppsGetApps("Port");
    PortTcp=IPBufGet(sizeof(PORT_DATA)*SIZE_TCP);
    if(PortTcp==NULL)
    {
       ERR_ERR (10, ERR_WARNING, "Can't alloc PortTcp");
       return; 
    }
    PortUdp=IPBufGet(sizeof(PORT_DATA)*SIZE_UDP);
    if(PortUdp==NULL)
    {
       ERR_ERR (10, ERR_WARNING, "Can't alloc PortUdp");
       return;
    }
    if ((Prf = MibAddPrf ("public", 6)) == NULL)
        return;
    if ((MibAddObj (Prf, PortTcpOji, OJILEN(PortTcpOji), PortGetTcp, PortNxtTcp, NULL, NULL)) < 0)
        return;
    if ((MibAddObj (Prf, PortUdpOji, OJILEN(PortUdpOji), PortGetUdp, PortNxtUdp, NULL, NULL)) < 0)
        return;
}



static void ReceivePkt (void)
{
    DPBUF               *Buf;
    BYTE                *Pack;
    unsigned            Length, Type, Src, Dst, Ind;
    BYTE                Prot, Ihl;
    long unsigned       Time;

    Buf = DpReceivePkt ();
    Pack=Buf->pBuf;
    if (Buf->Dev!=0)
        return;
    Time = DpAppsGetTimer(PortApps);
    Length=Buf->Size;
    Type= (unsigned) *((BYTE *) Pack+12);
    Type<<=8;
    Type|=(unsigned) *((BYTE *) Pack+13);
    if (Type!=0x0800 && Type!=0x0806)
        return;
    PortIpTot.Packets++;
    PortIpTot.Bytes+=Length;
    PortIpTot.TimeLast=Time;
    Prot=*((BYTE *)Pack+23);
    if (Prot!=6 && Prot!=17)
        return;
    Ihl= *((BYTE *) Pack+14) & (BYTE) 0x0f;
    Src=(unsigned) *((BYTE *)Pack+14+4*Ihl);
    Src<<=8;
    Src|=(unsigned) *((BYTE *)Pack+15+4*Ihl);
    Dst=(unsigned) *((BYTE *)Pack+16+4*Ihl);
    Dst<<=8;
    Dst|=(unsigned) *((BYTE *)Pack+17+4*Ihl);
    if (Src<=255)
        Ind=Src;
    else if (Dst<=255)
        Ind=Dst;
    else
        Ind=256;
    if (Prot==6)
    {
            if(Ind == 256)
                ERR_DEB(10,3,"Por Rcv Pkt, TCP : Type=%d Prot=%d Ihl=%d Ind=%d Src=%d Dst=%d\n",
                    Type,Prot,Ihl,Ind,Src,Dst);
        PortTcpTot.Packets++;
        PortTcpTot.Bytes+=Length;
        PortTcpTot.TimeLast=Time;
        PortTcp[Ind].Packets++;
        PortTcp[Ind].Bytes+=Length;
        PortTcp[Ind].TimeLast=Time;
    }
    else
    {
        if (Prot==17)
        {
                ERR_DEB(10,5,"Por Rcv Pkt, UDP : Type=%d Prot=%d Ihl=%d Ind=%d Src=%d Dst=%d\n",
                    Type,Prot,Ihl,Ind,Src,Dst);
            PortUdpTot.Packets++;
            PortUdpTot.Bytes+=Length;
            PortUdpTot.TimeLast=Time;
            if(PortUdp[Ind].Packets == 0)
                 ERR_DEB(10,2,"RcvPktPort, First UDP type %d",Ind);
            PortUdp[Ind].Packets++;
            PortUdp[Ind].Bytes+=Length;
            PortUdp[Ind].TimeLast=Time;
        }
        else
            ERR_ERR (10, ERR_WARNING, "Port internal error 1");

    }
}



/* <Variable>.<Col>.<Port> */
/* Length:    1       1    */
/* Offset:    0       1    */

static unsigned PortGetUdp(pkt_obj *Obj, void *Arg)
{
    unsigned Col, Ind;
    ERR_DEB(10,2,"PortGetUdp");
    
    if (Obj->ObjOjiLen!=OJILEN(PortUdpOji)+2)
        return(PKT_NOSUCHNAME);
    Col=Obj->ObjOji[OJILEN(PortUdpOji)+0];
    if (Col<1 || Col>5)
        return(PKT_NOSUCHNAME);
    Ind=Obj->ObjOji[OJILEN(PortUdpOji)+1];
    if (Ind>=SIZE_UDP)
        return(PKT_NOSUCHNAME);
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Ind;
            break;
        case 2:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt= DpAppsGetTimer(PortApps)/10;
            break;
        case 3:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortUdp[Ind].Packets;
            break;
        case 4:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortUdp[Ind].Bytes;
            break;
        case 5:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt=PortUdp[Ind].TimeLast/10;
            break;
    }
    return(PKT_NOERROR);
}

static unsigned PortNxtUdp(pkt_obj *Obj, void *Arg)
{
    unsigned Col, Ind;
    
    ERR_DEB(10,4,"PortNxtUdp");
    
    if (Obj->ObjOjiLen<=OJILEN(PortUdpOji))
    {
        Col=1;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Col=Obj->ObjOji[OJILEN(PortUdpOji)+0];
    }
    if (Obj->ObjOjiLen<=OJILEN(PortUdpOji)+1)
    {
        Ind=-1;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Ind=Obj->ObjOji[OJILEN(PortUdpOji)+1];
    }
    if (++Ind>=SIZE_UDP)
    {
        Ind=0;
        if (++Col>5)
            return(PKT_NOSUCHNAME);
    }

    Obj->ObjOji[OJILEN(PortUdpOji)+0]=Col;
    Obj->ObjOji[OJILEN(PortUdpOji)+1]=Ind;
    
    ERR_DEB(10,4,"PortNxtUdp: Col=%d Ind=%d B=%ld P=%ld\n"
        ,Col,Ind,PortUdp[Ind].Bytes,PortUdp[Ind].Packets);

    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Ind;
            break;
        case 2:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt= DpAppsGetTimer(PortApps)/10;
            break;
        case 3:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortUdp[Ind].Packets;
            break;
        case 4:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortUdp[Ind].Bytes;
            break;
        case 5:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt=PortUdp[Ind].TimeLast/10;
            break;
    }
    return(PKT_NOERROR);
}

static unsigned PortGetTcp(pkt_obj *Obj, void *Arg)
{
    unsigned Col, Ind;
    
    ERR_DEB(10,4,"PortGetTcp");
    
    if (Obj->ObjOjiLen!=OJILEN(PortTcpOji)+2)
        return(PKT_NOSUCHNAME);
    Col=Obj->ObjOji[OJILEN(PortTcpOji)+0];
    if (Col<1 || Col>5)
        return(PKT_NOSUCHNAME);
    Ind=Obj->ObjOji[OJILEN(PortTcpOji)+1];
    if (Ind>=SIZE_UDP)
        return(PKT_NOSUCHNAME);
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Ind;
            break;
        case 2:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt= DpAppsGetTimer(PortApps)/10;
            break;
        case 3:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortTcp[Ind].Packets;
            break;
        case 4:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortTcp[Ind].Bytes;
            break;
        case 5:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt=PortTcp[Ind].TimeLast/10;
            break;
    }
    return(PKT_NOERROR);
}

static unsigned PortNxtTcp(pkt_obj *Obj, void *Arg)
{
    unsigned Col, Ind;
    
    ERR_DEB(10,4,"PortNxtTcp");
    
    if (Obj->ObjOjiLen<=OJILEN(PortTcpOji))
    {
        Col=1;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Col=Obj->ObjOji[OJILEN(PortTcpOji)+0];
    }
    if (Obj->ObjOjiLen<=OJILEN(PortTcpOji)+1)
    {
        Ind=-1;
        (Obj->ObjOjiLen)++;
    }
    else
    {
        Ind=Obj->ObjOji[OJILEN(PortTcpOji)+1];
    }
    if (++Ind>=SIZE_UDP)
    {
        Ind=0;
        if (++Col>5)
            return(PKT_NOSUCHNAME);
    }
    Obj->ObjOji[OJILEN(PortTcpOji)+0]=Col;
    Obj->ObjOji[OJILEN(PortTcpOji)+1]=Ind;
    switch(Col)
    {
        case 1:
            Obj->ObjTag=PKT_INTEGER;
            Obj->ObjSyn.SynLngInt=Ind;
            break;
        case 2:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt= DpAppsGetTimer(PortApps)/10;
            break;
        case 3:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortTcp[Ind].Packets;
            break;
        case 4:
            Obj->ObjTag=PKT_COUNTER;
	        Obj->ObjSyn.SynLngInt=PortTcp[Ind].Bytes;
            break;
        case 5:
            Obj->ObjTag=PKT_TIMETICKS;
	        Obj->ObjSyn.SynLngInt=PortTcp[Ind].TimeLast/10;
            break;
    }
    return(PKT_NOERROR);
}
