/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dpfip.c
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/10/26
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPFIP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFIP.C_V  $
**              
**                 Rev 1.0   26 Oct 1990 13:55:46   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFIP.C_V   1.0   26 Oct 1990 13:55:46   etstjan  $";
#endif
#include "dpfinc.h"

static int ProcessEventIP(DPEVENT Event);
static int ProcessEventARP(DPEVENT Event);
static int ProcessEventRARP(DPEVENT Event);
static int ProcessEventTCP(DPEVENT Event);
static int ProcessEventICMP(DPEVENT Event);

DPFILT DpfIP   = { "IP",   ProcessEventIP,   0 };
DPFILT DpfARP  = { "ARP",  ProcessEventARP,  0 };
DPFILT DpfRARP = { "RARP", ProcessEventRARP, 0 };
DPFILT DpfTCP  = { "TCP",  ProcessEventTCP,  0 };
DPFILT DpfICMP = { "ICMP", ProcessEventICMP, 0 };

static int ProcessEventIP(DPEVENT Event)
{
    DPBUF *pBuf;

    switch (Event)
    {
    case DPE_RECEIVEPKT:
        pBuf = DpReceivePkt();
        return ((pBuf->pBuf[12] == 0x08) && (pBuf->pBuf[13] == 0x00));
        break;
    }
    return 0;
}

static int ProcessEventARP(DPEVENT Event)
{
    DPBUF *pBuf;

    switch (Event)
    {
    case DPE_RECEIVEPKT:
        pBuf = DpReceivePkt();
        return (((pBuf->pBuf[12] == 0x08) && (pBuf->pBuf[13] == 0x06)) << 1);
        break;
    }
    return 0;
}

static int ProcessEventRARP(DPEVENT Event)
{
    DPBUF *pBuf;

    switch (Event)
    {
    case DPE_RECEIVEPKT:
        pBuf = DpReceivePkt();
        return (((pBuf->pBuf[12] == 0x80) && (pBuf->pBuf[13] == 0x35)) << 2);
        break;
    }
    return 0;
}

static int ProcessEventTCP(DPEVENT Event)
{
    DPBUF *pBuf;

    switch (Event)
    {
    case DPE_RECEIVEPKT:
        pBuf = DpReceivePkt();
        return (((pBuf->pBuf[12] == 0x08) && (pBuf->pBuf[13] == 0x00)) ||
                (((pBuf->pBuf[12] == 0x08) && (pBuf->pBuf[13] == 0x06)) << 1) ||
                (((pBuf->pBuf[12] == 0x80) && (pBuf->pBuf[13] == 0x35)) << 2));
        break;
    }
    return 0;
}

static int ProcessEventICMP(DPEVENT Event)
{
    DPBUF *pBuf;

    switch (Event)
    {
    case DPE_RECEIVEPKT:
        pBuf = DpReceivePkt();
        return ((pBuf->pBuf[12] == 0x08) &&
                (pBuf->pBuf[13] == 0x00) &&
                (pBuf->pBuf[23] == 0x01));
        break;
    }
    return 0;
}

