#*****************************************************************
#* MODULE INFORMATION*
#*********************
#*      FILE    NAME:           PWRS.MAK
#*      SYSTEM  NAME:           POWER
#*      VERSION NUMBER:         3.00
#*
#* DESCRIPTION: MSDOS Makefile, Compact Model, for
#*              Programmer Oriented Window Environment Routines.
#*              (NoC) July 1989 - Ling Thio Software Productions.
#*****************************************************************
#* ADMINISTRATIVE INFORMATION*
#*****************************
#*      ORIGINAL AUTHOR:    Ling Thio
#*      CREATION DATE:      89/07/10
#*      CHANGES:            none
#*****************************************************************

###
#   The globals
###

MODEL=L
MODL=l
MEM_MODEL=M_LARGE  
# S : Small :   near Code, near Data
# C : Compact : near Code,  far Data
# M : Medium :   far Code, near Data
# L : Large :    far Code,  far Data
# H : Huge :     far Code, huge Data

MODE  = R
MOD   = r
# R : Real Mode
# P : Protected Mode

SYS = $(MODEL)POWER3$(MODE)
CS = .

DCOPT = /Gs /Ox /Zl /A$(MODEL) /L$(MOD) /DMOUSE /D__MSC__ /nologo
DAOPT = /W2 /Mx /D$(MEM_MODEL) /D__MSC__

###
#   The dependenties
###
OL = \
$(MODE)$(MODEL)BINIT.OBJ \
$(MODE)$(MODEL)GBLOC.OBJ \
$(MODE)$(MODEL)GCOPY.OBJ \
$(MODE)$(MODEL)GHSCR.OBJ \
$(MODE)$(MODEL)GINIT.OBJ \
$(MODE)$(MODEL)GFILE.OBJ \
$(MODE)$(MODEL)GGETK.OBJ \
$(MODE)$(MODEL)GHBAR.OBJ \
$(MODE)$(MODEL)GHEXD.OBJ \
$(MODE)$(MODEL)GINP.OBJ  \
$(MODE)$(MODEL)GKEY.OBJ  \
$(MODE)$(MODEL)GMENU.OBJ \
$(MODE)$(MODEL)GOPEN.OBJ \
$(MODE)$(MODEL)GPUT.OBJ  \
$(MODE)$(MODEL)GVBAR.OBJ \
$(MODE)$(MODEL)GVSCR.OBJ \
$(MODE)$(MODEL)GWAIT.OBJ \
$(MODE)$(MODEL)GHEAD.OBJ \
$(MODE)$(MODEL)MUTI.OBJ  \
$(MODE)$(MODEL)MVIO.OBJ  \
$(MODE)$(MODEL)VASM.OBJ  \
$(MODE)$(MODEL)VINIT.OBJ

all: PWDEMO.EXE PWCONFIG.EXE

PWDEMO.EXE : $(SYS).LIB PWDEMO.OBJ
    @cl $(DCOPT) /FePWDEMO.EXE PWDEMO.OBJ $(SYS).LIB
    @copy pwdemo.exe ..\exe

PWCONFIG.EXE : $(SYS).LIB PWCONFIG.OBJ
    @cl $(DCOPT) /FePWCONFIG.EXE PWCONFIG.OBJ $(SYS).LIB
     @copy pwconfig.exe ..\exe

$(SYS).LIB : $(OL)
    LIB $(SYS) \
-+$(MODE)$(MODEL)BINIT.OBJ \
-+$(MODE)$(MODEL)GBLOC.OBJ \
-+$(MODE)$(MODEL)GCOPY.OBJ \
-+$(MODE)$(MODEL)GFILE.OBJ \
-+$(MODE)$(MODEL)GGETK.OBJ \
-+$(MODE)$(MODEL)GHSCR.OBJ \
-+$(MODE)$(MODEL)GHBAR.OBJ \
-+$(MODE)$(MODEL)GHEXD.OBJ;
    LIB $(SYS) \
-+$(MODE)$(MODEL)GINIT.OBJ \
-+$(MODE)$(MODEL)GINP.OBJ  \
-+$(MODE)$(MODEL)GKEY.OBJ  \
-+$(MODE)$(MODEL)GMENU.OBJ \
-+$(MODE)$(MODEL)GOPEN.OBJ \
-+$(MODE)$(MODEL)GPUT.OBJ;
    LIB $(SYS) \
-+$(MODE)$(MODEL)GVBAR.OBJ \
-+$(MODE)$(MODEL)GVSCR.OBJ \
-+$(MODE)$(MODEL)GWAIT.OBJ \
-+$(MODE)$(MODEL)GHEAD.OBJ \
-+$(MODE)$(MODEL)MUTI.OBJ  \
-+$(MODE)$(MODEL)MVIO.OBJ  \
-+$(MODE)$(MODEL)VASM.OBJ  \
-+$(MODE)$(MODEL)VINIT.OBJ;
        copy $(SYS).lib ..\lib

$(MODE)$(MODEL)BINIT.OBJ : PWBINIT.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)BINIT.OBJ PWBINIT.C

$(MODE)$(MODEL)GBLOC.OBJ : PWGBLOC.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GBLOC.OBJ PWGBLOC.C

$(MODE)$(MODEL)GCOPY.OBJ : PWGCOPY.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GCOPY.OBJ PWGCOPY.C

$(MODE)$(MODEL)GFILE.OBJ : PWGFILE.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GFILE.OBJ PWGFILE.C

$(MODE)$(MODEL)GGETK.OBJ : PWGGETK.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GGETK.OBJ PWGGETK.C

$(MODE)$(MODEL)GHBAR.OBJ : PWGHBAR.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GHBAR.OBJ PWGHBAR.C

$(MODE)$(MODEL)GHEXD.OBJ : PWGHEXD.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GHEXD.OBJ PWGHEXD.C

$(MODE)$(MODEL)GHSCR.OBJ : PWGHSCR.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GHSCR.OBJ PWGHSCR.C

$(MODE)$(MODEL)GINIT.OBJ : PWGINIT.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GINIT.OBJ PWGINIT.C

$(MODE)$(MODEL)GINP.OBJ : PWGINP.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GINP.OBJ PWGINP.C

$(MODE)$(MODEL)GKEY.OBJ : PWGKEY.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GKEY.OBJ PWGKEY.C

$(MODE)$(MODEL)GMENU.OBJ : PWGMENU.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GMENU.OBJ PWGMENU.C

$(MODE)$(MODEL)GOPEN.OBJ : PWGOPEN.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GOPEN.OBJ PWGOPEN.C

$(MODE)$(MODEL)GPUT.OBJ : PWGPUT.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GPUT.OBJ PWGPUT.C

$(MODE)$(MODEL)GVBAR.OBJ : PWGVBAR.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GVBAR.OBJ PWGVBAR.C

$(MODE)$(MODEL)GVSCR.OBJ : PWGVSCR.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GVSCR.OBJ PWGVSCR.C

$(MODE)$(MODEL)GWAIT.OBJ : PWGWAIT.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GWAIT.OBJ PWGWAIT.C

$(MODE)$(MODEL)GHEAD.OBJ : PWGHEAD.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)GHEAD.OBJ PWGHEAD.C

$(MODE)$(MODEL)MVIO.OBJ :PWMVIO.ASM
    masm $(DAOPT) PWMVIO.ASM,$(MODE)$(MODEL)MVIO.OBJ;

$(MODE)$(MODEL)MUTI.OBJ : PWMUTI.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)MUTI.OBJ PWMUTI.C

$(MODE)$(MODEL)VASM.OBJ :PWVASM.ASM
    masm $(DAOPT) PWVASM.ASM,$(MODE)$(MODEL)VASM.OBJ;

$(MODE)$(MODEL)VINIT.OBJ : PWVINIT.C
    @cl /c /W3 $(DCOPT) /Fo$(MODE)$(MODEL)VINIT.OBJ PWVINIT.C

PWDEMO.OBJ : PWDEMO.C
    @cl /c /Ox /W3 $(DCOPT) /FoPWDEMO.OBJ PWDEMO.C

PWCONFIG.OBJ : PWCONFIG.C
    @cl /c /Ox /W3 $(DCOPT) /FoPWCONFIG.OBJ PWCONFIG.C

collect:
        !-copy power3.h ..\include
        !-copy lpower3r.lib ..\lib

clean:
        !-del *.obj
        !-del *.lib
        !-del *.bak
        !-del *.exe
