/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWCONFIG.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Configuration program for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>                         /* for exit() */
#include <string.h>                         /* for str*() */
#include <memory.h>                         /* for mem*() */
#include "pwinc.h"

void mark(unsigned char i);
void unmark(unsigned char i);
void update_testbox(void);
void select_char(unsigned char *old, unsigned char *def, int offset, int size);
void open_select_win(int type);
int proc_bgcol_menu(int element);
int proc_backgr_menu(int element);
int proc_keyinfo_menu(int element);
int proc_border_menu(int element);
int proc_text_menu(int element);
int proc_win_menu(int element);
int proc_mon_menu(int element);
int proc_main_menu(int element);
void pwg_read_config(char *cfgfile);
void pwg_write_config(char *cfgfile);
void argerror(void);
void iderror(void);
void fileerror(void);
void main(int argc,char * *argv);

#define LEN_PATH    128

static char progname[] =        "PWCONFIG";
static char progver[]  =        "v3.15";
static char proguse[]  =        "[Options]";
static char *main_menu[] = {
#ifdef FUTURE
    "Environment",
#endif
    "Background",
    "Input char",
    "Borders",
    "Colors",
    NULL
};
char *border_menu[] = {
    "Top left corner",
    "Top right corner",
    "Bottom left corner",
    "Bottom right corner",
    "Horizontal bar",
    "Vertical bar",
    "Top 'T' character",
    "Bottom 'T' character",
    "Left 'T' character",
    "Right 'T' character",
    "Crossing lines",
    NULL
};
static char *mon_menu[] = {
    "CGA+Color",
    "CGA+Mono",
    "MDA+Mono",
    NULL
};
static char *win_menu[] = {
    "Init",
    "Normal",
    "Header",
    "Keyinfo",
    "Menu",
    "Data",
    "Error",
    "Help",
    "Special",
    NULL
};
static char *text_menu[] = {
    "Normal",
    "Highlight",
    "Reverse",
    "Special",
    "Active border",
    "Normal border",
    NULL
};
char cfgfile[LEN_PATH];
char scratch[SCRATCH_LEN];
static int win_type;
static int mon_type;
static int text_type;
PWWIN *select_win;
PWWIN *col_win;
PWWIN *test_win = NULL;
unsigned char cf_backgr[BACKGRSIZE];
unsigned char cf_border[BORDERSIZE];
unsigned char cf_attrib[ATTRIBSIZE];
char cf_env[ENVSIZE];
unsigned char default_backgr[BACKGRSIZE] = {
    '', ''
};
unsigned char default_border[BORDERSIZE] = {
    '', '', '', '', '', '', '', '', '', '', ''
};
unsigned char default_attrib[ATTRIBSIZE] = {
        /* Norm  High  Rev   Spec  ActB  Bord */
           0x1b, 0x1f, 0x2e, 0x4f, 0x1b, 0x10,    /* CGA+COL */
           0x1b, 0x1f, 0x4e, 0x4f, 0x1b, 0x10, /* NORMAL */
           0x2e, 0x2f, 0x0f, 0x20, 0x2e, 0x2e, /* HEADER */
           0x2e, 0x2f, 0x0f, 0xcf, 0x2e, 0x2e, /* KEYINFO */
           0x4f, 0x4e, 0x2e, 0x40, 0x4e, 0x40, /* MENU */
           0x1b, 0x1f, 0x4e, 0x4f, 0x1b, 0x1b, /* DATA */
           0x4e, 0x4f, 0x2e, 0x2f, 0x4e, 0x40, /* ERROR */
           0x2e, 0x2f, 0x0f, 0x20, 0x2e, 0x20, /* HELP */
           0x1b, 0x1f, 0x4e, 0x4f, 0x1b, 0x10, /* SPECIAL */

        /* Norm  High  Rev   Spec  ActB  Bord */
           0x1b, 0x1f, 0x1f, 0x2f, 0x1b, 0x13,    /* CGA+MONO */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x13, /* NORMAL */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x13, /* HEADER */
           0x1b, 0x1f, 0x20, 0xcf, 0x1b, 0x13, /* KEYINFO */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x13, /* MENU */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x1b, /* DATA */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x13, /* ERROR */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x13, /* HELP */
           0x1b, 0x1f, 0x20, 0x2f, 0x1b, 0x13, /* SPECIAL */

        /* Norm  High  Rev   Spec  ActB  Bord */
           0x07, 0x0f, 0x7f, 0x7f, 0x0f, 0x07,    /* MDA+MONO */
           0x07, 0x0f, 0x70, 0x7f, 0x0f, 0x07, /* NORMAL */
           0x70, 0x7f, 0x07, 0x0f, 0x70, 0x70, /* HEADER */
           0x7f, 0x7f, 0x07, 0xff, 0x7f, 0x7f, /* KEYINFO */
           0x70, 0x7f, 0x0f, 0x07, 0x7f, 0x70, /* MENU */
           0x07, 0x0f, 0x70, 0x7f, 0x0f, 0x0f, /* DATA */
           0x07, 0x0f, 0x70, 0x7f, 0x0f, 0x07, /* ERROR */
           0x70, 0x7f, 0x07, 0x0f, 0x70, 0x70, /* HELP */
           0x07, 0x0f, 0x70, 0x7f, 0x0f, 0x07  /* SPECIAL */
};
char default_env[] = "INIT";

void mark(i)
unsigned char i;
{
    int row = (i >> 4);
    int col = (i & 0x0f) * 2;

    pw_putcat(select_win, row, col++, '>');
    pw_putcat(select_win, row, ++col, '<');
}

void unmark(i)
unsigned char i;
{
    int row = (i >> 4);
    int col = (i & 0x0f) * 2;

    pw_putcat(select_win, row, col++, ' ');
    pw_putcat(select_win, row, ++col, ' ');
}

void update_testbox()
{
    int row, i;
    unsigned attrib;

    test_win->ccol = 0;
    for (row=0; row<5; row++)
    {
        test_win->crow = row;
        pwv_cursor(test_win);
        attrib = cf_attrib[mon_type+win_type+row];
        for (i=test_win->ncol; i; i--)
            pwv_putattr(test_win, attrib);
    }
}

void select_char(old, def, offset, size)
unsigned char *old;
unsigned char *def;
int offset;
int size;
{
    PWKEY key;
    
    unsigned char tmp;
    unsigned char curr = old[offset];
    unsigned char o_char = old[offset];

    pw_pop(select_win);
    mark(curr);
    while (((key = pw_getkey()) != PWK_ESC) && (key != PWK_ENTER))
    {
        tmp = curr;
        switch (key)
        {
        case PWK_LEFT:
            if ((curr) && (curr & 0x0f))
                curr--;
            break;
        case PWK_RIGHT:
            if ((curr < 255) && ((curr & 0x0f) != 0x0f))
                curr++;
            break;
        case PWK_UP:
            if (curr >= 16)
                curr -= 16;
            break;
        case PWK_DOWN:
            if (curr <= 255-16)
                curr += 16;
            break;
        case PWK_F6:
            curr = def[offset];
            break;
        case PWK_SF6:
            if (pw_question("Restore ALL items of this category [Y/N]", "NY", PWW_ERROR) == 'Y')
            {
                memcpy(old, def, size);
                if (test_win)
                    update_testbox();
                curr = def[offset];
            }
            break;
        }
        if (curr != tmp)
        {
            unmark(tmp);
            mark(curr);
            old[offset] =  curr;
            if (test_win)
                update_testbox();
        }
    }
    unmark(curr);
    if (key != PWK_ENTER)
    {
        old[offset] =  o_char;
        if (test_win)
            update_testbox();
    }
}

void open_select_win(type)
int type;
{
    int i;
    int row, col;
    PWCELL cellh;

    select_win = pw_open(6, 42, 16, 33, "Select character", PWM_HIDE, PWW_DATA);
    cellh = pw_attrib(select_win->wtype, PWT_HIGHLIGHT) << 8;
    for (i=0; i<256; i++)
    {
        row = (i >> 4);
        col = (i & 0x0f) * 2;
        if (type == 0)
        {
            pw_putcellat(select_win, row, col, cellh+' ');
            pw_putcat(select_win, row, col+1, i);
            pw_putcellat(select_win, row, col+2, cellh+' ');
        }
        else
        {
            select_win->crow = row;
            select_win->ccol = col;
            pwv_cursor(select_win);
            pwv_putcell(select_win, (((i&0x7f)|0x0f) << 8) + ' ');
            pwv_putcell(select_win, (i<<8) + 'X');
            pwv_putcell(select_win, (((i&0x7f)|0x0f) << 8) + ' ');
        }
    }
    pw_show(select_win);
    pw_keyinfo(select_win, NULL, "F6=Default  Shift+F6=All default  Enter");
}

int proc_border_menu(element)
int element;
{
    open_select_win(0);                     /* select chars */
    select_char(cf_border, default_border, element, BORDERSIZE);
    pw_close(select_win);
    return element;
}

int proc_text_menu(element)
int element;
{
    text_type = element;
    open_select_win(1);                     /* select colors */
    update_testbox();
    select_char(cf_attrib, default_attrib, mon_type + win_type + element, ATTRIBSIZE);
    update_testbox();
    pw_close(select_win);
    return element;
}

int proc_win_menu(element)
int element;
{
    win_type = element * PWCF_TTYPES;
    test_win = pw_open(17, 4, 5, 18, "Testbox", PWM_DEFAULT, element);
    pw_puts(test_win, " Normal text\n Highlighted text\n Reversed text\n Special text\n Active border");
    text_type = PWT_BORDER;
    update_testbox();
    pw_menu(6, 27, PWC_AUTO, PWC_AUTO, "Text types", text_menu, proc_text_menu, NULL);
    pw_close(test_win);
    test_win = NULL;
    return element;
}

proc_mon_menu(element)
int element;
{
    mon_type = element * PWCF_WINS * PWCF_TTYPES;
    pw_menu(6, 16, PWC_AUTO, PWC_AUTO, "Windows", win_menu, proc_win_menu, NULL);
    return element;
}

int proc_main_menu(element)
int element;
{
    switch (element)
    {
    case 0:                                 /* background */
        open_select_win(0);                 /* select chars */
        select_char(cf_backgr, default_backgr, BGCHAR, BACKGRSIZE);
        pw_close(select_win);
        break;
    case 1:                                 /* input char */
        open_select_win(0);                 /* select chars */
        select_char(cf_backgr, default_backgr, INPCHAR, BACKGRSIZE);
        pw_close(select_win);
        break;
    case 2:                                 /* borders */
        pw_menu(6, 3, PWC_AUTO, PWC_AUTO, "Border menu", border_menu, proc_border_menu, NULL);
        break;
    case 3:                                 /* colors */
        pw_menu(6, 3, PWC_AUTO, PWC_AUTO, "Monitor", mon_menu, proc_mon_menu, NULL);
        break;
    }
    return element;
}

void pwg_read_config(cfgfile)
char *cfgfile;
{
    FILE *fh = fopen(cfgfile, "rb");
    unsigned char tmp[ATTRIBSIZE];
    int c;
    
    if (fh)
    {
#ifdef FUTURE
        if (fread(tmp, 1, sizeof(cf_env), fh) == sizeof(cf_env))
            memcpy(cf_env, tmp, sizeof(cf_env));
#endif
        while (((c = fgetc(fh)) != EOF) && (c != '$'))
            ;
        if (fread(tmp, 1, sizeof(cf_backgr), fh) == sizeof(cf_backgr))
            memcpy(cf_backgr, tmp, sizeof(cf_backgr));
        if (fread(tmp, 1, sizeof(cf_border), fh) == sizeof(cf_border))
            memcpy(cf_border, tmp, sizeof(cf_border));
        if (fread(tmp, 1, sizeof(cf_attrib), fh) == sizeof(cf_attrib))
            memcpy(cf_attrib, tmp, sizeof(cf_attrib));
        fclose(fh);
    }
}

void pwg_write_config(cfgfile)
char *cfgfile;
{
    FILE *fh = fopen(cfgfile, "wb");

#ifdef FUTURE
    fwrite(cf_env, 1, sizeof(cf_env), fh);
#endif
    fprintf(fh, "POWER Config %s\n\26$", _pw_version);
    fwrite(cf_backgr, 1, sizeof(cf_backgr), fh);
    fwrite(cf_border, 1, sizeof(cf_border), fh);
    fwrite(cf_attrib, 1, sizeof(cf_attrib), fh);
    fclose(fh);
}

void argerror()
{
    fprintf(stderr, "Error in program %s: Invalid number of arguments\n", progname);
    fprintf(stderr, "Usage: %s Configfile[.PWC] [/B]", progname);
    exit(-1);
}

void iderror()
{
    fprintf(stderr, "Error in program %s: File '%s' is not a POWER config file\n", progname, cfgfile);
    fprintf(stderr, "Usage: %s Configfile[.PWC] [/B]", progname);
    exit(-2);
}

void fileerror()
{
    fprintf(stderr, "Error in program %s: Can't open config file '%s'\n", progname, cfgfile);
    fprintf(stderr, "Usage: %s Configfile[.PWC] [/B]", progname);
    exit(-2);
}

void main(argc, argv)
int   argc;
char *argv[];
{
    PWKEY key;
    char *ptr1;
    char *ptr2;
    FILE *fh;
    char id[13];

    if (pw_options(argc, argv) != 2)
    {
        argerror();
    }
    strncpy(cfgfile, argv[1], LEN_PATH-4);
    ptr1 = strrchr(cfgfile, '.');
    ptr2 = strrchr(cfgfile, '\\');
    if (ptr1 <= ptr2)                       /* no extension ? */
        strcat(cfgfile, ".PWC");
    if (fh = fopen(cfgfile, "rb+"))
    {
        if (!fgets(id, 13, fh) || strncmp(id, "POWER Config", 12))
            iderror();
        fclose(fh);                         /* file exists */
    }
    else
    {                                       /* file does not exist */
        if (fh = fopen(cfgfile, "wb"))
        {
            fclose(fh);
            unlink(cfgfile);
        }
        else
            fileerror();
        memcpy(cf_backgr, default_backgr, BACKGRSIZE); /* default backgrs */
        memcpy(cf_border, default_border, BORDERSIZE); /* default borders */
        memcpy(cf_attrib, default_attrib, ATTRIBSIZE); /* default borders */
    }
    fclose(fh);
    pwg_read_config(cfgfile);
    if (!pw_init(argv[0],NULL))
    {
        sprintf(scratch, "  %s  - %s - %s -  %s",
                         progname, _pw_date, _pw_ltsp, progver);
        pw_header(scratch);
        pw_menu(11, 28, PWC_AUTO, PWC_AUTO, "Main menu", main_menu, proc_main_menu, NULL);
        while ((key=pw_question("Save changes [Y/N]", "YN", PWW_ERROR)) == PWK_ESC)
        ;
        if (key == 'Y')
            pwg_write_config(cfgfile);
    }
    pw_exit(0);
}



