#include <string.h>
#include <ctype.h>                          /* for toupper() */
#include <malloc.h>                         /* for malloc(), free() */
#include "pwinc.h"
#include "pwmenu.h"

void main(int argc, char **argv);
static int ProcMainMenu(int Element);
static int ProcTopMenu(int Action, int Element);
static int ProcFileMenu(int Action, int Element);
static void MenuInitRecur(PWMENU *pMenu);
static PWKEY HandleKey(PWMENU *pMenu);
static PWKEY MenuEnter(PWMENU *pMenu);
static void MenuBlock(PWMENU *pMenu, int ttype);
static int MenuLetter(PWMENU *pMenu, PWKEY key);

static char *FilesMenuText[] = {
    "New", "Read", "Save", "DOS Shell", "Quit", NULL
};
static PWMENU FilesMenu = {
    PWM_DEFAULT,
    FilesMenuText,                          /* text */
    NULL,                                   /* active */
    NULL,                                   /* firstletter */
    NULL,                                   /* submenus */
    ProcFileMenu
};
static char *ReadMenuText[] = {
    "Drive", "Path", "Name", "Ext", NULL
};
static PWMENU ReadMenu = {
    PWM_DEFAULT,
    ReadMenuText,                          /* text */
    NULL,                                   /* active */
    NULL,                                   /* firstletter */
    NULL,                                   /* submenus */
    ProcTopMenu
};
static char *WriteMenuText[] = {
    "Drive", "Path", "Name", "Ext", NULL
};
static PWMENU WriteMenu = {
    PWM_DEFAULT,
    WriteMenuText,                          /* text */
    NULL,                                   /* active */
    NULL,                                   /* firstletter */
    NULL,                                   /* submenus */
    ProcTopMenu
};
static char *TopMenuText[] = {
    "Files", "Read", "Write", "Quit",
    "aaaaaaaaaaaaaaaaaaaaaaaaaAAAAAAAAAAAAAAAAAAAAAA", "A", "B", "C", "D",
    NULL
};
static PWMENU *TopMenuSub[] = {
    &FilesMenu, &ReadMenu, &WriteMenu, NULL, NULL, &WriteMenu, &WriteMenu, &WriteMenu, &WriteMenu
};
static PWMENU TopMenu = {
    PWM_HORIZONTAL | PWM_NOBORDER,
    TopMenuText,
    NULL,                                   /* active */
    NULL,                                   /* firstletter */
    TopMenuSub,                             /* submenus */
    ProcTopMenu
};
static char *MainMenu[] = {
    "Start", "Show", "Hide", "Stop", NULL
};

void main(int argc, char **argv)
{
    int MainElem = 0;

    pw_options(argc, argv);
    pw_init(argv[0], NULL);
    pw_menuinit(&TopMenu, 0, 0, 1, _pwv_scrncol);
    pw_menushow(&TopMenu);
    while (1)
    {
        pw_menu(6, 12, 0, 0, "Main menu", MainMenu, ProcMainMenu, &MainElem);
        pw_menukey(&TopMenu);
    }
}

static int ProcMainMenu(int Element)
{
    return Element;
}
static PWWIN *pBigWin;
static int ProcTopMenu(int Action, int Element)
{
    switch (Action)
    {
    case PWA_ENTER:
        switch (Element)
        {
        case 1: /* Read */
            pBigWin = pw_open(2, 1, 0, 0, "Read", PWM_DEFAULT, PWW_NORMAL);
            pw_puts(pBigWin, "Reading...");
            break;
        case 2: /* Write */
            pBigWin = pw_open(2, 1, 0, 0, "Write", PWM_DEFAULT, PWW_NORMAL);
            pw_puts(pBigWin, "Writing...");
            break;
        case 3: /* Quit */
            pw_exit(0);
            break;
        }
        break;
    case PWA_EXIT:
        switch (Element)
        {
        case 1: /* Read */
            pw_close(pBigWin);
            break;
        case 2: /* Wr */
            pw_close(pBigWin);
            break;
        }
        break;
    }
    return Element;
}


static int ProcFileMenu(int Action, int Element)
{
    switch (Action)
    {
    case PWA_ENTER:
        switch (Element)
        {
        case 3: /* DOS shell */
            pw_shell(NULL);
            break;
        case 4: /* Quit */
            pw_exit(0);
            break;
        }
        break;
    case PWA_EXIT:
        break;
    }
    return Element;
}

void pw_menushow(PWMENU *pMenu)
{
    pw_show(pMenu->pWin);
}

void pw_menuhide(PWMENU *pMenu)
{
    pw_hide(pMenu->pWin);
}

void pw_menuinit(PWMENU *pMenu, int srow, int scol, int nrow, int ncol)
{
    MenuInitRecur(pMenu);
    pMenu->Level = 0;
    pw_menuopen(pMenu, srow, scol, nrow, ncol);
}

static void MenuInitRecur(PWMENU *pMenu)
{
    int i = 0;

    pMenu->Element = 0;
    if (pMenu->SubMenu)
    {
        while (pMenu->Text[i])
        {
            if (pMenu->SubMenu[i])
                MenuInitRecur(pMenu->SubMenu[i]);
            i++;
        }
    }
}

static char pw_AltTable[] = "QWERTYUIOP@@@@ASDFGHJKL@@@@@ZXCVBNM";
void pw_menuopen(PWMENU *pMenu, int srow, int scol, int nrow, int ncol)
{
    int Len = 0;
    int Pos = 1;
    int i;

    pMenu->nElem = 0;
    if (pMenu->Type & PWM_HORIZONTAL)
    {
        nrow = 1;
        while ((Len < ncol) && (pMenu->Text[pMenu->nElem]))
            Len = Len + strlen(pMenu->Text[pMenu->nElem++]) + 1;
        if (Len > ncol)
            pMenu->nElem--;
        pMenu->Pos = malloc(sizeof(int)*(pMenu->nElem+1));
        for (i=0; i<pMenu->nElem; i++)
        {
            pMenu->Pos[i] = Pos;
            Pos = Pos + strlen(pMenu->Text[i]) + 1;
        }
        pMenu->Pos[pMenu->nElem] = Pos;
    }
    else
    {
        ncol = 0;
        nrow = 0;
        while (pMenu->Text[nrow])
        {
            if (ncol < strlen(pMenu->Text[nrow]))
                ncol = strlen(pMenu->Text[nrow]);
            nrow++;
        }
        pMenu->nElem = nrow;
        pMenu->Pos = NULL;
    }
    if (scol > _pwv_scrncol - ncol - 1)
    {
        scol = _pwv_scrncol - ncol - 1;
        if (pMenu->Type & PWM_NOBORDER)
            scol++;
    }
    pMenu->pWin = pw_open(srow, scol, nrow, ncol, "", pMenu->Type & PWM_MODEMASK, PWW_MENU);
    for (i=0; i<pMenu->nElem; i++)
    {
        if (pMenu->Type & PWM_HORIZONTAL)
            pw_putsat(pMenu->pWin, 0, pMenu->Pos[i], pMenu->Text[i]);
        else
            pw_putsat(pMenu->pWin, i, 0, pMenu->Text[i]);
    }
}

void pw_menuclose(PWMENU *pMenu)
{
    if (pMenu->Pos)
        free(pMenu->Pos);
    pw_close(pMenu->pWin);
}

PWKEY pw_menukey(PWMENU *pMenu)
{
    int Element = pMenu->Element;
    PWKEY ret = 0;

    pw_block(pMenu->pWin, 0, 0, 0, 0, PWT_NORMAL);
    MenuBlock(pMenu, PWT_REVERSE);
    pMenu->Level = 0;
    while (ret == 0)
    {
        switch(HandleKey(pMenu))
        {
        case PWK_ESC:
            ret = PWK_ESC;
            break;
        }
    }
    pw_block(pMenu->pWin, 0, 0, 0, 0, PWT_NORMAL);
    return ret;
}

static PWKEY HandleKey(PWMENU *pMenu)
{
    PWKEY key;
    PWKEY ret = 0;
    int newkey = 1;
    int Elem = pMenu->Element;

    while (ret == 0)
    {
        if (newkey)
            key = pw_getkey();
        else
            newkey = 1;
        if (pMenu->Type & PWM_HORIZONTAL)
        {
            switch (key)
            {
            case PWK_ESC:
                ret = key;
                break;
            case PWK_LEFT:
                if (Elem > 0)
                    Elem--;
                else
                    Elem = pMenu->nElem-1;
                break;
            case PWK_RIGHT:
                if (Elem < pMenu->nElem-1)
                    Elem++;
                else
                    Elem = 0;
                break;
            case PWK_HOME:
            case PWK_CLEFT:
                Elem = 0;
                break;
            case PWK_END:
            case PWK_CRIGHT:
                Elem = pMenu->nElem-1;
                break;
            case PWK_ENTER:
            case PWK_DOWN:
                if ((key = MenuEnter(pMenu)) != PWK_ESC)
                    newkey = 0;
                break;
            default:
                if ((Elem = MenuLetter(pMenu, key)) < 0)
                    Elem = pMenu->Element;
                break;
            }
        }
        else
        {
            switch (key)
            {
            case PWK_LEFT:
            case PWK_RIGHT:
            case PWK_ESC:
                ret = key;
                break;
            case PWK_UP:
                if (Elem > 0)
                    Elem--;
                else
                    ret = key;
                break;
            case PWK_DOWN:
                if (Elem < pMenu->nElem-1)
                    Elem++;
                else
                    ret = key;
                break;
            case PWK_HOME:
            case PWK_PGUP:
                Elem = 0;
                break;
            case PWK_END:
            case PWK_PGDN:
                Elem = pMenu->nElem-1;
                break;
            case PWK_ENTER:
                if (pMenu->ProcessFunc)
                    pMenu->ProcessFunc(PWA_ENTER, Elem);
                break;
            default:
                if ((Elem = MenuLetter(pMenu, key)) < 0)
                    Elem = pMenu->Element;
                break;
            }
        }
        if (Elem != pMenu->Element)
        {
            MenuBlock(pMenu, PWT_NORMAL);
            pMenu->Element = Elem;
            MenuBlock(pMenu, PWT_REVERSE);
            if (pMenu->Level)
            {
                if (pMenu->SubMenu && pMenu->SubMenu[Elem])
                    if ((key = MenuEnter(pMenu)) != PWK_ESC)
                        newkey = 0;
            }
        }
    }
    return ret;
}

static PWKEY MenuEnter(PWMENU *pMenu)
{
    PWKEY key;
    PWKEY ret = 0;
    PWMENU *pSub;
    int Elem = pMenu->Element;

    if (pMenu->ProcessFunc)
        pMenu->ProcessFunc(PWA_ENTER, Elem);
    pMenu->Level = 1;
    if (pMenu->SubMenu && (pSub = pMenu->SubMenu[Elem]))
    {
        pw_menuopen(pSub, pMenu->pWin->tsrow+pMenu->pWin->tnrow+1, pMenu->Pos[Elem], 0, 0);
        MenuBlock(pSub, PWT_REVERSE);
        while (ret == 0)
        {
            switch (key = HandleKey(pSub))
            {
            case PWK_LEFT:
            case PWK_RIGHT:
                ret = key;
                break;
            case PWK_ESC:
            case PWK_UP:
                pMenu->Level = 0;
                ret = key;
                break;
            }
        }
        pw_close(pSub->pWin);
    }
    if (pMenu->ProcessFunc)
        pMenu->ProcessFunc(PWA_EXIT, Elem);
    return ret;
}

static void MenuBlock(PWMENU *pMenu, int ttype)
{
    if (pMenu->Type & PWM_HORIZONTAL)
        pw_block(pMenu->pWin, 0, pMenu->Pos[pMenu->Element]-1, 1, pMenu->Pos[pMenu->Element+1] - pMenu->Pos[pMenu->Element] + 1, ttype);
    else
        pw_block(pMenu->pWin, pMenu->Element, 0, 1, 0, ttype);
}

static int MenuLetter(PWMENU *pMenu, PWKEY key)
{
    int Elem = pMenu->Element;

    if ((key > 0) && (key <256))
    {
        key = toupper(key);
        do {
            if (++Elem >= pMenu->nElem)
                Elem = 0;
        } while ((Elem != pMenu->Element) && (toupper(*(pMenu->Text[Elem])) != (int)key));
        if (toupper(*(pMenu->Text[Elem])) != (int)key)
            Elem = -1;
    }
    return Elem;
}



