/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWMUTI.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       MS-DOS dependent utility functions for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <string.h>                         /* for str*() */
#include <process.h>                        /* for system() */
#include "pwinc.h"                          /* main include file */

static void pws_header(char *s, int row, int *col, unsigned char attrib);

static union REGS regs;

#ifdef MOUSE
#define PWL_MOU_LEFT    0
#define PWL_MOU_RIGHT   1
#define PWL_MOU_UP      2
#define PWL_MOU_DOWN    3
#define PWL_MOU_LBUT    4
#define PWL_MOU_MBUT    5
#define PWL_MOU_RBUT    6
static int mou_present = 0;
static int mou_hcnt = 0;
static int mou_vcnt = 0;
static int mou_speed = 230;
#define MOUSE_STEP  (256-mou_speed)
#endif

void pws_mon(void)
{
    if (_pwcf_mon == PWCF_CGACOLOR)
    {
        regs.h.ah = 0x1a;
        regs.h.al = 0x00;
        int86(0x10, &regs, &regs);          /* Read display codes */
        switch (regs.h.bl)                  /* active display code */
        {
        case 1:                             /* MDA + monochrome */
        case 5:                             /* EGA + monochrome */
        case 7:                             /* VGA + monochrome */
        case 11:                            /* MCGA (Model 30) + monochrome */
            _pwcf_mon = PWCF_CGAMONO;       /* CGA/EGA/VGA+mono mon */
            break;
        }
    }
}

int pws_shell(void)
{
    int ret;
    char exit_message[SCRATCH_LEN];
    int col = 0;
    int r, c;

    pws_GetCursor(&r, &c);
    if ((ret = system("cls")) == 0)
    {
        sprintf(exit_message, "  POWER %s shell  ", _pw_version);
        pws_header(exit_message, 0, &col, 0x2e);      /* yellow on green */
        sprintf(exit_message, "  Type 'EXIT' to return to the POWER application           ");
        pws_header(exit_message, 0, &col, 0x2f);      /* white on green */
        ret = system("command");
    }
    pws_cursor(r, c);
    return ret;
}

static void pws_header(char *s, int row, int *col, unsigned char attrib)
{
    unsigned char page;

    regs.h.ah = 0x0f;                       /* get current displ mode */
    int86(0x10, &regs, &regs);              /* video service --> bh = page */
    page = regs.h.bh;
    while (*s)
    {
        pws_cursor(row, (*col)++);
        regs.h.ah = 0x09;
        regs.h.al = *(s++);
        regs.h.bh = page;
        regs.h.bl = attrib;
        regs.x.cx = 1;
        int86(0x10, &regs, &regs);
    }
}

#ifdef MOUSE
void pws_MouInit(void)
{
    regs.x.ax = 0x00;
    mou_present = 0;
#ifdef __TURBOC__
    if (getvect(0x33) != NULL)              /* does it support INT 33 ? */
#else
    if (_dos_getvect(0x33) != NULL)         /* does it support INT 33 ? */
#endif
    {
        int86(0x33, &regs, &regs);
        mou_present = regs.x.ax;
    }
}

void pws_MouReset(void)
{
    if (mou_present)
    {
        regs.x.ax = 0x0b;                   /* read mouse motion counters */
        int86(0x33, &regs, &regs);          /* read to reset counters */
        regs.x.ax = 0x05;                   /* get button press info */
        regs.x.bx = 0x00;                   /* left button */
        int86(0x33, &regs, &regs);          /* reset press count */
        regs.x.ax = 0x05;                   /* get button press info */
        regs.x.bx = 0x01;                   /* right button */
        int86(0x33, &regs, &regs);          /* reset press count */
    }
}

void pws_MouScan(PWKEY *pKey, PWKEY *pw_mou_key)
{
    if (mou_present)
    {
        regs.x.ax = 0x0b;                   /* read mouse motion counters */
        int86(0x33, &regs, &regs);          /* read to reset counters */
        mou_hcnt += regs.x.cx;
        mou_vcnt += regs.x.dx;
        if (mou_hcnt < -MOUSE_STEP/2)
        {
            *pKey = pw_mou_key[PWL_MOU_LEFT];
            mou_hcnt += MOUSE_STEP/2;
        }
        if (mou_hcnt > MOUSE_STEP/2)
        {
            *pKey = pw_mou_key[PWL_MOU_RIGHT];
            mou_hcnt -= MOUSE_STEP/2;
        }
        if (mou_vcnt < -MOUSE_STEP)
        {
            *pKey = pw_mou_key[PWL_MOU_UP];
            mou_vcnt += MOUSE_STEP;
        }
        if (mou_vcnt > MOUSE_STEP)
        {
            *pKey = pw_mou_key[PWL_MOU_DOWN];
            mou_vcnt -= MOUSE_STEP;
        }
        regs.x.ax = 0x05;                   /* get button press info */
        regs.x.bx = 0x00;                   /* left button */
        int86(0x33, &regs, &regs);
        if (regs.x.bx)
            *pKey = pw_mou_key[PWL_MOU_LBUT];
        regs.x.ax = 0x05;                   /* get button press info */
        regs.x.bx = 0x01;                   /* right button */
        int86(0x33, &regs, &regs);
        if (regs.x.bx)
            *pKey = pw_mou_key[PWL_MOU_RBUT];
    }
}
#endif

PWKEY pws_getkey(void)
{
    PWKEY key;

    regs.h.ah = 7;                          /* readkb, no echo, no ^C */
    intdos(&regs, &regs);                   /* DOS service */
    if (regs.h.al)
        key = (PWKEY)regs.h.al;             /* normal key */
    else
    {                                       /* extended key --> get again */
        regs.h.ah = 7;                      /* readkb, no echo, no ^C */
        intdos(&regs, &regs);               /* DOS service */
        key = (regs.h.al << 8);
    }
    return key;
}

void pws_GetCursor(int *pRow, int *pCol)
{
    regs.h.ah = 0x0f;                       /* get current displ mode */
    int86(0x10, &regs, &regs);              /* video service --> bh = page */
    regs.h.ah = 0x03;                       /* read cursor position */
    int86(0x10, &regs, &regs);              /* video service */
    *pCol = regs.h.dl;                      /* cursor column */
    *pRow = regs.h.dh;                      /* cursor row */
}

void pws_cursor(int row, int col)
{
    regs.h.ah = 2;                          /* set cursor position */
    regs.h.bh = 0;                          /* page 0 */
    regs.h.dl = (unsigned char)col;
    regs.h.dh = (unsigned char)row;
    int86(0x10, &regs, &regs);              /* BIOS video service */
}

