#ifndef MIB2
#define MIB2

#define MIB_SZEOTS  255
#define MIB_SZECOM  255
#define MIB_SZEOJI  63

typedef struct _mib_obj
{
    unsigned        ObjOji [MIB_SZEOJI];
    unsigned        ObjOjiLen;
    unsigned        (*ObjRqsGet) (pkt_obj *Obj, void *Arg);
    unsigned        (*ObjRqsNxt) (pkt_obj *Obj, void *Arg);
    unsigned        (*ObjRqsSet) (pkt_obj *Obj, void *Arg);
    void            *ObjRqsArg;
    struct _mib_obj *ObjNxt;
}
    mib_obj;

typedef struct _mib_prf
{
    char            PrfCom [MIB_SZECOM];
    unsigned        PrfComLen;
    mib_obj         *PrfObj;
    struct _mib_prf *PrfNxt;
}
    mib_prf;

typedef struct
{
	mib_prf		    *SckPrf;
    char            SckDsc [MIB_SZEOTS];
    char            SckCtt [MIB_SZEOTS];
    char            SckNme [MIB_SZEOTS];
    char            SckLoc [MIB_SZEOTS];
    int             SckSrv;
	long unsigned	SckTotSet;
	long unsigned	SckTotGet;
}
	mib_sck;

extern mib_sck
    MibSck;

int 
    MibIni
    (
        void
    );
void
    MibPol
    (
        void
    );

mib_prf
    *MibAddPrf
    (
        char        *Com,
        unsigned    ComLen
    );

int
    MibAddObj
    (
        mib_prf     *Prf,
        unsigned    *Oji,
        unsigned    OjiLen,
        unsigned    (*RqsGet) (pkt_obj *Obj, void *Arg),
        unsigned    (*RqsNxt) (pkt_obj *Obj, void *Arg),
        unsigned    (*RqsSet) (pkt_obj *Obj, void *Arg),
        void        *RqsArg
    );


#endif
