/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPIF.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:
**     CREATION DATE:       1990/5/10
**
** DESCRIPTION:  Contains the interface between the IP layer
**               and the datalink layer (interface drivers).
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   IPIF.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/IFACE/VCS/IPIF.C_V  $
**              
**                 Rev 1.1   21 Nov 1990 14:38:22   etstjan
**              No explicit note
**              
**                 Rev 1.0   20 Nov 1990 15:34:54   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/IFACE/VCS/IPIF.C_V   1.1   21 Nov 1990 14:38:22   etstjan  $";
#endif

#include    <stdlib.h>
#include    <string.h>
#include    <stdio.h>
#include    <power3.h>
#include    <beholder.h>                     /* Network Packet Dispatcher */

#include    "ipcodes.h"
#include    "ip.h"
#include    "iplib.h"
#include    "ipif.h"
#include    "ipevents.h"
#include    "ipether.h"
#include    "iploop.h"
#include    "iplayer.h"
 
/* global variables */
IFDESCRIPTOR   *FirstIf = NULL;          /* pointer to start of if list */

/**************************************************************
** NAME:        AddressSearch
** SYNOPSIS:    IFADDRESS *AddressSearch(
**                                IFADDRESS *AddPoint,
**                                ADDRESS_T Search_Add,
**                                ADDRESS_T Mask);
** DESCRIPTION: Searches for address Search_Add in the
**              address list AddPoint. Each HostAddress is
**              anded with Mask before comparing. Search_Add
                should be masked before calling this routine.
** RETURNS:     NULL  -->   Address not found
**              else  -->   Address of IFADDRESS structure
**************************************************************/
IFADDRESS *AddressSearch(IFADDRESS *AddPoint, ADDRESS_T Search_Add,
                         ADDRESS_T Mask)
{
  while ((AddPoint != NULL) &&
         (ntohl(AddPoint->ThisAddress & Mask) < ntohl(Search_Add))) {
     AddPoint = AddPoint->NextAddress;
     }
  return (AddPoint == NULL) ? NULL :
         ((AddPoint->ThisAddress & Mask) == Search_Add) ? AddPoint : NULL;
}


/**************************************************************
** NAME:        AddIfAddress
** SYNOPSIS:    int AddIfAddress(IFADDRESS **ListStart,
**                               ADDRESS_T NewAddress,
**                               ADDRESS_T B_P_Address);
** DESCRIPTION: Adds NewAddress to an interfaces address
**              list. ListStart contains the address of the
**              start of the address list. Addresses are
**              sorted when added. B_P_Address contains
**              the broadcast or point to point address,
**              depending on the interface. When an
**              address already exists, it will be
**              updated.
** RETURNS:     NO_ERR    --> everything ok
**              NO_SPACE  --> no buffer space
**************************************************************/
int AddIfAddress(IFADDRESS **ListStart,
                  ADDRESS_T NewAddress,
                  ADDRESS_T B_P_Address)
{
  IFADDRESS   *CurAddress;
  IFADDRESS   **PrevAddress;
  IFADDRESS   *NewAd;

  PrevAddress = ListStart;
  CurAddress = *ListStart;
  while ((CurAddress != NULL) &&
	 (ntohl(NewAddress) > ntohl(CurAddress->ThisAddress))) {
    PrevAddress = &(CurAddress->NextAddress);
    CurAddress = CurAddress->NextAddress;
    }

  if ((CurAddress != NULL) && (NewAddress == CurAddress->ThisAddress)) {
    CurAddress->BroadCastAd = B_P_Address;         
    }
  else {
    if ((NewAd = IPBufGet(sizeof(IFADDRESS))) == NULL ) {
      return NOSPACE;
      }
    else {
      NewAd->ThisAddress = NewAddress;
      NewAd->BroadCastAd = B_P_Address;
      *PrevAddress = NewAd;
      NewAd->NextAddress = CurAddress;
      }
    }
  return NO_ERR;
}

/**************************************************************
** NAME:        InitIfLayer
** SYNOPSIS:    int InitIfLayer(void);
**
** DESCRIPTION: Initializes the interface layer and the
**              necessary device drivers. 
** RETURNS:     NO_ERR   -->   no error
**              NO_SPACE -->   insufficient buffer space
**              else           error code from device drivers.
**************************************************************/
int InitIfLayer(void)
{
  int           RetCode;
  IFDESCRIPTOR  *NewIf;

  if ((NewIf = IPBufGet(sizeof(IFDESCRIPTOR))) == NULL) {
    return NOSPACE;
    }
  memset(NewIf, 0, sizeof(IFDESCRIPTOR));    /* clear descriptor */
  strncpy(NewIf->IfName, "ND0", 15);
  NewIf->Mms_S = ETHER_MMS_S;     /* maximum packet size Ethernet packet */
  NewIf->Mms_R = ETHER_MMS_R;
  NewIf->Flags = IF_DEBUG;
  /* initialize interface driver */
  if ((RetCode = IPEtherInit(NewIf)) != NO_ERR) {   
    return RetCode;                     /* an error occured -> quit */
    }

  FirstIf = NewIf;

  /* initialize other interfaces here */

  if ((NewIf = IPBufGet(sizeof(IFDESCRIPTOR))) == NULL) {
    return NOSPACE;
    }
  memset(NewIf, 0, sizeof(IFDESCRIPTOR));    /* clear descriptor */
  NewIf->IfName[15] = 0;                     /* garantuee null char */
  strncpy(NewIf->IfName, "LO0", 15);
  NewIf->Mms_S = LOOP_MMS_S;                 /* maximum packet size */
  NewIf->Mms_R = LOOP_MMS_R;
  NewIf->Flags = IF_DEBUG | IF_LOOPBACK | IF_POINTPOINT | IF_NOARP;

  /* initialize interface driver */
  if ((RetCode = IPLoopInit(NewIf)) != NO_ERR) { 
    return RetCode;                          /* an error occured -> quit */
    }

  FirstIf->NextIf = NewIf;
  return NO_ERR;
}

/**************************************************************
** NAME:        IfConfig
** SYNOPSIS:    int IfConfig(char *InterfName,
**                           ADDRESS_T HostAddress,
**                           ADDRESS_T HostMask,
**                           ADDRESS_T DestAdd);
**
** DESCRIPTION: Configures interface 'InterfName' with
**              HostAddress and HostMask. For point to point
**              connections, DestAdd is the point to point
**              address. Else, it is the broadcast address.
**              For the time being, 'InterfName' is
**              "ND0" or "LO0".
** RETURNS:     NO_ERR      -->   no error
**              NOT_FOUND   -->   interface unknown
**              NOSPACE     -->   no buffer space left
**              else        -->   error code
**************************************************************/
int IfConfig(char *InterfName, ADDRESS_T HostAddress,
             ADDRESS_T HostMask, ADDRESS_T DestAdd)
{
  IFDESCRIPTOR *IfList;
  int          RetCode;

  for (IfList = FirstIf;
       (IfList != NULL) && (strcmp(IfList->IfName, InterfName) != 0);
       IfList = IfList->NextIf)
    ;
  if (IfList == NULL) {
    return NOT_FOUND;
    }
    
  if ((RetCode = AddIfAddress(&(IfList->FirstAdd),
                              HostAddress, DestAdd)) != NO_ERR) {
    return RetCode;                 /* an error occured -> quit */
    }

  if (AddIPAddress(HostAddress, GetNetMask(HostAddress),
                   HostMask & ~GetNetMask(HostAddress),
                   IfList, &HostAddresses) == NULL) {
    return NOSPACE;                 /* an error occured -> quit */
    }
  return NO_ERR;
}
