/*

   CRDIR.H

*/

#ifndef _CRDIR_H
#define _CRDIR_H

#include <stddef.h>
#include "ccommon.h"
#include "cdirent.h"
#include "cio.h"

#define CRDIR_MAX_DEPTH 34
#define CRDIR_MAX_PATH 2048
#define CRDIR_MAX_FILE 300
#define CRDIR_MAX_PATHNAME (CRDIR_MAX_PATH+CRDIR_MAX_FILE)

#define CRDIR_RET_DIRS  (0x0200)
#define CRDIR_GO_DIRS   (0x0400)
#define CRDIR_REL_PATH  (0x0800)
#define CRDIR_MATCH_CASE CDIR_MATCH_CASE
#define CRDIR_MATCH_ALL CDIR_MATCH_ALL
#define CRDIR_MATCH_LFN CDIR_MATCH_LFN
#define CRDIR_DEFAULT   (CRDIR_GO_DIRS|CRDIR_RET_DIRS)

struct _CRDIR_struct
{
   CDIR *cdir_list[CRDIR_MAX_DEPTH];
   int cdir_depth;
   int options;
   struct c_dirent *mem_dir;
   size_t spn_end_pos[CRDIR_MAX_DEPTH];
   size_t pn_end_pos[CRDIR_MAX_DEPTH];
   char spn[CRDIR_MAX_PATHNAME];       /* short pathname */
   char pn[CRDIR_MAX_PATHNAME];        /* normal pathname */
   char pat[CRDIR_MAX_FILE];
};
typedef struct _CRDIR_struct CRDIR;

CRDIR *c_openrdir(char *dir, char *pat, int options);
struct c_dirent *c_readrdir(CRDIR *crd);
void c_closerdir(CRDIR *crd);
#define c_getpath(crd) ((crd)->pn)
#define c_getspath(crd) ((crd)->spn)

#endif
