program makebook;

uses novell;

var
 replyid : longint;
 replytype : integer;
 replyname : string;
 replyflag : integer;
 replysecurity : byte;
 replyproperties : integer;
 pretcode : integer;
 realname : string;
 firstname, lastname, notes : string;
 initial : string[1];
 i : byte;
 servername : string;
 servernum : integer;
 retcode : integer;

const
 lastseen : longint = -1;
 object_type : integer = 1;
 object_name : string = '*';
 namecode : integer = 0;
 outputtype : (normal,SMTP,HTML,ALIAS) = normal;
 maxservers = 8;

function tolower(thisstring:string):string;
var i: integer;
begin
 for i := 1 to length(thisstring) do
  if thisstring[i] in ['A'..'Z'] then
    thisstring[i] := chr(ord(thisstring[i]) + ord('a') - ord('A'));
 tolower := thisstring;
end;

begin

 if paramcount>0 then begin
   if tolower(paramstr(1)) = 'smtp' then
     outputtype := SMTP
   else if tolower(paramstr(1)) = 'html' then
     outputtype := HTML
   else if tolower(paramstr(1)) = 'alias' then
     outputtype := ALIAS
   else begin
     writeln('MAKEBOOK: Writes an address book to standard output - v3.0, 20 February 1997');
     writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
     writeln;
     writeln('SYNTAX: MAKEBOOK [SMTP | HTML | ALIAS [<machine name>|.<domain name>]]');
     halt;
   end;
 end;

 for servernum := 1 to maxservers do begin
   set_preferred_connection_id(servernum);

   getserverinfo;
   servername := tolower(serverinfo.name);
   if paramcount>1 then
     if copy(paramstr(2),1,1) = '.' then
       servername := servername + tolower(paramstr(2))
     else
       servername := tolower(paramstr(2));

   repeat
     scan_object(lastseen, object_type, object_name, replyid, replytype,
       replyname, replyflag, replysecurity, replyproperties, retcode);
     lastseen := replyid;
     if retcode = 0 then
       begin
         get_realname(replyname,realname,namecode);
         if (namecode=0) and (realname[1]<>' ') then
           begin
             i:=1;
             firstname:='';
             lastname:='';
             notes:='';
             while (realname[i]<>' ') and (i<=length(realname)) do begin
               if realname[i]<>',' then firstname:=firstname+realname[i];
               i:=i+1;
             end;
             while (realname[i]=' ') and (i<=length(realname)) do
               i:=i+1;
             while (realname[i]<>' ') and (i<=length(realname)) do begin
               if realname[i]<>',' then lastname:=lastname+realname[i];
               i:=i+1;
             end;
             if lastname = '' then initial := '' else initial := lastname[1];
             while (realname[i]=' ') and (i<=length(realname)) do
               i:=i+1;
             while i<=length(realname) do begin
               notes:=notes+realname[i];
               i:=i+1;
             end;
             case outputtype of
               normal:
                 begin
                   writeln('Name:            '+firstname+' '+lastname);
                   writeln('Key:             '+copy(firstname+initial,1,11));
                   writeln('E-mail address:  '
                     +servername+'/'+tolower(replyname));
                   writeln('Notes:           '+notes);
                   writeln('--');
                   writeln;
                 end;
               SMTP:
                 begin
                   writeln('Name:            '+firstname+' '+lastname);
                   writeln('Key:             '+copy(firstname+initial,1,11));
                   writeln('E-mail address:  '
                     +tolower(replyname)+'@'+servername);
                   writeln('Notes:           '+notes);
                   writeln('--');
                   writeln;
                 end;
               HTML:
                 begin
                   repeat
                     firstname := firstname + ' '
                   until length(firstname) >= 12;
                   repeat
                     lastname := lastname + ' '
                   until length(lastname) >= 12;
                   writeln('<TR><TD>'+firstname+' '+lastname
                     +'</TD><TD>'+notes+'</TD><TD>'
                     +'<A HREF="'+tolower(replyname)+'@'+servername+'">'
                     +tolower(replyname)+'@'+servername+'<A></TD></TR>');
                 end;
               ALIAS:
                 writeln(firstname+'.'+lastname+'@'+servername+' == '
                   +replyname);
             end;
         end;
       end;
   until retcode <> 0;
 end;
end.
