
/*

psc tli routines

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <dos.h>
#include <io.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <direct.h>
#include <process.h>
#include <conio.h>
#include <ctype.h>


#include "common.h"
#include "psc.h"





typedef struct oSapQueryPkt {
   WORD          checksum;             /* high-low 1's complement */
   WORD          length;               /* high-low unsigned int */
   BYTE          transportControl;
   BYTE          packetType;
   IPXAddress    destination;
   IPXAddress    source;
   WORD          sapType;            /* high-low, 1 or 3 */
   WORD          serverType;           /* high-low, assigned by Novell */
} SAPQRYPKT, far * LPSAPQRYPKT;

typedef struct oQryPkt {
   ECB         sapECB;
   SAPQRYPKT   sapPkt;
} SAPQRY, far * LPQRY;





typedef struct oSapBroad {
   WORD          checksum;             /* high-low 1's complement */
   WORD          length;               /* high-low unsigned int */
   BYTE          transportControl;
   BYTE          packetType;
   IPXAddress    destination;
   IPXAddress    source;
   WORD          sapType;        /* 2 or 4 */
   WORD          serverType;           /* assigned by Novell */
   BYTE          serverName[48];       /* VAP name */
   IPXAddress    serverAddress;        /* server internetwork address */
   WORD          interveningNetworks;  /* # of networks packet must traverse */
} SAPBROADPKT, far * LPSAPBROADPKT;


typedef struct oBroadPkt {
   ECB         sapECB;
   SAPBROADPKT sapPkt;
} SAPBROAD, far * LPSAPBROAD;





#define  SAPWAIT_TICKS  ((WORD)(18.2*3))
#define  NUM_SAP_BUFFS  5




static BOOL FindServer(LPBYTE svrName, WORD svrType, LPADDR svrAddr) {
   BOOL  found= FALSE;
   WORD  sock;
   int   i,nRetry;
   WORD  tvalue,tmark;
   SAPQRY   sapQry;
   SAPBROAD sapBrd[ NUM_SAP_BUFFS ];



   sock= 0;
   if( IPXOpenSocket( (LPBYTE)&sock , SHORT_LIVED) != SUCCESSFUL ) return FALSE;


   for(i=0; i<NUM_SAP_BUFFS; i++){
      sapBrd[i].sapECB.ESRAddress= NULL;
      sapBrd[i].sapECB.inUseFlag = 0;
      sapBrd[i].sapECB.socketNumber= sock;
      memset( (LPBYTE)sapBrd[i].sapECB.immediateAddress, 255, 6);
      sapBrd[i].sapECB.fragmentCount= 1;
      sapBrd[i].sapECB.fragmentDescriptor[0].address= (void far *)&sapBrd[i].sapPkt;
      sapBrd[i].sapECB.fragmentDescriptor[0].size= sizeof(SAPBROADPKT);
   }



   sapQry.sapECB.ESRAddress= NULL;
   sapQry.sapECB.inUseFlag = 0;
   sapQry.sapECB.socketNumber= sock;
   memset( (LPBYTE)sapQry.sapECB.immediateAddress, 255, 6);
   sapQry.sapECB.fragmentCount= 1;
   sapQry.sapECB.fragmentDescriptor[0].address= (void far *)&sapQry.sapPkt;
   sapQry.sapECB.fragmentDescriptor[0].size= sizeof(SAPQRYPKT);

   sapQry.sapPkt.length      = NWWordSwap( sizeof(SAPQRYPKT) );
   sapQry.sapPkt.packetType  = 4;

   memset( (LPBYTE)&sapQry.sapPkt.destination.network, 0, 4);
   memset( (LPBYTE)&sapQry.sapPkt.destination.node,  255, 6);
   *((LPWORD)sapQry.sapPkt.destination.socket)= NWWordSwap( SAP_SOCKET );

   IPXGetInternetworkAddress( (LPBYTE)&sapQry.sapPkt.source );
   *((LPWORD)sapQry.sapPkt.source.socket)= sock;

   sapQry.sapPkt.sapType      = NWWordSwap(3);
   sapQry.sapPkt.serverType   = NWWordSwap(svrType);




   for(i=0; i<NUM_SAP_BUFFS; i++) IPXListenForPacket( &sapBrd[i].sapECB );

   nRetry= 3;
   found = FALSE;
   while( nRetry-- && !found ){
      if( !sapQry.sapECB.inUseFlag ) IPXSendPacket( &sapQry.sapECB );

      tmark= IPXGetIntervalMarker();

      while( !found ){
         tvalue= IPXGetIntervalMarker();

         if( tvalue >= tmark ){
            if( tvalue-tmark >= SAPWAIT_TICKS ) break;
         }
         else if( (0xFFFF-tmark)+tvalue >= SAPWAIT_TICKS ) break;

         for(i=0; i<NUM_SAP_BUFFS; i++){

            IPXRelinquishControl();

            if( !sapBrd[i].sapECB.inUseFlag ){
               if( sapBrd[i].sapPkt.sapType == NWWordSwap( 4 ) ){
                  if( strcmp( sapBrd[i].sapPkt.serverName , svrName ) == 0 ){
                     memcpy( (LPBYTE)svrAddr, (LPBYTE)&sapBrd[i].sapPkt.serverAddress, sizeof(IPXAddress));
                     found= TRUE;
                     break;
                  }
               }
               IPXListenForPacket( &sapBrd[i].sapECB );
               tmark= IPXGetIntervalMarker();
            }
         }
      }
   }

   if( sapQry.sapECB.inUseFlag ) IPXCancelEvent( &sapQry.sapECB );

   for(i=0; i<NUM_SAP_BUFFS; i++){
      if( sapBrd[i].sapECB.inUseFlag ) IPXCancelEvent( &sapBrd[i].sapECB );
   }

   IPXCloseSocket( sock );
   return found;
}
















int checkEndpoint( TLIINT	td ){
	int	v;
	
	v = t_look(td);
	
	if( v== T_DISCONNECT || v== T_ORDREL )
		v = FALSE;
	else
		v = TRUE;
		
	return v;
}






static int  SendData(LPBYTE buf, int tlen, TLIINT  fd){
   int   len, nBytesSent, nBytes2Send;

   nBytesSent = 0;
   nBytes2Send = tlen;

   while( nBytes2Send ){
      IPXRelinquishControl();

   	if( !checkEndpoint(fd) ) return FALSE;
   	
      len = t_snd( fd, buf+nBytesSent, nBytes2Send, 0 );
      
      if( len > 0 ){
         nBytesSent += len;
         nBytes2Send -= len;
      }
   }

   return TRUE;
}






static int ReadData(LPBYTE buf, int tlen, TLIINT fd){
   int   len, nBytesRead, nBytes2Read, flag;

   nBytesRead = 0;
   nBytes2Read = tlen;

   while( nBytes2Read ){
      IPXRelinquishControl();

   	if( !checkEndpoint(fd) ) return FALSE;
		
      len = t_rcv( fd, buf+nBytesRead, nBytes2Read, &flag );
      
      if( len > 0 ){
         nBytesRead += len;
         nBytes2Read -= len;
      }
   }

   return TRUE;
}

















static BOOL doUpgrade(TLIINT fd){
   UPGCMD      cmd;
   FILE        *outf;
   LPBYTE      outfname,tmpfname;
   BOOL        rval;

   tmpfname= "psc.tmp";
   outfname= "psc.exe";

   if( (outf= fopen(tmpfname,"wb")) != NULL ){
      for(;;){

         if( !ReadData((LPBYTE)&cmd, sizeof(UPGCMD), fd) ){
            fclose(outf);
            remove(tmpfname);
			   rval= FALSE;
            break;
	      }

         if( cmd.cmd == UCMD_DATA )

            fwrite( cmd.buff,1,cmd.len,outf);

         else if(cmd.cmd == UCMD_EOF ){
            fclose(outf);
            if( !remove( outfname ) )
               rename( tmpfname, outfname );
            else
               remove( tmpfname );

			   rval= TRUE;
            break;
         }
      }
   }
   else rval= FALSE;

   return rval;
}















int upgConnect( LPGLOBALS gl,LPBYTE svrName, WORD svrType, LPADDR svrAddr){
   TLIINT      fd;
   SPX_OPTS    spx_options;
	IPX_ADDR    spx_addr;
   struct t_call tcall;

   UPGCMD      cmd;
   LPBYTE      buf= (LPBYTE)&cmd;

   int         ccode,i;

   printf("Finding %s ...", svrName);

   if( FindServer( svrName, svrType, (LPADDR)&spx_addr ) ){

      printf(" found.");
   
	   if (( fd = t_open( NET_TRANSPORT, O_RDWR, NULL) ) == -1 ){
		   t_error( "t_open" );
		   return -2;
	   }

		/* No need to bind to a specific socket */

	   if ( t_bind( fd, NULL, NULL )== -1 ){
		   t_error( "bind failed" );
         t_close(fd);
		   return -2;
	   }


	   /* Step 3 */

	   tcall.addr.buf = (LPBYTE)&spx_addr;
	   tcall.addr.maxlen = tcall.addr.len = sizeof( spx_addr );

	   spx_options.spx_connectionID[ 0 ] = 0;
	   spx_options.spx_connectionID[ 1 ] = 0;
	   spx_options.spx_allocationNumber[ 0 ] = 0;
	   spx_options.spx_allocationNumber[ 1 ] = 0;

	   tcall.opt.buf = (LPBYTE)&spx_options;
	   tcall.opt.maxlen = tcall.opt.len = sizeof( spx_options );
	   tcall.udata.buf = NULL;
	   tcall.udata.maxlen = tcall.udata.len = 0;

	   /* Step 4 */

      if( t_connect( fd, &tcall, NULL ) == -1) {
			printf("\n\nCouldn't connect to ");
			for(i=0; i<4; i++) printf("%02X", spx_addr.ipxa_net[i] );
			printf(":");
			for(i=0; i<6; i++) printf("%02X", spx_addr.ipxa_node[i] );
			printf(":%02X%02X\n\n", spx_addr.ipxa_socket[0], spx_addr.ipxa_socket[1] );

			t_unbind(fd);
			t_close(fd);
			return -2;
	   }


      printf("  Checking PSC Version ...");

      /*
         get server address w/ socket
      */
      if( !ReadData(buf, sizeof(UPGCMD), fd) ){
			t_unbind(fd);
			t_close(fd);
			return -2;
	   }
      memcpy( (LPBYTE)svrAddr, buf, sizeof(IPXAddress));

      cmd.cmd= cmd.len= 0;
      strcpy( cmd.buff, gl->mySignature );
      if( !SendData((LPBYTE)&cmd, sizeof(UPGCMD), fd) ){
			t_unbind(fd);
			t_close(fd);
			return -2;
	   }


      if( !ReadData((LPBYTE)&cmd, sizeof(UPGCMD), fd) ){
			t_unbind(fd);
			t_close(fd);
			return -2;
	   }

      if( cmd.cmd == UCMD_UPGRADE ){
         printf(" upgrading...");

         cmd.cmd= 0;
         cmd.len= (WORD)TRUE;
         if( !SendData((LPBYTE)&cmd, sizeof(UPGCMD), fd) ){
			   t_unbind(fd);
			   t_close(fd);
			   return -2;
	      }

         if( !doUpgrade(fd) ){
		      t_unbind(fd);
		      t_close(fd);
            return -2;
         }
   		t_unbind(fd);
	   	t_close(fd);
         return 1;
      }
      else if( cmd.cmd != UCMD_DISCONNECT ) printf(" wierd cmd=%i..",cmd.cmd);

		t_unbind(fd);
		t_close(fd);
      return 0;
   }
   else ccode= -1;

   return ccode;
}







/* eof, psctli.c */


