/*

Print Share Server

*/

#include "pss.h"







LPBUFF   buffGet(void);
void     buffRelease(LPBUFF p1);
void     buffSubmit(LPBUFF b1);


void     jobQueue(int port, LPBYTE fname, DWORD len, IPXAddress far *src);
BOOL     jobFetch( LPPDEF );


LPCDEF   clientGet(WORD);
void     clientRelease(LPCDEF c1);

void     ecbSubmitRx( LPECB   e1 );
void     ecbSubmitTx( LPECB   e1 );

void far _loadds ecbRx(void);
void far _loadds ecbTx(void);







GLOBALS     glob;
LPGLOBALS   gl;
LPBYTE      mySignature = PSS_INTERNAL_ID;
















BYTE  *Date(BYTE  *Buff){
   struct dosdate_t  Ddate;
   _dos_getdate(&Ddate);
   sprintf(Buff,"%02i/%02i/%04i",Ddate.month,Ddate.day,Ddate.year);
   return Buff;
}
   

BYTE  *Time(BYTE  *Buff){
   struct dostime_t  Ttime;
   _dos_gettime(&Ttime);
   sprintf(Buff,"%02i:%02i:%02i",Ttime.hour,Ttime.minute,Ttime.second);
   return Buff;
}




BYTE  *TimeStamp(BYTE   *Buff){
   Date(Buff);
   strcpy(Buff+strlen(Buff)," - ");
   Time(Buff+strlen(Buff));
   return Buff;
}



LPBYTE  ltransform(DWORD Val, LPBYTE Pic, LPBYTE Buff){
   BYTE   tbuff[100];
   LPBYTE s1,d1,p1;

   memset(Buff,32,strlen(Pic));
   Buff[strlen(Pic)]= 0;

   tbuff[0]= 0;
   sprintf(tbuff+1,"%li",Val);

   if( Val== 0 )
      strcpy(tbuff+1,"0");

   s1= (tbuff+1) + strlen(tbuff+1)-1;
   p1= Pic  + strlen(Pic)-1;
   d1= Buff + strlen(Buff)-1;

   while( *s1 && d1 >= Buff ){
      if( *p1 == '#' && isdigit( *s1) ){
         *d1= *s1;
         s1--;
      }
      else if( *p1 == ','){
         if( *s1  ) *d1= ',';
      }
      else{
         *d1= *p1;
         s1--;
      }

      d1--;
      p1--;
   }

   return Buff;
}




void gotorc(int r,int c){
   unsigned rc;

   rc = (r<<8)+c;

   _asm{
      pushf
      push  bp
      push  ds
      push  es
      push  di
      push  si
      push  dx
      push  cx
      push  bx
      push  ax

      mov   ah,06h
      mov   al,0

      mov   ah,0fh
      int   010h             /* gets display page into bh */

      mov   ah,02h
      mov   dx,word ptr rc
      int   010h             /* move cursor */

      pop   ax
      pop   bx
      pop   cx
      pop   dx
      pop   si
      pop   di
      pop   es
      pop   ds
      pop   bp
      popf
   }
   return;
}



void clrscr(void){
   _asm{
      pushf
      push  bp
      push  ds
      push  es
      push  di
      push  si
      push  dx
      push  cx
      push  bx
      push  ax

      mov   ah,06h
      mov   al,0

      mov   bh, 0x07 
      mov   cx,0
      mov   dh,24
      mov   dl,79
      int   010h             /* scroll everything off screen */

      pop   ax
      pop   bx
      pop   cx
      pop   dx
      pop   si
      pop   di
      pop   es
      pop   ds
      pop   bp
      popf
   }
   gotorc(0,0);
   return;
}





void clr( WORD r ){
   _asm{
      pushf
      push  bp
      push  ds
      push  es
      push  di
      push  si
      push  dx
      push  cx
      push  bx
      push  ax

      mov   ah,06h
      mov   al,0

      mov   bh, 0x07 
      mov   cx, word ptr r
      mov   ch,cl
      mov   cl,0
      mov   dh,24
      mov   dl,79
      int   010h             /* scroll rows off screen */

      pop   ax
      pop   bx
      pop   cx
      pop   dx
      pop   si
      pop   di
      pop   es
      pop   ds
      pop   bp
      popf
   }
   gotorc(0,0);
   return;
}



#define  CURSOROFF      0x2000
#define  CURSORNORMAL   0x0607
#define  CURSORINSERT   0x0107


WORD SetCursor(WORD Setting) {
   WORD  CurrentSetting;

   _asm {
       mov ah,03h
       int 10h
       mov CurrentSetting,cx
       mov ah,01h
       mov cx,Setting
       int 10h
   }

   return (CurrentSetting);
}











void far _loadds esrTimer(void){
   LPCDEF   c1;

   if( gl->timeDisp ) --gl->timeDisp;
   ++gl->timeBase;

   c1  = gl->cqTop;
   while( c1 ){
      if( c1->lTimeout == gl->timeBase && !c1->jobDead && c1->isQueueing ) c1->jobDead = TRUE;
      c1= c1->nxt;
   }


   IPXScheduleIPXEvent( 18/ TIMER_TPS, &gl->ecbTimer );
   return;
}







void  ecbInit(void){
   int      i;

   gl->ecbFree = NULL;


   for(i=0; i<NUM_RX_ECBS; i++){
      gl->ecbRx[i].ESRAddress    = NULL;
      gl->ecbRx[i].inUseFlag     = 0;
      gl->ecbRx[i].socketNumber  = *((LPWORD)gl->addrMe.socket);
      gl->ecbRx[i].fragmentCount = 2;
      gl->ecbRx[i].fragmentDescriptor[0].address = (void far *)&gl->hdrRx[i];
      gl->ecbRx[i].fragmentDescriptor[0].size    = sizeof(IPXHeader);
      gl->ecbRx[i].fragmentDescriptor[1].address = (void far *)&gl->dataRx[i];
      gl->ecbRx[i].fragmentDescriptor[1].size    = NBLEN_CMD;

      gl->hdrRx[i].checkSum   = 0;
      gl->hdrRx[i].length     = NWWordSwap( sizeof(IPXHeader)+NBLEN_CMD );
      gl->hdrRx[i].packetType = 4;
      memcpy( (LPBYTE)&gl->hdrRx[i].destination,  (LPBYTE)&gl->addrMe,  sizeof(IPXAddress));
      memset( (LPBYTE)&gl->hdrRx[i].source,       0,                    sizeof(IPXAddress));
   }

   for(i=0; i<NUM_TX_ECBS; i++){
      gl->ecbTx[i].ESRAddress    = NULL;
      gl->ecbTx[i].inUseFlag     = 0;
      gl->ecbTx[i].socketNumber  = *((LPWORD)gl->addrMe.socket);
      gl->ecbTx[i].fragmentCount = 2;
      gl->ecbTx[i].fragmentDescriptor[0].address = (void far *)&gl->hdrTx[i];
      gl->ecbTx[i].fragmentDescriptor[0].size    = sizeof(IPXHeader);
      gl->ecbTx[i].fragmentDescriptor[1].address = (void far *)&gl->dataTx[i];
      gl->ecbTx[i].fragmentDescriptor[1].size    = NBLEN_ACK;

      gl->hdrTx[i].checkSum   = 0;
      gl->hdrTx[i].length     = NWWordSwap( sizeof(IPXHeader)+NBLEN_ACK );
      gl->hdrTx[i].packetType = 4;
      memcpy( (LPBYTE)&gl->hdrTx[i].destination,  (LPBYTE)&gl->addrMe,  sizeof(IPXAddress));
      memset( (LPBYTE)&gl->hdrTx[i].source,       0,                    sizeof(IPXAddress));

      gl->ecbTx[i].linkAddress = (void far *)gl->ecbFree;
      gl->ecbFree = &gl->ecbTx[i];
   }

   gl->ecbTimer.ESRAddress    = (void (far *)())esrTimer;
   gl->ecbTimer.inUseFlag     = 0;
   gl->ecbTimer.socketNumber  = *((LPWORD)gl->addrMe.socket);
   gl->timeBase = 0;

   esrTimer();
   return;
}





void  ecbCancel(void){
   int      i;

   gl->ecbFree = NULL;
   for(i=0; i< NUM_TX_ECBS; i++){
      if( gl->ecbTx[i].inUseFlag ) IPXCancelEvent( &gl->ecbTx[i] );

      gl->ecbTx[i].linkAddress = (void far *)gl->ecbFree;
      gl->ecbFree = &gl->ecbTx[i];
   }

   for(i=0; i< NUM_RX_ECBS; i++){
      if( gl->ecbRx[i].inUseFlag ) IPXCancelEvent( &gl->ecbRx[i] );
   }

   if( gl->ecbTimer.inUseFlag )  IPXCancelEvent( &gl->ecbTimer );

   return;
}











LPECB    ecbGetTx(void){
   LPECB e1;

   e1= gl->ecbFree;
   if( e1 ){
      gl->ecbFree = (LPECB)e1->linkAddress;
      e1->linkAddress = NULL;
   }
   return e1;
}



void  ecbReleaseTx(LPECB e1){
   e1->linkAddress = (void far *)gl->ecbFree;
   gl->ecbFree = e1;
   return;
}






void far _loadds ecbTx(void){
	LPECB    e1;
	_asm{
		mov	[word ptr e1], si
		mov	[word ptr e1+2], es
	}
   ecbReleaseTx(e1);
   return;
}









LPECB    getResponder(LPECB e1){
   LPECB    e2;
   LPHDR    h1,h2;
   LPCMD    cmd2;

   e2 = ecbGetTx();

   h1 = (LPHDR)e1->fragmentDescriptor[0].address;
   h2 = (LPHDR)e2->fragmentDescriptor[0].address;

   memcpy( (LPBYTE)&h2->source,      (LPBYTE)&gl->addrMe, sizeof(IPXAddress));
   memcpy( (LPBYTE)&h2->destination, (LPBYTE)&h1->source, sizeof(IPXAddress));

   memcpy( (LPBYTE)e2->immediateAddress, (LPBYTE)e1->immediateAddress, 6);

   cmd2= (LPCMD)e2->fragmentDescriptor[1].address;
   cmd2->cmd= CMD_ACK;

   return e2;
}






void far _loadds ecbRx(void){
	LPECB    e1,e2;
   LPCMD    cmd1,cmd2;
   LPCDEF   c1;
   LPBUFF   b1;
   LPADDR   a1;
   BOOL     ackOK;

	_asm{
		mov	[word ptr e1], si
		mov	[word ptr e1+2], es
	}

   cmd1= (LPCMD)e1->fragmentDescriptor[1].address;

   switch( cmd1->cmd ){
      case CMD_PING:
         e2= getResponder(e1);
         cmd2= (LPCMD)e2->fragmentDescriptor[1].address;
         cmd2->serialNum   = cmd1->serialNum;
         ecbSubmitTx(e2);
         break;


      case CMD_OPEN:
         e2= getResponder(e1);

         a1 = (LPADDR)&((LPHDR)&e1->fragmentDescriptor[0].address)->source;
         
         c1 = gl->cqTop;
         while( c1 ){
            if( memcmp((LPBYTE)a1,(LPBYTE)&c1->src,sizeof(IPXAddress)) == 0)
               if( cmd1->remotePort == c1->port )
                  if( cmd1->serialNum == c1->lastSerial )
                     break;

            c1 = c1->nxt;
         }
         if( !c1 ){
            if( (c1= clientGet(cmd1->remotePort)) != NULL ){
               c1->nxt = gl->cqTop;
               gl->cqTop = c1;

               c1->isQueueing    = TRUE;
               c1->lTimeout = gl->timeBase + (TIMER_TPS*JOBKILL_TIMEOUT);

               c1->lastSerial = cmd1->serialNum;
               memcpy( (LPBYTE)&c1->src, (LPBYTE)a1, sizeof(IPXAddress));
            }
         }

         cmd2= (LPCMD)e2->fragmentDescriptor[1].address;
         cmd2->serialNum   = c1->lastSerial;
         cmd2->sessionCode = c1->sessionCode;
         cmd2->clientRec = (DWORD)c1;
         ecbSubmitTx( e2 );
         break;
         



      case CMD_DATA:
         c1= (LPCDEF)cmd1->clientRec;

         if( c1->sessionCode == cmd1->sessionCode ){
            c1->lTimeout = gl->timeBase + (TIMER_TPS*JOBKILL_TIMEOUT);
            ackOK = TRUE;
            if( cmd1->serialNum != c1->lastSerial ){
               if( (b1= buffGet()) != NULL ){
                  e2= getResponder(e1);

                  b1->client = c1;
                  memcpy( b1->data, ((LPBYTE)cmd1)+sizeof(CMD), (b1->len= cmd1->len));

                  buffSubmit(b1);

                  c1->lastSerial = cmd1->serialNum;
               }
               else ackOK = FALSE;
            }
            if( ackOK ){
               cmd2= (LPCMD)e2->fragmentDescriptor[1].address;
               cmd2->serialNum   = c1->lastSerial;
               ecbSubmitTx( e2 );
            }
         }
         break;




      case CMD_CLOSE:
         c1= (LPCDEF)cmd1->clientRec;
         if( c1->sessionCode == cmd1->sessionCode ){
            ackOK = TRUE;
            if( cmd1->serialNum != c1->lastSerial ){
               if( (b1= buffGet()) != NULL ){

                  e2= getResponder(e1);

                  b1->client  = c1;
                  b1->len     = 0;

                  buffSubmit(b1);

                  c1->isQueueing  = FALSE;
                  c1->lastSerial  = cmd1->serialNum;
               }
               else ackOK = FALSE;
            }
            if( ackOK ){
               cmd2= (LPCMD)e2->fragmentDescriptor[1].address;
               cmd2->serialNum   = c1->lastSerial;
               ecbSubmitTx( e2 );
            }
         }
         break;

   }
   ecbSubmitRx( e1 );
   return;
}






void  ecbSubmitRx( LPECB   e1 ){
   LPHDR h1;

   e1->ESRAddress = (void (far *)())ecbRx;
   e1->inUseFlag  = 0;
   e1->fragmentDescriptor[1].size    = NBLEN_CMD;

   h1= (LPHDR)e1->fragmentDescriptor[0].address;
   h1->length     = NWWordSwap( sizeof(IPXHeader)+NBLEN_CMD );

   IPXListenForPacket(e1);
   return;
}



void  ecbSubmitTx( LPECB   e1 ){
   LPHDR h1;

   e1->ESRAddress = (void (far *)())ecbTx;
   e1->inUseFlag  = 0;
   e1->fragmentDescriptor[1].size = NBLEN_ACK;

   h1= (LPHDR)e1->fragmentDescriptor[0].address;
   h1->length     = NWWordSwap( sizeof(IPXHeader)+NBLEN_ACK );

   IPXSendPacket(e1);
   return;
}















LPBUFF   buffGet(void){
   LPBUFF   b1;

   b1= gl->buffsFree;
   if( b1 ){
      gl->buffsFree = b1->nxt;
      b1->nxt = NULL;
      gl->usedBuffs++;
   }
   return b1;
}




void  buffRelease(LPBUFF b1){
   b1->nxt = gl->buffsFree;
   gl->buffsFree = b1;
   gl->usedBuffs--;
   return;
}



void  buffSubmit(LPBUFF b1){

   if( gl->bqBottom )
      (gl->bqBottom)->nxt = b1;
   else
      gl->bqTop = b1;

   gl->bqBottom = b1;

   b1->nxt = NULL;
   return;
}













void  jobQueue(int port, LPBYTE fname, DWORD len, IPXAddress far *src){
   LPJOB    j1;
   LPPDEF   p1;

   j1= gl->jobsFree;
   if( j1 ){
      gl->jobsFree = j1->nxt;
      j1->nxt = NULL;

      p1= &gl->ports[port];

      if( p1->jqBottom )
         (p1->jqBottom)->nxt = j1;
      else
         p1->jqTop = j1;

      p1->jqBottom = j1;

      j1->port = port;
      strcpy( j1->fname, fname);
      j1->len = len;
      memcpy( (LPBYTE)&j1->src, (LPBYTE)&src, sizeof(IPXAddress));

      p1->nJobsInQueue++;
      gl->usedJobs++;
   }
   return;
}





BOOL jobFetch( LPPDEF   p1 ){
   LPJOB    j1;
   BOOL     retVal = FALSE;

   if( p1->jqTop ){
      p1->nJobsInQueue--;

      j1 = p1->jqTop;
      p1->jqTop = j1->nxt;
      if( !p1->jqTop ) p1->jqBottom = NULL;


      j1->nxt = gl->jobsFree;
      gl->jobsFree = j1;
      gl->usedJobs--;

      memcpy( (LPBYTE)&p1->curJob, (LPBYTE)j1, sizeof(PJOB));
      p1->cBytes  = 0;
      p1->inf     = NULL;
      p1->portErr = FALSE;

      retVal = TRUE;
   }

   return retVal;
}












LPCDEF   clientGet( WORD port ){
   LPCDEF   c1;
   LPPDEF   p1;

   c1= gl->clientsFree;
   if( c1 ){
      gl->clientsFree = c1->nxt;
      c1->nxt = NULL;

      c1->jobDead       = FALSE;
      c1->sessionCode   = ++gl->sessionCode;
      c1->port          = port;
      c1->lastSerial    = 0;
      c1->fname[0]      = 0;
      c1->outf          = NULL;
      c1->len           = 0;

      p1= &gl->ports[ c1->port ];
      p1->nJobsLoading++;
      gl->usedClients++;

   }
   return c1;
}



void  clientRelease(LPCDEF c1){
   LPCDEF   ct,pc;
   LPPDEF   p1;

   if( c1->outf ) fclose(c1->outf);
   if( strlen(c1->fname) ) remove(c1->fname);
   c1->sessionCode--;

   pc = NULL;
   ct = gl->cqTop;
   while( ct ){
      if( ct == c1 ){
         if( pc ) pc->nxt = c1->nxt;
         if( c1 == gl->cqTop ) gl->cqTop = c1->nxt;
         break;
      }
      pc = ct;
      ct = ct->nxt;
   }

   c1->nxt = gl->clientsFree;
   gl->clientsFree = c1;

   p1= &gl->ports[ c1->port ];
   p1->nJobsLoading--;
   gl->usedClients--;

   return;
}












void  Scan(void);
void  Service(void);
void  Show(void);



void  Scan(void){
   LPBUFF   b1;
   LPCDEF   c1;
   WORD     cnt = 0;

   IPXRelinquishControl();

   for(;;){
      _disable();
      if( (b1 = gl->bqTop) == NULL ){ _enable(); break; }
      gl->bqTop = b1->nxt;
      if( !gl->bqTop ) gl->bqBottom = NULL;
      _enable();

      c1 = b1->client;

      if( b1->len ){
         if( !strlen(c1->fname) ){
            sprintf(c1->fname,"qfile.%03u",gl->qfNum++);
            if( gl->qfNum > 999 ) gl->qfNum = 0;

            c1->outf = fopen( c1->fname, "wb");
         }
         fwrite(b1->data, 1, b1->len, c1->outf);

         c1->len += b1->len;
         (&gl->ports[ c1->port ])->nBytesQueued += b1->len;

         _disable();
         buffRelease(b1);
         _enable();
      }
      else{
         if( strlen(c1->fname) ){
            fclose(c1->outf);
            jobQueue(c1->port,c1->fname,c1->len,&c1->src);
            c1->outf     = NULL;
            c1->fname[0] = 0;
         }
         _disable();
         buffRelease(b1);
         clientRelease(c1);
         _enable();
      }
      ++cnt;


      if( (cnt % 64)==0 ){
         if( cnt & 128 ){
            if( (gl->numBuffs - gl->usedBuffs) > 50 ) Service();
         }
         else Show();
      }
      
      IPXRelinquishControl();
   }
   return;
}










void  Service(void){
   LPPDEF   p1;
   int      i,j;
   WORD     chr,stat,busyCount;

   for(i=0; i<3; i++){
      IPXRelinquishControl();

      p1= &gl->ports[i];

      if( p1->inf ){
         if( p1->nBytes2Send == 0 ){
            if( !feof( p1->inf ) ){
               p1->nBytes2Send= fread(p1->readBuf,1,PJOB_SERVICE_LEN,p1->inf);
               p1->nBytesSent = 0;
            }
         }
         if( p1->nBytes2Send ){

            busyCount= 2;
            p1->portErr = FALSE;

            while( p1->nBytesSent != p1->nBytes2Send ){

               if( gl->useBIOS || !p1->pData ){
                  _asm{
                     push  cx
                     push  dx
                     push  ds
                     push  es
                     push  si
                     push  di
                     push  bp

                     mov   dx,[word ptr i]
                     mov   ax,0200h         /* get status */
                     int   17h

                     pop   bp
                     pop   di
                     pop   si
                     pop   es
                     pop   ds
                     pop   dx
                     pop   cx
                     mov   [word ptr stat],ax
                  }
                  stat >>= 8;
               }
               else stat= inp( p1->pData + 1 );


               if( (stat & P_PAPEROUT)
                     ||
                  !(stat & P_SELECT) ){ p1->portErr = TRUE;  break; }

               if( (stat & P_NOTBUSY) ){
                  busyCount= 5;

                  chr= (WORD)p1->readBuf[ p1->nBytesSent ];

                  if( gl->useBIOS || !p1->pData ){
                     _asm{
                        push  cx
                        push  dx
                        push  ds
                        push  es
                        push  si
                        push  di
                        push  bp

                        mov   dx,[word ptr i]
                        mov   ax,[word ptr chr]
                        mov   ah,0h         /* print char */
                        int   17h

                        pop   bp
                        pop   di
                        pop   si
                        pop   es
                        pop   ds
                        pop   dx
                        pop   cx
                     }
                  }
                  else{
                     j= inp( p1->pData+2 );
                     outp( p1->pData, chr );
                     outp( p1->pData+2, j | 1 );
                     while( inp(p1->pData+1) & P_ACK == 0 );
                     outp( p1->pData+2, j );
                  }

                  p1->cBytes++;
                  p1->nBytesQueued--;
                  p1->nBytesSent++;
               }
               else if( --busyCount==0 ) break;
            }
            if( p1->nBytesSent == p1->nBytes2Send ) p1->nBytes2Send = 0;

         }
         else{
            fclose(p1->inf);
            remove(p1->curJob.fname );

            p1->inf = NULL;

            ++p1->nJobsServiced;
            p1->tBytes += p1->cBytes;
         }
      }
      else if( jobFetch(p1) ){
         p1->nBytes2Send = 0;
         p1->inf  = fopen( p1->curJob.fname, "rb");
      }
   }


   return;
}











void  Show(void){
   LPPDEF   p1;
   BYTE     buff[80];
   int      i,ec;
   float    pct;
   DWORD    remain;

   if( !gl->timeDisp ){
      gotorc(5,0);
      pct = ((float)gl->usedClients / (float)gl->numClients)*100;
      printf("     Clients: %4i total  %4i used  (%6.2f%%)\n", gl->numClients, gl->usedClients, pct);
      pct = ((float)gl->usedJobs / (float)gl->numJobs)*100;
      printf("        Jobs: %4i total  %4i used  (%6.2f%%)\n", gl->numJobs, gl->usedJobs, pct);
      pct = ((float)gl->usedBuffs / (float)gl->numBuffs)*100;
      printf(" Rcv Buffers: %4i total  %4i used  (%6.2f%%)\n", gl->numBuffs, gl->usedBuffs, pct);

      gotorc(10,0);
      printf("System Date/Time: %s", TimeStamp(buff));

      gotorc(12,0);
      printf("                        In                 This Job       Bytes       Bytes\n");
      printf("             Serviced  Queue  Loading      %% Done     Remaining    In Queue\n");
      printf("===========================================================================\n");

      for(i=0; i<3; i++){
         IPXRelinquishControl();

         p1 = &gl->ports[i];

         if( p1->portErr ) ec = '*'; else ec= ' ';

         printf(" Port %s %c : ",p1->name,ec);
         printf("%5u  ", p1->nJobsServiced);
         printf("%5u    ",p1->nJobsInQueue);
         printf("%5u        ",p1->nJobsLoading);

         if( p1->inf ){
            pct      = ((float)p1->cBytes / (float)p1->curJob.len)*100;
            remain   = (p1->curJob.len - p1->cBytes);
         }
         else{
            pct    = 0;
            remain = 0;
         }
                    
         printf("%6.2f ",pct);
         printf("%s ", ltransform( remain,"###,###,###",buff ));
         printf("%s\n", ltransform( p1->nBytesQueued,"###,###,###",buff ));

      }
      gl->timeDisp = 3;
   }

   upgCheck();

   return;
}







void DeadJobs(void){
   LPCDEF   c1,lc1;
   LPPDEF   p1;

   if( gl->bqTop == NULL ){

      lc1 = NULL;
      c1  = gl->cqTop;

      _disable();

      while( c1 ){
         IPXRelinquishControl();

         if( c1->jobDead ){
            p1= &gl->ports[ c1->port ];
            (&gl->ports[ c1->port ])->nBytesQueued -= c1->len;
            clientRelease(c1);
            lc1 = NULL;
            c1  = gl->cqTop;
         }
         else{
            lc1 = c1;
            c1= c1->nxt;
         }
      }

      _enable();
   }

   return;
}




void  Process(void){

   gotorc(20,0);
   printf("Press Q to terminate.              ");

   gl->timeDisp = 0;

   for(;;){
      Scan();
      Service();
      Show();
      DeadJobs();
      if( kbhit() )if( (getch() | 32) == 'q' ) break;
   }

   return;
}


















BOOL  sysStartup(void){
   int   i;


   if( !upgSetup() ){
      IPXCloseSocket( *((LPWORD)gl->addrMe.socket) );
      return FALSE;
   }

   ecbInit();

   for(i=0; i<NUM_RX_ECBS; i++) ecbSubmitRx( &gl->ecbRx[i] );

   return TRUE;
}








void freeAllocs(void){
   int   i;

   if( gl->ports ){
      for(i=0; i<3; i++)
         if( gl->ports[i].readBuf ) free(gl->ports[i].readBuf);

      free(gl->ports);
   }

   if( gl->clients ) free(gl->clients);
   if( gl->jobs )    free(gl->jobs);
   if( gl->buffs )   free(gl->buffs);

   for(i=0; i< NUM_BUFF_PTRS; i++) if( gl->buffs[i] ) free(gl->buffs[i]);

   return;
}







void  sysShutdown(void){
   LPBUFF   b1;
   LPCDEF   c1;
   int      i;

   upgShutdown();

   ecbCancel();
   IPXCloseSocket( *((LPWORD)gl->addrMe.socket) );


   for(i=0; i<3; i++){
      if( gl->ports[i].inf ) fclose( gl->ports[i].inf );
      do{
         if( strlen(gl->ports[i].curJob.fname))
            remove(gl->ports[i].curJob.fname);
      }
      while( jobFetch( &gl->ports[i] ) );
   }

   while( (b1= gl->bqTop) != NULL ) gl->bqTop = gl->bqTop->nxt, buffRelease(b1);
   gl->bqTop = gl->bqBottom = NULL;

   while( (c1= gl->cqTop) != NULL ) gl->cqTop = gl->cqTop->nxt, clientRelease(c1);
   gl->cqTop = NULL;

   freeAllocs();
   return;
}










BOOL  InitConfigs(void){
   BOOL     retVal = TRUE;
   WORD     ptr,i,j,num2Alloc,allocNum,maxBuffs;
   int      rcode;
   LPWORD   wptr;
   LPPDEF   p1;
   LPCDEF   c1;
   LPJOB    j1;
   LPBUFF   b1;
   WORD     nBuffCnt[ NUM_BUFF_PTRS ];

   for(i=0; i< NUM_BUFF_PTRS; i++){
      gl->buffs[i]= NULL;
      nBuffCnt[i]= 0;
   }



   gl->numClients = MAX_CONCURRENT_USERS;
   gl->numJobs    = MAX_CONCURRENT_JOBS;


   if( (gl->ports   = (LPPDEF) malloc( 3 * sizeof(PDEF))) != NULL ){
      for(i=0; i<3; i++) gl->ports[i].readBuf= NULL;
   }

   gl->clients = (LPCDEF) malloc( gl->numClients * sizeof(CDEF));
   gl->jobs    = (LPJOB)  malloc( gl->numJobs    * sizeof(PJOB));


   maxBuffs= 1000;
   ptr= 0;
   allocNum= 0;
   while( ptr < NUM_BUFF_PTRS && maxBuffs>0 ){
      num2Alloc = min( (WORD)60000 / sizeof(BUFF), maxBuffs);
      if( ( gl->buffs[ptr] = (LPBUFF)malloc( num2Alloc  * sizeof(BUFF))) == NULL) break;
      nBuffCnt[ptr++]= num2Alloc;
      allocNum += num2Alloc;
      maxBuffs -= num2Alloc;
   }
   gl->numBuffs = allocNum;


   if( !gl->ports  || !gl->clients || !gl->jobs || !gl->numBuffs ){
      freeAllocs();
      printf("\nCouldn't allocate workspaces!\n\n");
      return FALSE;
   }

   for(i=0; i<3; i++){
      p1 = &gl->ports[i];

      sprintf(p1->name,"LPT%c",i+'1');
      p1->cBytes = p1->tBytes = 0;
      p1->nBytesQueued = 0;

      p1->jqTop = p1->jqBottom = NULL;
      p1->nJobsServiced = 0;
      p1->nJobsInQueue = 0;
      p1->nJobsLoading = 0;

      p1->portErr = FALSE;

      p1->nBytes2Send = p1->nBytesSent = 0;
      p1->inf = NULL;

      if( (p1->readBuf= (LPBYTE)malloc( PJOB_SERVICE_LEN )) == NULL ) break;

      j= 8+(i*2);
      _asm{
         push  ax
         mov   ax,j
         mov   [word ptr wptr],ax
         mov   [word ptr wptr+2],0x0040
         pop   ax
      }

      p1->pData = *wptr;
   }

   if( i != 3 ){
      freeAllocs();
      printf("\nCouldn't allocate print buffers!\n\n");
      return FALSE;
   }




   gl->sessionCode = gl->qfNum = 0;


   IPXGetInternetworkAddress( (LPBYTE)&gl->addrMe );

   *((LPWORD)gl->addrMe.socket) = NWWordSwap( PSS_IPX_SOCKET );

   if( (rcode=IPXOpenSocket( (LPBYTE)gl->addrMe.socket ,SHORT_LIVED)) != SUCCESSFUL ){
      printf("\nCouldn't open server socket!\n\n");
      return FALSE;
   }

   printf(" Server Node ");
   for(i=0; i<4; i++) printf( "%02X", gl->addrMe.network[i] );
   printf(":");
   for(i=0; i<6; i++) printf( "%02X", gl->addrMe.node[i] );
   printf( ":");
   for(i=0; i<2; i++) printf( "%02X", gl->addrMe.socket[i] );

   printf("  Name %s\n\n", gl->upgServerName );




   gl->cqTop = gl->clientsFree = NULL;
   for(i=0; i< gl->numClients; i++){
      c1 = &gl->clients[i];
      c1->nxt = gl->clientsFree;
      gl->clientsFree = c1;
   }
   gl->usedClients = 0;


   gl->jobsFree = NULL;
   for(i=0; i< gl->numJobs; i++){
      j1 = &gl->jobs[i];
      j1->nxt = gl->jobsFree;
      gl->jobsFree = j1;
   }
   gl->usedJobs = 0;



   gl->bqTop = gl->bqBottom = gl->buffsFree = NULL;
   
   j= gl->numBuffs;
   i= 0;
   ptr= 0;
   while(j && gl->buffs[ptr] ){
      b1 = (gl->buffs[ptr])+i++;
      b1->nxt = gl->buffsFree;
      gl->buffsFree = b1;
      j--;

      if( i == nBuffCnt[ptr] ) i=0, ptr++;
   }
   gl->usedBuffs = 0;


   return TRUE;
}









void main(int argc,LPBYTE *argv){
   BYTE     byteJunk;
   WORD     maxConnects,availConnects;
   int      retVal;

   gl = &glob;

   if( argc < 2 || argc > 3 ){
      printf("\nCommand Line:\n");
      printf(" PSS serverName [/B] \n\n");
      printf("   where serverName is the name of this server, length <= 47.\n");
      printf("         /B forces BIOS output instead of port I/O.\n\n");
      exit(2);
   }

   clrscr();
   printf("\nPrinter Share Server [%s]     5/96, Gregm.\n\n", mySignature );

   if( strlen(argv[1])>47 || argv[1][0]=='/' ){
      printf("Server name invalid or length exceeded 47 chars!\n\n");
      exit(2);
   }
   else{
      strcpy(gl->upgServerName, argv[1] );
      strupr(gl->upgServerName);
   }

   gl->useBIOS= FALSE;

   if( argc == 3 ){
      if( stricmp(argv[2],"/B")==0 ) gl->useBIOS= TRUE;
   }



   gl->upgServerType= SERVER_TYPE;





   NWCallsInit(NULL,NULL);

   if( IPXInitialize() != SUCCESSFUL ) printf("Couldn't find IPX.\n\n"), exit(2);

   if( SPXInitialize(&byteJunk, &byteJunk, &maxConnects, &availConnects) != SPX_IS_INSTALLED ){
      printf("Couldn't initialize SPX.\n");
      exit(2);
   }
   if( availConnects < NUM_UPGCONNECTS ){
      printf("Insufficient SPX connects available.\n");
      exit(2);
   }


   if( !InitConfigs() ) exit(2);

   if( sysStartup() ){
      SetCursor(CURSOROFF);
      Process();
      SetCursor(CURSORNORMAL);
      sysShutdown();
      gotorc(20,0);
      printf("Server Shutdown.                    \n\n");
      retVal = 0;
   }
   else{
      printf("%s Not Running.\n\n",mySignature);
      retVal= 2;
   }

   exit(retVal);
}






/* eof, pss.c */

