
/*

Print Share Client TSR, resident code

*/

#include "common.h"
#include "psc.h"



extern  (far IPXEntry)(void);
extern  (far CallOld17)(void);








WORD  GetPtrSeg(void far *p1){
   WORD  i;

   _asm{
      mov   ax, word ptr p1+2;
      mov   word ptr i,ax;
   }
   return i;
}




WORD  GetPtrOff(void far *p1){
   WORD  i;

   _asm{
      mov   ax, word ptr p1;
      mov   word ptr i,ax;
   }
   return i;
}











void  myScheduleIPXEvent( WORD ticks, LPECB p1 ){
   _asm{
      push  cx
      push  dx
      push  es
      push  bp
      mov   bx,5
      mov   ax,[word ptr ticks]
      mov   si,[word ptr p1]
      mov   es,[word ptr p1+2]
      call  IPXEntry
      pop   bp
      pop   es
      pop   dx
      pop   cx
   }
   return;
}


void myRelinquish(void){
   _asm{
      push  cx
      push  dx
      push  es
      push  bp
      mov   bx,10
      call  IPXEntry
      pop   bp
      pop   es
      pop   dx
      pop   cx
   }
   return;
}



void  mySendPacket( LPECB p1 ){
   _asm{
      push  cx
      push  dx
      push  es
      push  bp
      mov   bx,3
      mov   si,[word ptr p1]
      mov   es,[word ptr p1+2]
      call  IPXEntry
      pop   bp
      pop   es
      pop   dx
      pop   cx
   }
   return;
}


void  myListenForPacket( LPECB p1 ){
   _asm{
      push  cx
      push  dx
      push  es
      push  bp
      mov   bx,4
      mov   si,[word ptr p1]
      mov   es,[word ptr p1+2]
      call  IPXEntry
      pop   bp
      pop   es
      pop   dx
      pop   cx
   }
   return;
}


void  myCancelEvent( LPECB p1 ){
   _asm{
      push  cx
      push  dx
      push  es
      push  bp
      mov   bx,6
      mov   si,[word ptr p1]
      mov   es,[word ptr p1+2]
      call  IPXEntry
      pop   bp
      pop   es
      pop   dx
      pop   cx
   }
   return;
}






void far esrTimer(void){
   LPGLOBALS   gl = &glob;
   int   i;

   if( gl->timerOn ){
      ++gl->timeBase;

      for(i=0; i<3; i++){

         if( gl->ports[i].isInUse ){

            if( gl->ports[i].capTimer == gl->timeBase ){

               gl->ports[i].isInUse = FALSE;

               if( !gl->ports[i].isRedirected ){
                  if( gl->ports[i].isConnected )  svrDisconnect(i);
               }
            }
         }
      }

      myScheduleIPXEvent( 18/TIMER_TPS, &gl->ecbTimer );
   }
   return;
}













BOOL  svrTransact(WORD lport, WORD retry){
   LPGLOBALS gl = &glob;
   LPCMD    cmd;
   BOOL     retVal = FALSE;
   WORD     lTime,lSerial;

   lSerial = ++gl->txSerial;

   cmd = (LPCMD)gl->ports[lport].dataTx;

   cmd->serialNum    = lSerial;

   if( gl->ports[lport].isConnected ){
      cmd->clientRec   = gl->ports[lport].clientRec;
      cmd->sessionCode = gl->ports[lport].sessionCode;
   }
   else{
      cmd->clientRec   = 0;
      cmd->sessionCode = 0;
   }

   gl->ports[lport].hdrRx.length = gl->pktRxSize;
   myListenForPacket( &gl->ports[lport].ecbRx );

   do{
      gl->ports[lport].hdrTx.length     = gl->pktTxSize;
      mySendPacket( &gl->ports[lport].ecbTx );

      while( gl->ports[lport].ecbRx.inUseFlag
               &&
             gl->ports[lport].ecbTx.inUseFlag ) myRelinquish();

      if( !gl->ports[lport].ecbRx.inUseFlag ){ retry=-1; break; }


      lTime = gl->timeBase+ (TIMER_TPS*2);
      while( gl->ports[lport].ecbRx.inUseFlag
               &&
             gl->timeBase!=lTime ) myRelinquish();

      if( !gl->ports[lport].ecbRx.inUseFlag ){ retry=-1; break; }
      if( retry ) retry--;
   }
   while( retry );

   if( gl->ports[lport].ecbRx.inUseFlag ) myCancelEvent( &gl->ports[lport].ecbRx );

   if( retry==-1 ){
      cmd = (LPCMD)gl->ports[lport].dataRx;
      if( cmd->serialNum == lSerial && cmd->cmd == CMD_ACK )
         retVal = TRUE;
   }

   return retVal;
}






BOOL  svrConnect(WORD lport,WORD rport){
   LPGLOBALS gl = &glob;
   LPCMD    cmd;
   BOOL     retVal = FALSE;

   if( !gl->ports[lport].isConnected ){
      gl->ports[lport].txLen = 0;
      
      cmd = (LPCMD)&gl->ports[lport].dataTx;
      cmd->cmd        = CMD_OPEN;
      cmd->remotePort = rport;

      retVal = svrTransact(lport,5);

      if( retVal ){
         gl->ports[lport].isConnected = TRUE;
         gl->ports[lport].clientRec   = ((LPCMD)&gl->ports[lport].dataRx)->clientRec;
         gl->ports[lport].sessionCode = ((LPCMD)&gl->ports[lport].dataRx)->sessionCode;

         gl->ports[lport].capTimer = gl->timeBase + (TIMER_TPS* JOBDONE_TIMEOUT);
      }
   }
   return retVal;
}




void  svrDisconnect(WORD lport){
   LPGLOBALS gl = &glob;
   LPCMD    cmd;

   if( gl->ports[lport].isConnected ){

      cmd = (LPCMD)&gl->ports[lport].dataTx;

      if( gl->ports[lport].txLen ){
         cmd->cmd = CMD_DATA;
         cmd->len = gl->ports[lport].txLen;
         svrTransact(lport,10);
         gl->ports[lport].txLen = 0;
      }

      cmd->cmd = CMD_CLOSE;
      svrTransact(lport,5);
      gl->ports[lport].isConnected = FALSE;
   }
   return;
}












WORD  MyINT17( WORD di, WORD si, WORD bp, WORD es, WORD ds,
               WORD dx, WORD cx, WORD bx, WORD ax, WORD flags ) {

   LPGLOBALS gl = &glob;
   LPCMD    cmd;
   LPBYTE   p1;
   int      lport;
   WORD     stat;

   lport = (dx & 0x3);

   switch (ax>>8){
      case 0:
         if( gl->ports[lport].remotePort != 0xffff ){


            if( !gl->ports[lport].isInUse ){
               _asm{
                  mov   dx,word ptr lport
                  mov   ax,0200h          ; get status
                  call  CallOld17
                  mov   word ptr stat,ax
               }
               stat >>= 8;

               if( (stat & P_SELECT) )
                  gl->ports[lport].isRedirected= TRUE;
               else
                  gl->ports[lport].isRedirected= FALSE;

               gl->ports[lport].isInUse= TRUE;
            }


            if( !gl->ports[lport].isRedirected ){

               if( !gl->ports[lport].isConnected ){
                  if( !svrConnect(lport, gl->ports[lport].remotePort ) ){
                     gl->ports[lport].isInUse = FALSE;
                     ax= (P_IOERR | P_SELECT)<<8;
                     return 1;
                  }
               }

               if( gl->ports[lport].isConnected ){
                  cmd = (LPCMD)gl->ports[lport].dataTx;

                  p1 = ((LPBYTE)cmd)+sizeof(CMD) + gl->ports[lport].txLen;

                  *p1 = (BYTE)ax;

                  gl->ports[lport].capTimer = gl->timeBase + (TIMER_TPS* JOBDONE_TIMEOUT);
      
                  if( ++gl->ports[lport].txLen == (NBLEN_CMD-sizeof(CMD)) ){
                     cmd->cmd = CMD_DATA;
                     cmd->len = gl->ports[lport].txLen;
                     gl->ports[lport].isConnected = svrTransact(lport,10);
                     gl->ports[lport].txLen = 0;
                  }

                  ax= (P_NOTBUSY | P_ACK | P_SELECT)<<8;
                  return 1;
               }
            }
            else gl->ports[lport].capTimer = gl->timeBase + (TIMER_TPS* JOBDONE_TIMEOUT);
         }
         break;



      case 1:
      case 2:
         if( gl->ports[lport].remotePort != 0xffff ){
            if( !gl->ports[lport].isRedirected ){
               ax= (P_NOTBUSY | P_ACK | P_SELECT)<<8;
               return 1;
            }
         }
         break;

   }

   return 0;
}

















WORD  MyINT2F( WORD di, WORD si, WORD bp, WORD es, WORD ds,
               WORD dx, WORD cx, WORD bx, WORD ax, WORD flags ) {

   LPGLOBALS gl = &glob;
   int   i;

   if( ax == gl->systemID ){
      if( bx == SYS_GETSIGNATURE ){
         cx= GetPtrSeg( gl->mySignature );
         dx= GetPtrOff( gl->mySignature );
      }

      else if( bx == SYS_GETINFO ){
         bx= gl->MyPSP;
         cx= GetPtrSeg( &glob );
         dx= GetPtrOff( &glob );
      }

      else if( bx == SYS_STOPNET ){
         for(i=0; i<3; i++){
            if( gl->ports[i].isConnected ) svrDisconnect(i);
            gl->ports[i].remotePort = 0xffff;
         }
      }

      else bx= 0xFFFF;

      ax= (gl->systemID ^ 0xFFFF);
      return 1;
   }
   return 0;
}












WORD  MyINT21( WORD di, WORD si, WORD bp, WORD es, WORD ds,
               WORD dx, WORD cx, WORD bx, WORD ax, WORD flags ) {

   LPGLOBALS   gl = &glob;

   if( ax == 0xB805 ){
      gl->defaultPort = (dx>>8) & 0x03;
   }


/*
   else{
      if( (ax>>8)==0xDF ){
         switch ((dx & 0xff)){
            case 0x01:
            case 0x02:
            case 0x03:
               i= gl->defaultPort;
               if( gl->ports[i].isConnected )  svrDisconnect(i);
               break;

            case 0x05:
            case 0x06:
            case 0x07:
               i= (dx>>8) & 0x03;
               if( gl->ports[i].isConnected )  svrDisconnect(i);
               break;
         }
      }
   }
*/


   return 0;
}








/* eof, res.c */

