/*
 * MultiMail offline mail reader
 * address book

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"

extern mmail		mm;
extern LetterWindow	letterwindow;
extern Welcome		welcome;
extern HelpWindow	helpwindow;
extern letter_list	*letterList;
extern Interface	*interface;

Person::Person()
{
	next = NULL;
	netmail_addr.point = 0;
}

AddressBook::AddressBook()
{
	NumOfPersons = 0;
}

void AddressBook::MakeActive(int NOENTER)
{
	int c;

	people = NULL;

	list_max_y = LINES - 12;
	list_max_x = COLS - 6;

	list = new InfoWin(LINES - 5, COLS - 4, 2, 2,
		C_ADDR1 | A_BOLD, (interface->active() != letter), 7);

	mvwaddch(list->win, 0, 2, ACS_RTEE);
	mvwaddch(list->win, 0, 14, ACS_LTEE);
	mvwaddstr(list->win, list_max_y + 3, 2, "A, Q");

	int inletter = ((interface->active() == letter) ||
		(interface->active() == littlearealist)) &&
			!mm.areaList->isReplyArea();

	if (inletter)
		mvwaddch(list->win, list_max_y + 3, 30, 'L');

	wattrset(list->win, C_ADDR2 | A_BOLD);
	mvwaddstr(list->win, 0, 3, "Addressbook");
	mvwaddstr(list->win, 1, 2,
		"Name                            Netmail address");

	wmove(list->win, list_max_y + 2, 1);
	whline(list->win, ACS_HLINE, list_max_x);
	mvwaddstr(list->win, list_max_y + 3, 6, ": Leave Addressbook");
	if (inletter)
		mvwaddstr(list->win, list_max_y + 3, 31,
			  ": Pick sender name & NM address from letter");

	wattrset(list->info, C_ADDR3);

	ReadFile();

#ifdef SIGWINCH
	currAddr = this;
#endif
	// handle keyboard
	keyEnd = 0;
	while (!keyEnd) {
		do
			c = wgetch(list->info);
		while (c == ERR);
		switch (c) {
		case 'q':
		case 'Q':
		case 'a':
		case 'A':
		case '\033':
			keyEnd = 1;
			break;
		case '\r':
		case '\n':
			if (!NOENTER) {
				SetLetterThings();
				keyEnd = 1;
			}
			break;
		case '+':
		case KEY_DOWN:
		case KEY_RIGHT:
			Move(DOWN);
			break;
		case '-':
		case KEY_UP:
		case KEY_LEFT:
			Move(UP);
			break;
		case 'f':
		case 'F':
		case ' ':
		case KEY_NPAGE:
			Move(PGDN);
			break;
		case 'b':
		case 'B':
		case KEY_PPAGE:
			Move(PGUP);
			break;
		case KEY_HOME:
			Move(HOME);
			break;
		case KEY_END:
			Move(END);
			break;
		case 'l':
		case 'L':
			if (inletter)
				AddressFromLetter();
		}
		if (!keyEnd) {
			Draw();
			doupdate();
		}
	}

#ifdef SIGWINCH
	currAddr = NULL;
#endif
	DestroyChain();

	delete list;
	interface->screentouch();
	switch (interface->active()) {
	case packetlist:
		welcome.ReDraw();
	case arealist:
	case letterlist:
		interface->activeList()->ReDraw();
		helpwindow.redraw();
		break;
	case letter:
		letterwindow.ReDraw();
	default:;
	}
}

void AddressBook::SetLetterThings()
{
	if (highlighted)
		letterwindow.set_Letter_Params(&(highlighted->netmail_addr),
				       highlighted->name);
}

void AddressBook::AddressFromLetter()
{
	net_address Address;
	FILE *fd;

	Address = letterwindow.PickNetAddr();
	fd = fopen(mm.resourceObject->get(AddressFile), "at");
	fprintf(fd, "%s\n%s\n\n", letterList->getFrom(), Address.text());
	fclose(fd);
	ReadFile();
}

void AddressBook::oneLine(int i)
{
	int x, y, z;
	Person *curr;

	z = position + i;
	curr = (z < NumOfPersons) ? people[z] : (Person *) NULL;
	if (z == active) {
		wattron(list->info, A_REVERSE);
		highlighted = curr;
	}
	wmove(list->info, i, 0);
	if (curr) {
		wprintw(list->info, " %-31s %s", curr->name,
			curr->netmail_addr.text());
		getyx(list->info, y, x);
	} else
		x = 0;
	for (; x < list_max_x; x++)
		waddch(list->info, ' ');
	if (z == active)
		wattroff(list->info, A_REVERSE);
}

void AddressBook::ReDraw()
{
	wnoutrefresh(list->win);
	wnoutrefresh(list->info);
	doupdate();
}

int AddressBook::NumOfItems()
{
	return NumOfPersons;
}

void AddressBook::ReadFile()
{
	FILE *fd;
	Person head, *curr;
	char name[256], nmaddr[256], other[256];
	int end = 0;

	oldPos = oldActive = -100;
	DestroyChain();

	if ((fd = fopen(mm.resourceObject->get(AddressFile), "rt"))) {
		curr = &head;
		while (!end) {
			do
				if (!fgets(name, 255, fd))
					end = 1;
			while (name[0] == '\n' && !end);
			if (!fgets(nmaddr, 255, fd))
				end = 1;
			else {
				curr->next = new Person;
				curr = curr->next;
				name[strlen(name) - 1] = '\0';
				name[29] = '\0';
				strcpy(curr->name, name);
				curr->netmail_addr.init(nmaddr);
				NumOfPersons++;
			}
			do
				if (!fgets(other, 255, fd))
					end = 1;
			while (other[0] != '\n' && !end);
		}
		fclose(fd);
	}

	if (NumOfPersons) {
		people = new Person *[NumOfPersons];
		curr = head.next;
		int c = 0;
		while (curr) {
			people[c++] = curr;
			curr = curr->next;
		}
	}

	if (active > NumOfPersons)
		active = position = 0;
	Draw();
}

void AddressBook::DestroyChain()
{
	while (NumOfPersons)
		delete people[--NumOfPersons];
	delete people;
}

#ifdef SIGWINCH
void AddressBook::sigwinch()
{
	keyEnd = 1;
	interface->sigwinch();
}
#endif
