/*
 * MultiMail offline mail reader
 * area list

 Copyright (c) 1996 Kolossvary Tamas <thomas@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"
#include "isoconv.h"

extern mmail		mm;
extern file_list	*packetList;
extern letter_list	*letterList;
extern LetterWindow	letterwindow;
extern HelpWindow	helpwindow;

//**************        LittleAreaListWindow    *****************

LittleAreaListWindow::LittleAreaListWindow(char param_key)
{
	int dest;

	disp = 0;
	do
		mm.areaList->gotoArea(disp++);
	while (mm.areaList->isCollection());
	disp--;

	key = param_key;
	list_max_y = LINES - 10;
	list = new InfoWin(LINES - 6, 25, 2, 30, C_LALBTEXT, 0, 4, 3);
	dest = letterList->getAreaID() - disp;
	while (active != dest)
		Move(DOWN);
	mvwaddstr(list->win, 1, 2, "Reply goes to area:");
	Draw();
}

LittleAreaListWindow::~LittleAreaListWindow()
{
	mm.areaList->gotoArea(active + disp);
	letterwindow.set_Letter_Params(active + disp, key);
	delete list;
	letterwindow.ReDraw();
}

void LittleAreaListWindow::oneLine(int i)
{
	char buf[24];

	wattrset(list->info, C_LALLINES);
	mm.areaList->gotoArea(position + i + disp);
	if (position + i == active)
		wstandout(list->info);
	sprintf(buf, " %-21.21s ", mm.areaList->getDescription());
	charconv_in(buf);
	mvwaddstr(list->info, i, 0, buf);
}

int LittleAreaListWindow::NumOfItems()
{
	return mm.areaList->noOfAreas() - disp;
}

//*************         AreaListWindow          ******************

void AreaListWindow::ReDraw()
{
	list->touch();
	info->touch();
}

void AreaListWindow::FirstUnread()
{
	int i;

	oldPos = oldActive = -100;
	position = active = 0;
	list_max_y = LINES - 15;
	for (i = 0; i < NumOfItems(); i++) {
		mm.areaList->gotoActive(i);
		if (!mm.areaList->getNoOfUnread())
			Move(DOWN);
		else
			break;
	}
	Draw();
}

int AreaListWindow::NumOfItems()
{
	return mm.areaList->noOfActive();
}

void AreaListWindow::oneLine(int i)
{
	char *p = lineBuf;

	mm.areaList->gotoActive(position + i);
	wattrset(list->info, mm.areaList->isReplyArea() ?
		 C_ALREPLINE : C_ALPACKETLINE);
	if (mm.areaList->getNoOfUnread() > 0)
		wattron(list->info, A_BOLD);
	if (position + i == active) {
		wstandout(list->info);
		mvwprintw(info->win, 2, 8, "%-20.20s",
			mm.areaList->getAreaType());
		sprintf(lineBuf, format2, mm.areaList->getDescription());
		charconv_in(lineBuf);
		mvwaddstr(info->win, 3, 20, lineBuf);
		wnoutrefresh(info->win);
	}
	p += sprintf(p, format, mm.areaList->getShortName(),
		mm.areaList->getDescription());
	if (mm.areaList->getNoOfLetters())
		p += sprintf(p, "  %5d  ", mm.areaList->getNoOfLetters());
	else
		p += sprintf(p, "      .  ");
	if (mm.areaList->getNoOfUnread())
		p += sprintf(p, "  %5d   ", mm.areaList->getNoOfUnread());
	else
		p += sprintf(p, "      .   ");
	if (mode)
		if (mm.areaList->getNoOfPersonal())
			sprintf(p, "   %5d   ",
				mm.areaList->getNoOfPersonal());
		else
			sprintf(p, "       .   ");

	charconv_in(lineBuf);
	mvwaddstr(list->info, i, 0, lineBuf);
}

void AreaListWindow::Select()
{
	mm.areaList->gotoActive(active);
}

void AreaListWindow::ResetActive()
{
	active = mm.areaList->getActive();
}

void AreaListWindow::MakeActive()
{
	int padding;
	char tmp[21];

	oldPos = oldActive = -100;
	mode = mm.driverList->hasPersonal();

	list_max_y = LINES - 15;
	list = new InfoWin(LINES - 12, COLS - 4, 2, 2, C_ALBORDER, 1);
	mvwaddch(list->win, 0, 2, ACS_RTEE);
	wattrset(list->win, C_ALBTEXT);
	wprintw(list->win, "Message Areas (%d)", NumOfItems());
	wattrset(list->win, C_ALBORDER);
	waddch(list->win, ACS_LTEE);

	wattrset(list->win, C_ALHEADTEXT);
	mvwaddstr(list->win, 1, 3, "Area#  Description");
	int newloc = COLS - 21;
	if (mode)
		newloc -= 11;
	mvwaddstr(list->win, 1, newloc, "Total   Unread");
	if (mode)
		mvwaddstr(list->win, 1, COLS - 15, "Personal");
	info = new ShadowedWin(5, COLS - 4, LINES - 11, 2, C_ALBORDER, 1);
	wborder(info->win, 0, 0, 0, 0, ACS_LTEE, ACS_RTEE, 0, 0);
	wmove(info->win, 0, 2);
	waddch(info->win, ACS_RTEE);
	wattrset(info->win, C_ALBTEXT);
	waddstr(info->win, "Info On The Specified Area");
	wattrset(info->win, C_ALBORDER);
	waddch(info->win, ACS_LTEE);

	padding = COLS - 34;
	if (mode)
		padding -= 11;
	sprintf(format, " %%6s  %%-%d.%ds", padding, padding);

	wattrset(info->win, C_ALINFOTEXT);
	mvwaddstr(info->win, 1, 2, " BBS:                        Sysop: ");
	mvwaddstr(info->win, 2, 2, "Type:                       Packet: ");
	mvwaddstr(info->win, 3, 2, "Area description: ");
	wattrset(info->win, C_ALINFOTEXT2);
	sprintf(tmp, "%-20.20s", mm.resourceObject->get(BBSName));
	charconv_in(tmp);
	mvwaddstr(info->win, 1, 8, tmp);
	sprintf(tmp, "%-20.20s", mm.resourceObject->get(SysOpName));
	charconv_in(tmp);
	mvwaddstr(info->win, 1, 38, tmp);
	mvwaddstr(info->win, 2, 38, (char *) packetList->getName());
	padding = COLS - 26;
	sprintf(format2, "%%-%d.%ds", padding, padding);

	lineBuf = new char[COLS - 5];

	Draw();
	helpwindow.arealist();
	Select();
}

void AreaListWindow::Delete()
{
	delete lineBuf;
	delete info;
	delete list;
	helpwindow.Delete();
}
