/*
 * MultiMail offline mail reader
 * some routines common to both sides

 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "interfac.h"
#include "mysystem.h"

extern mmail mm;
extern void fatalError(const char *description);

int mysystem(const char *cmd)
{
#ifndef __PDCURSES__
	endwin();
#endif
	int result = system(cmd);
	keypad(stdscr, TRUE);
	return result;
}

void mytmpnam(char *name)
{
/* EMX doesn't return an absolute pathname from tmpnam(), so we create one
   ourselves. Otherwise, use the system's version, and make sure it hasn't
   run out of names. */
#ifdef __EMX__
	char *tmp;

	tmp = getenv("TEMP");
	if (!tmp) {
		tmp = getenv("TMP");
		if (!tmp)
			tmp = (char *) mm.resourceObject->get(mmHomeDir);
	}
	sprintf(name, "%s/%s", tmp, tmpnam(NULL));
#else
	if (!tmpnam(name))
		fatalError("Out of temporary filenames");
#endif
}

/* Convert pathnames to "canonical" form (change slashes to backslashes) */
/* Don't call this twice in a row without first copying the result! D'oh! */

#if defined (__MSDOS__) || defined (__EMX__)

char *canonize(const char *sinner)
{
	static char saint[256];
	int i;

	for (i = 0; sinner[i]; i++)
		saint[i] = (sinner[i] == '/') ? '\\' : sinner[i];
	saint[i] = '\0';
	return saint;
}

#endif
