PCElm 3.2 - Installation and User Manual


0) Files
1) About PCElm and where and how to get it
2) History and Version Numbers
3) Installation
    3.1 Configuration File
    3.2 Environment Variables
    3.3 Other Files
    3.4 Starting PCElm
4) Using PCElm
5) Troubleshooting
6) Notes for interfacing PCElm with UUCP programs
7) Notes for interfacing PCElm with WAFFLE
8) Notes for interfacing PCElm with UNIX-Servers
9) Notes on Multimedia Mail
10) Languages
11) Credits
12) The Future


0) Files
    This package contains the following files:

    Name            Description
    ----------------------------------------------------------------
    !README         A quick overview of what PCElm is all about
    ALIAS           Example alias file
    MAILCAP         An example mailcap file for MIME
    DEMOMMDF        An example mailbox file with MIME-mails (MMDF format)
    DEMO            An example mailbox file with MIME-mails (not MMDF format)
    MARVIN   SIG    Example signature file
    PCELM    RC     Example PCElm configuration file
    PCELM    DEU    PCElm message file, german language (Deutsch)
    PCELM    ENG    PCElm message file, english language
    PCELM    ESP    PCElm message file, spanish language (Espanol)
    PCELM    NED    PCElm message file, dutch language (Nederlands)
    PCELM    MAN    PCElm installation and user manual
    PCELM    EXE    PCElm executable
    SHOWPART BAT    A batch file to display multipart MIME mails


1) About PCElm and where and how to get it
    PCElm is a mail user agent (UA) with a user interface closely
    modeled after the USENET ELM. To avoid confusion, we would like to
    mention that PCElm and USENET ELM are *not* related.

    PCElm is intended to be used as a drop-in replacement for BM when
    using the KA9Q NOS package or as a replacement for mail.exe when
    using UUPC. It can also be used for other mailsystems, as all relevant
    things for compatibility with MTA's (Message Transfer Agents) are
    configurable.

    Hilights:
    PCElm has a nice user interface, with easy to learn and easy to use
    commands. UN*X users will already be familiar with the more important
    commands. It can be made to work with just about every mail system
    there is for PC's, as PCElm makes no assumptions at all about the
    underlying network software. Finally, PCElm is multilingual; you can
    make all messages appear in your favorite language. Message files
    for English, German, Spanish and Dutch currently exist.

    PCElm in hamradio mode creates text- and workfiles directly usable
    by NET or NOS for distribution with SMTP. In UUCP mode, PCElm
    execs a uucp mailer (usually rmail.exe) to feed mail to your
    uucp program. Since there are many uucp programs for PCs out there,
    it is up to you to find the right way to exec the mailer (See the
    discussion on the uucpcall parameter below). As our knowledge
    of UUPC, WAFFLE etc. is limited, we can't help there.

    PCElm is Copyright (C) 1988,89,90,91,92,93 by Wolfgang Siebeck and
    Martin Freiss.

    The executable pcelm.exe may be freely copied and distributed, provided
    that all files in this package are distributed with it and provided that
    the copyright notices are retained. No money may be charged for copying
    PCElm. A license is given to use PCElm for an unlimited time in
    non-commercial environments.

    No warranty, expressed or implied, is given that PCElm does what you
    think it does. The usual disclaimers apply: It works for us.

    Should you want or need support in setting up PCElm beyond the scope
    of this manual, want us to include special features in PCElm, want
    to include PCElm with your product or otherwise use PCElm in a
    commercial environment (i.e. make money out of people using PCElm),
    contact us.

    If you need support from us, we would request that you register PCElm
    with us for a fee of 10$ or the equivalent amount in your favorite
    currency (20 DM or 8 british pounds at current rates). No checks or MO's
    please; exchange fees for foreign currency checks are more than 10$
    over here. Cash in an airmail letter is preferred, though Wolfgang Siebeck
    can also process credit card orders (VISA). If you need more than
    one license, we offer bulk licenses at substantial discounts - contact
    us for details.

    A (rather nice) printed manual is available from Wolfgang Siebeck to
    registered users for an additional fee of $7. Note that this manual
    is for version 3.01 of PCElm, not for the current version (3.2). There
    was not much interest in the printed manual (only one person wanted it),
    so we won't offer a printed manual for future versions unless there
    is overwhelming demand.

    Registered users will get advance notice of bug fixes and new releases
    if we know their email address. We do supply bug fixes and support to
    registered users a _lot_ faster.

    If you don't need support, we wouldn't complain about a donation
    either :-)

    If you would like the source code (C, with Turbo C 2.0((C) Borland) or
    later versions, Borland C++ recommended), the fee is 50$.
      The rationale behind this is that support costs us both time and money
    (as you might know, Germany has about the highest postal and telephone
    charges in the world).


    We can be reached at

    Wolfgang Siebeck        -or-    Martin Freiss
    Postfach 1526                   Muehlenfloessstr. 60
    D-52016 Aachen                  D-33175 Bad Lippspringe
    Germany                         Germany

    Email:
    siebeck@infoac.rmi.de           marvin@infoac.rmi.de

    Email is preferred.
    (Note the change of e-mail address for Martin Freiss. The old address
    is still valid, operable, and may reach me faster, but for politic reasons
    mail about PCElm is preferred at the new address).

    Bug reports are welcome if they are complete, i.e. please specify
    all configuration parameters, your hardware, version of NOS or uucp
    software, and send an excerpt of the mailbox you are having trouble
    with if necessary. We can't fix bugs we can't reproduce.
    Suggestions for enhancements to PCElm are of course also welcome.

2) History and Version Numbers

    PCElm was originally based on BM, Bdales Mailer, by Barksdale Garbee II,
    N3EUA, version 3.0, reworked by Gerard van der Grinten, PA0GRI,
    Phil Karn, KA9Q, and Dave Trulli, NN2Z. BM at that time was a UNIX
    (UNIX is a trademark of USL laboratories) mail lookalike with a
    restricted set of commands.

    Someday in early 1988, Martin added a reply-include-old-message command
    to BM, and later that year, with the advent of Turbo C 1.5, Wolfgang
    Siebeck devised the user interface modeled after Dave Taylor's ELM.
    Creeping featurism then set in, and more and more capabilities were
    added, until all resemblances to BM ceased to exist. This mailer
    was then renamed to PCElm.

    The version number went to 1.9 in middle 1989 and stopped there.
    We had no real use for PCElm any more then, as we both had bigger
    computers than PCs to play around with at that time :-).
    PCElm at this time had never been officially distributed, we just gave
    some copies to friends in Germany and the Netherlands.

    Imagine our surprise, when, in 1990, mail began to trickle in from
    PCElm users in Britain and the US and it developed that there was a
    large user community.
    In late 1990 Kelvin Hill, G1EMM, took over development of PCElm, as
    we did not have time to develop PCElm further.

    Sadly, Kelvin dropped development in early 1991 due to work
    pressure. At that time, he had developed versions 2.0 to 2.2 and
    distributed them. Unluckily enough, we don't know what's in these
    versions. Rumour has it that Kelvin intended to incorporate a news
    reader for use with KA9Q NOS's NNTP capabilities, but to our
    knowledge this did not happen.

    PCElm 3.0 was then written in August 1991, again by Wolfgang Siebeck
    and Martin Freiss. PCElm 3.0 is the 'official' son of PCElm 1.9a.
    We hope that this will end the version number confusion regarding
    PCElm.

    PCElm 3.01 was a bugfix release that removed the bug which caused
    PCElm 3.0 to hang if started on an empty mailbox.

    PCElm 3.1 is the latest release at this time (June 1993). It
    includes many features that you, our users, requested, some bugfixes
    and rudimentary MIME support.

    PCElm 3.2 was released on 1.1.1994. This is mainly a maintenance
    release which corrects a memory leak that crept into the 3.1 version.

3) Installation

    First, set the environment variable PCELM to point to the directory
    where PCElm's configuration file and alias file reside.
    This environment variable is mandatory! PCElm will not start up
    without it (see also 3.2, environment variables).
    Example:
    set PCELM=d:\usr\marvin

    If you are upgrading from PCElm 3.0, 3.01 or earlier versions, you
    will already have a variable HOME defined. PCElm will take either
    PCELM or HOME environment variables for startup; PCELM, if present,
    takes precedence over HOME.

    'CD' to your home directory, if you are not already there.
    Then, select the language you want to use by copying or renaming the
    appropriate message file to 'pcelm.msg'. The message files 'pcelm.eng'
    (English), 'pcelm.deu' (German), 'pcelm.esp' (Spanish) and 'pcelm.ned'
    (Dutch) are included in this distribution.
    Example:
    cd \usr\marvin
    copy pcelm.eng pcelm.msg

    For this manual, we assume that you are using the English language.
    If you want to use another language, read chapter 7 first, which
    discusses setups for foreign languages in more detail.

    3.1 Configuration File
    ----------------------
    PCElm needs to know a lot of things about your MTA and your computer
    to function properly.

    You need to configure PCElm's configuration file, pcelm.rc, before
    starting PCElm for the first time. DO NOT USE THE EXAMPLE pcelm.rc
    DISTRIBUTED IN THIS PACKAGE AS-IS. Edit it first with an ASCII-Editor
    of your choice.

    pcelm.rc is a pure ASCII-file. Lines that start with a hash '#' or
    empty lines are regarded as comments.

    Other lines are of the form <keyword><blank><information>. The
    keywords that PCElm knows about are explained in detail below.
    Note that ASCII space is used as a delimiter; if you need to include
    a space in the information field, you can put double quotes '"'
    around it. If (for whatever reason) you need to insert control
    characters into a line, write them as escaped decimals (i.e.
    \001 would be Ctrl-A). Some more escapes PCElm knows about are
    \n, newline, \r, carriage return, \\ backslash, and \t, tab.
    Note that PCElm likes slashes in pathnames, not backslashes, i.e.
    you must write a path like "c:\spool\mail" as "c:/spool/mail".
    Example:
    SOH-UUCP "From "
    Keywords are case insensitive.
    Keyword is one of:

    HOST
    ----
    This is the hostname to be used for the hamradio mode. It usually
    is your callsign followed by .ampr.org, as in "dg5kx.ampr.org"
    Example:
    host dg5kx.ampr.org

    UUCPHOST
    --------
    This is the hostname to be used for uucp mode. Note: traditional
    uucp hostnames need to be unique, so know what you are doing here.
    This is usually either your hostname followed by .uucp as in
    "dg5kx.uucp" or a fully qualified domain name (FQDN) as in
    "dg5kx.rmi.de".
    Example:
    uucphost dg5kx.uucp

    USER
    ----
    This is the name of your mailbox. It usually is your username (login)
    at this system. (Note that this puts an 8 character length restriction
    on your username, as MessDOS can't handle more characters).
    If this entry is commented out, the value of the environment variable
    'mailbox' is used.
    Example:
    user marvin

    FULLNAME
    --------
    Your real life name belongs here. This is so that other people can see
    who you really are, even if your username is 'gandalf' or 'blackadder'.
    (No disrespect meant if you are really called Gandalf).
    If this entry is commented out, the value of the environment variable
    'name' is used.
    Example:
    fullname "Martin W Freiss"

    HAMREPLY
    --------
    Use this if you want replies to your messages to go to another machine
    or if you are on a network where headers are mangled so badly people
    can't reply to you otherwise. If you aren't sure, set it to your
    own email address. This is for hamradio mode only.
    Example:
    reply marvin@pc.dg5kx.ampr.org

    UUCPREPLY
    ---------
    Same as above, but for uucp mode. This makes it possible to use
    different reply addresses for hamradio and uucp.
    Example:
    reply freiss.pad@sni.de

    REPLY
    -----
    Same as HAMREPLY; for backwards compatability with PCElm 3.0.

    ZONE
    ----
    The timezone you are living in. Should be 3 characters, not more, not less.
    There is an ISO standard for time zone names if memory serves me correctly,
    but the ISO number escapes me.
    Some people prefer to set this to the deviation of their local time from
    Universal Time, e.g. -07:00. Anyway, more than 6 charachters are not
    accepted here.
    Example:
    zone MET

    MAXLET
    ------
    The maximum number of messages that may be in a mailbox at once.
    Decrease this number if you are short on memory. PCElm startup will slow
    down considerably if have a huge mailbox; on the other hand I doubt
    anybody can find his way around 300 messages in a single mailbox.
    Example:
    maxlet 300

    EDIT
    ----
    The filename of your favorite editor goes here, This should be a small
    editor capable of producing true ASCII files (if possible with no
    Control-Z at the end, though PCElm tries to zap Ctrl-Z's if it sees them).
    What I'm trying to convey here is that Word for Windows ((C) Microsoft)
    is not the sort of thing you want to put here.
    If this entry is commented out, the value of the environment variable
    'editor' is used.
    If you don't have an editor handy (edlin doesn't count :-)), try
    builtin+
    as editor. This is a small full screen editor that is hardcoded into
    PCElm. Nothing fancy, and it still has some raw edges, but it works.
    See end of chapter 4 for a brief discussion of the commands the
    editor understands.
    Example:
    edit dte

    SMTP
    ----
    This is where you put the directory where your mailboxes reside. All
    mailboxes, i.e. both the hamradio and uucp mailboxes should be in one
    directory.
    If this entry is commented out, the value of the environment variable
    'maildir' is used.
    (Don't worry about the curious name SMTP. It's called that way for
    historical reasons and compatibility with BM).
    Example:
    smtp c:/spool/mail

    QUEUEDIR
    --------
    This is where you put the directory where outgoing mail gets queued up.
    Typically, this is called /spool/mqueue or something like that. This is
    for hamradio mode only; in UUCP mode, the exterior mailer determines
    where it queues mail.
    Example:
    queuedir c:/spool/mqueue

    VIDEO
    -----
    Put a 1 here if you want direct writes into video ram, which is fast
    but tends to confuse CGAs and not-so-very-compatible PCs. A 0 will
    do all video updates through the BIOS, which is painfully slow.
    Example:
    video 1

    SOH-UUCP
    --------
    This is a sequence of words that tell PCElm that a new message begins.
    Uh.. message delimiter is the word I was looking for. Usually "From ",
    but may be anything at all if you are using weird mailers.
    If you have MMDF-style mailboxes (like in UUPC/extended), use the special
    keyword mmdf; otherwise, "From " (note the blank) or "Received "
    usually work.
    Example:
    SOH-UUCP "From "
    ( or, if you are using UUPC/extended,
    SOH-UUCP mmdf                )

    SOH-HAM
    -------
    See above, but for ham radio.
    Example:
    SOH-ham "From "

    HAM-EXT
    -------
    Extension for amateur radio
    The file extension your mailbox file has goes here. A mailbox is
    constructed from your username with the extension defined here appended to
    it. Note that even if your mailbox has no extension, you still need
    to define the dot "." as extension ! The dot is mandatory.
    Example:
    ham-ext ".txt"

    UUCP-EXT
    --------
    Extension for UUCP
    See above, but for uucp.
    UUPC usually has no extension, so we just define the dot as extension.
    Example:
    uucp-ext "."

    START
    -----
    Startmode for PCElm. If Startmode is "uucp", PCElm will start in
    uucp mode; anything else will cause PCElm to start in hamradio mode.
    Example:
    START hamradio

    COLORS
    ------
    Define various colours for display:
    The numbers below are hexadecimal numbers defining a foreground and
    background colour for various scenarios. The routine determining the
    colours is quite simpleminded, so please don't use spaces here.

    If you are confused as to what to enter here, either leave it alone
    or consult an IBM PC programming manual as to how these numbers are
    arrived at.

    The color codes are as follows:

      Background    |    Foreground
    ---------------------------------
    0   0   0   1   |   1   1   1   1 ---> 0x1f ---> Bright white on blue
    ---------------------------------
    B   R   G   B   |   I   R   G   B
    L   E   R   L   |   N   E   R   L
    I   D   E   U   |   T   D   E   U
    N       E   E   |   E       E   E
    K       N       |   N       N

    This will definitely get more comfortable to configure in a later version
    of PCElm. (Yes, I know I already said this a year ago. Bear with me.)

    Values are: normal screen, bold, more prompt, default at exit,
    selection bar.

    Example:
    COLORS 1f,4f,2f,07,6f

    UUCPCALL
    --------
    Format of uucp command
    Supported macros are:
    $   filename containing message header and body
    %   name of recipient
    &   subject of message (you shouldn't need this)

    PCElm constructs the workfiles and messagefiles that KA9Q NET and NOS
    needs by itself, but execs an exterior mailer in uucp mode so that
    headers peculiar to your particular implementation of uucp (or whatever)
    can be written. The exterior mailer is usually called rmail.exe or
    mail.exe. The macros $, & and % are expanded _once_, they may not occur
    multiple times in this line.
    For my version of UUPC (quite old), the following line works.
    Example:
    uucpcall "rmail % < $"

    or, try

    uucpcall "rmail -f $ %"

    for UUPC/extended newer versions. This works with UUPC/extended 1.11k
    and foregoes the need for a temporary file (should be a little bit
    faster).

    SEQUENCE
    --------
    Name of sequence file.
    This is the file where the numbers for message id's are stored.
    It is located in the mail spool directory.
    Example:
    sequence sequence.seq

    PRINT
    -----
    Name of print device.
    Put the device name of your line printer here, e.g. LPT1, LPT2 or
    LPT3. If you want to connect a serial printer, use 'mode' (the DOS
    command) to tie a serial port to a LPT device.
    Example:
    print lpt1

    WEEDOUT
    -------
    Headerlines to hide.
    A weedout list is a list of headerlines that you don't want to see
    when mail is displayed. It is annoying to get mail with 2 lines of text
    and 60 lines of header; using weedout you can shrink the displayed
    headers to just a few lines or nothing at all.
    Put the beginning of the headerline(s) after the weedout directive,
    and remember you need to quote the weedout list if there are spaces
    in it!
    Example:
    weedout "Reply-To: Message-Id: From: To: Subject: Received: From\32"

    With this example, you just get to see the Date: line, Status: line
    and X- headerlines if present.

    ESCAPE
    ------
    Escape-character to use in the builtin line editor.
    This is the character that is used to denote a command in the builtin
    line editor. If set (for example) to ".", you will need to preface
    every command with a dot, for example ".r 1" to read the 1st mail
    into the editor.
    Example:
    escape .

    USE-ED
    ------
    Drop directly into specified editor when composing mails.
    Many users of PCElm 3.01 found it annoying that they had to enter
    ".e" in the line editor to start their favorite full screen editor
    or to enter the builtin full screen editor when composing mail.
    Setting use-ed to 1 causes PCElm to start the editor defined with
    EDIT (see above) at once. Setting use-ed to 0 will start the builtin
    line editor first, like in version 3.01.
    Example:
    use-ed 1

    HELP
    ----
    Helplevel of PCElm.
    When set to 0, PCElm will display a short summary of possible
    commands below the list of mails that you have. When set to 1, PCElm
    will not display this summary; instead, you get to see a longer
    list of mails.
    Example:
    help 0

    OPTHDR
    ------
    Optional header lines to include in mails.
    OPTHDR gives you the capability to include your own "custom" header
    lines in mails you send. For example, you might want to include a
    line with the name of your company or your phone number.
    You can define up to 10 optional header lines, using opthdr0, opthdr1
    and so on up to opthdr9 as parameters. Optional header lines should
    always start with "X-"! If they start with other letters, you might
    confuse your (and other peoples!) mail transfer agents, so know
    what you are doing here.
    Example:
    opthdr0 "X-Organization: Dept. of Redundancy Dept."
    opthdr1 "X-Depression-Level: High"

    Note that too many optional header lines are generally frowned upon,
    as they increase the length (and therefore cost of transfer) of
    mails, often without increasing the information level of a mail.

    QUOTE
    -----
    The character(s) used to denote quoted text when replying to a mail.
    When you reply to a mail, it is usually a good idea to include some
    portions of the mail you reply to so that the recipient knows what
    you are talking about. When you use the 'R' command in PCElm (reply,
    including the original mail), every line of the original mail is
    prefixed by the characters that are defined by the quote parameter.
    This prefix tells the recipient that you are quoting him.
    Example:
    quote "> "

    ASK-TOGGLE
    ----------
    If set to 1, PCElm will ask you to specify a new hostname and new
    username when (T)oggling between hamradio and uucp mode. This is
    useful if you run both NOS and uucp mail, but have different hostnames
    in the two worlds. If set to 0, PCElm will assume that your host- and
    usernames are identical in hamradio and uucp mode.
    Example:
    ask-toggle 0

    PAGER
    -----
    The filename of your favorite pager goes here. If you don't set this
    parameter, PCElm will display mails using its internal pager.
    The macro $ denotes the name of the temporary file that gets passed
    to your pager.
    Example:
    pager "list $"

    ENABLEMIME
    ----------
    If set to 1, the MIME support in PCElm is activated. If set to 0,
    PCElm will display MIME mails like normal mails.
    Example:
    enablemime 1

    MULTIMEDIA
    ----------
    This is the name of the program that MIME-mail is passed to. MIME
    (Multipurpose Internet Mail Enhancements) is a standard for the
    transmission of multimedia mails; it is described in detail in RFCs
    1341 to 1344. I suggest that you at least browse through these RFCs to
    get an idea of what MIME can do.
    See chapter 9 for a more detailed description of how to set up
    PCElm for MIME. Really. A lot of things need to be set up for the
    multimedia stuff to work; this is not trivial.
    The macro $ is the name of the temporary file that gets passed to the
    multimedia program.
    Example:
    multimedia "metamail $"

    DOSIFY
    ------
    PCElm stores the mailboxes you are using in UNIX format. This has the
    advantage that you can use UNIX mailboxes directly, without conversion
    (for example mount the mail directory of a UNIX server on your PC), but
    has the disadvantage that printer output has line feeds only as end of
    line markers instead of the usual CR/LF sequence. Setting DOSIFY to 1
    will change LFs to CR/LFs in everything you print. It will not change
    your mailboxes or folders!
    Example:
    dosify 1

    DELETE-UNREAD
    -------------
    If set to 1, PCElm allows you to delete mails you have not yet read.
    When set to 0, PCElm will display a warning message to read the mail
    before deleting it.
    Example:
    delete-unread 0


    3.2 Environment Variables
    -------------------------
    The environment variable PCELM (or HOME) is mandatory. It must be set to
    the directory where the configuration file pcelm.rc resides. The alias
    file for mail aliases is also expected in the PCELM directory.
    At the DOS prompt, type "set pcelm=<your_home_directory>" or include
    that line in your autoexec.bat.
    Example:
    set pcelm=d:\usr\marvin

    You need to set the environment variable TMP to be able to read multipart
    MIME (multimedia mail) messages. This variable must be set to a drive
    and directory where the decoded parts of a mail are stored until all
    parts have been decoded and read, i.e. it should be a drive with some
    megabytes of free space left.
    If you don't plan to use the MIME extensions to PCElm, you will not need
    this.
    Example:
    set tmp=e:\tmp

    As you may have noticed in chapter 3.1, PCElm can also take some
    configuration parameters from environment variables. This is for backwards
    compatibility with older versions of PCElm. If a configuration parameter
    is specified both in an environment variable and in pcelm.rc, pcelm.rc wins.

    3.3 Other Files
    ---------------
    PCElm currently knows about three other files:

    ALIAS
    -----
    You can define aliases for often-used mail addresses, so that you need
    not type the complete email address all the time. This is especially
    convenient for mailings to a group of recipients.

    The alias file is called 'alias' and resides in your HOME directory.

    Lines in the alias file beginning with a hash '#' are taken to be comments.
    Lines that begin with spaces or tabs are continuation lines, i.e. are used
    for aliases that span several lines.

    All other lines have the format
    <alias> <1st recipient> <2nd recipient> ...

    Example:
    # This is my alias file
    hikaru dg2kk@dg2kk.ampr.org
    marvin marvin@dg5kx.ampr.org
    martin freiss.pad@sni.de
    andrew andrew@omega.uucp
    #
    ac-tcp dg2kk@dg2kk.ampr.org siebeck@infoac.rmi.de rmohr@infoac.rmi.de
    big-alias siebeck@infoac.rmi.de John.Doe@this.is.a.domain.name
         Jane.Doe@yet.another.address
         Murray.Bozinsky@robot.riptide.com

    Maximum line length is 127 characters. Aliases are not resolved
    recursively, i.e. the recipient may not be yet another alias.

    SIGNATURE
    ---------
    A signature is automatically appended to your mails, if a signature
    file is present. The signature file must be in your HOME directory
    and has the name <username>.sig; i.e. if your username (see USER
    in pcelm.rc) is marvin, the signature file is called marvin.sig .
        There is no length restriction on signatures; however signatures
    longer than 4 lines are generally frowned upon.

    The signature, if present, should contain your name and email address.

    PCELM.MSG
    ---------
    This is the message file. If you are installing a language other than
    English, be sure to read chapter 10.
    As detailed at the beginning of chapter 3, copy one of the supplied
    message files pcelm.eng or pcelm.deu to pcelm.msg.
    The message file must be in the HOME directory. Note that this makes
    it possible for each user to use PCElm in his native language.


    3.4 Starting PCElm
    ------------------
    Now you are ready to start PCElm. Run it on a copy of your mailbox
    first, so that you won't lose your mail if something goes wrong.
    Just type pcelm to start, no commandline arguments are necessary.


4) Using PCElm

    Though PCElm is written for interactive use, you can also use it to
    send mail from batch files or from the command line.
    Type
    pcelm <recipient> <subject> < filename
    or
    type filename | pcelm <recipient> <subject>
    to send mail from the command line, e.g.
    pcelm freiss.pad@sni.de "Hi there!" < mymail

    If you omit the subject, PCElm will generate a subject line of
    'No subject specified'.


    Normally, you'll want to use PCElm interactively. The rest of this
    chapter explains the commands PCElm understands.

    When PCElm starts up, it displays a status line at the top. Below that,
    up to 10 messages are displayed in the index, giving from left to right
    the message state (Read or Unread, Tagged, Deleted), the message number,
    the sender of the mail, the date the mail was sent, the length of the
    mail in Bytes and the subject line of the mail.
    The subject line is truncated to fit on the screen.

    In the lower half of the screen, 4 lines list some of the more often
    used commands (if you have set the HELP parameter described in the
    previous chapter to 1, you will see more mails instead of the command
    summary). You type commands by pressing the highlighted letter
    at the Command: prompt.

    Error messages (hopefully there aren't any) are displayed on the
    bottom line.

    * Note that the 'Q' and 'X' keys have exchanged their meanings
    * from releases below version 3.0.

    A short overview of the commands available:

    Up Arrow, Down Arrow, Page Up, Page Down, Home, End
        These keys move the 'select'-bar one message up, down, one page
        (= 10 messages) up, one page down, to the first message, to
        the last message in your mailbox.

    Return
        Displays the message you have currently selected. More on
        display commands below.

    +   Tag. Mark a mail for saving, deleting or forwarding.

    -   Untag. Delete a previous tag.

    F1  Function Key F1 displays a help page which lists all commands
        and a short explanation of what they do.

    F2  Function Key F2 toggles the video display mode
        (VRAM or BIOS writes to update the screen).

    DEL Delete the selected mail or all tagged mails.

    INS Undelete the selected mail.

    a   About PCElm. A page of text giving the version and the authors'
        names. Just an ego-fix for us :-)

    A   Alias editing. Drops you into a small full-screen editor, where
        you can edit your alias file. If you did not have an alias file
        before, it is created for you. You can of course also use other
        editors to edit the alias file.

    c   Change mailbox. This allows you to change your user id without
        leaving PCElm. For example, ham radio operators often have
        their first name as username and their call sign as another
        username. This is probably less useful in uucp.
        You will be prompted for a new fullname to match your new user
        id and you are prompted for a new hostname.

    C   Colour. Toggles from the user selected colours to default colours
        to default monochrome display.

    d   Delete the selected mail or all tagged mails.

    F   Freshen the mailbox. Mails marked for deletion will be deleted,
        new mail that has arrived in the meantime is processed and your
        mailbox is displayed anew.

    f   Forward the selected (or all tagged) mails to another user.
        You will be prompted for the recipient of the forwarded mail
        and for the subject line; the subject line defaults to the
        original subject with (fwd) appended to it.

    l   List unsent mails. Shows what files there are in the mail queue
        directory and who sent them to whom. It also gives you a chance
        to kill them (last chance to zap a mail if you mistakenly sent
        it). This currently works only in hamradio mode (will work in uucp
        mode in the next version).

    m   Send mail. You will be prompted for the recipient of the mail
        and the subject, after which you are dropped into the editor.
        More on editor commands below.
        You can specify multiple recipients delimited by blanks at the
        'Mail to:' prompt. If you do, a Cc: (Carbon Copy) line will
        automatically be generated.

    M   Send a mail with MIME-conforming headers. Not implemented yet!

    n   Next unread. Moves the select-bar to the next unread mail.

    p   Paint. Redraw the screen if it got corrupted.

    P   Print. Prints all tagged mails or the hilighted mail on a line
        printer. If 'print.com' of DOS is loaded, PCElm will queue the
        print job to 'print', so you can go on reading mail while your
        tagged mails are printed in the background.
        If 'print' is not loaded, PCElm will print the mails on the device
        specified in the configuration file (parameter 'print').

    Q   Quit. Quits from PCElm, saving all changes to your mailbox.

    r   Reply to a mail. You are dropped into the editor to compose your
        reply; after you are finished, mail is sent to the originator of
        the mail with a subject line of "Re: <original subject>".

    R   Reply to a mail. Same as above, but the original mail is included
        in your reply. This helps the recipient to understand what your
        reply is all about.

    s   Save the selected mail (or all tagged mails) to a file. You will
        be prompted for a filename, in which the message complete with
        header will be saved.

    S   change Start Of Header (SOH). This changes the 'magic word' PCElm
        looks for to determine the beginning of a mail. All sort of strange
        things may happen if you set a wrong SOH; be warned that you may
        destroy your mailbox if you fool around with this and then use
        a command that saves your mailbox to disk. 'S' is for experimenting
        and for use with mailboxes from foreign MTA's; for everyday use,
        you should set the SOH from the pcelm.rc file using the SOH-HAM
        and SOH-UUCP parameters.
        (The special keyword 'mmdf' causes the new SOH to be a line of
        Control-A's, as needed by MMDF and UUPC/extended).
        You must do a 'c'hange mailbox for the new SOH to take effect.

    t   Transmit from file. You will be prompted for the recipient of
        the mail, the subject, and the filename to transmit.
        Note that usually MTAs can only send pure ASCII files, binary files
        have to be encoded first.

    T   Toggle mailsystem. PCElm can handle 2 mailsystems, UUCP (Unix to
        Unix CoPy) and hamradio (for use with KA9Q NOS).
        When you want to switch mailsystems, hitting 'T' will prompt you
        for a new username, new fullname and a new hostname, since
        hostnames in the hamradio community (Example: dg5kx.ampr.org)
        and UUCP community (Example: atreju.rmi.de) sometimes differ.

    u   Undelete the selected mail.

    w   Write the selected mail (or all tagged mails) to a file. You will
        be prompted for a filename, in which the message will be saved
        without the header.

    X   Exit. Exits from PCElm immediately, without updating your mailbox.


    When you are prompted for new values for (for example) your fullname,
    PCElm pops up a window to do this. You can then either hit return,
    thus accepting the default value displayed or enter a new value.
    When the new value begins with a dollar sign, it is taken to
    be an environment variable (e.g. if you have an environment variable
    MYNAME=beeblebrox, entering $MYNAME here causes beeblebrox to be taken
    as the new value).


    Editor Commands
    ---------------
    When writing mail, PCElm drops you into a very simplistic line editor
    of its own. This editor is useful for writing short notes, but
    for longer mails you should use another editor of your choice.
    This editor must be able to take the name of a file to edit
    as its one and only commandline argument (something like
    "edit mail.txt" must work), and it must be able to create
    pure ASCII files. If at all possible, use an editor that does
    not terminate files with Control-Z.

    Commands understood by the line editor:
    Commands begin with a dot '.' in the first column of a line. A dot
    elsewhere in the text has no special meaning.

    .?      Help. Shows available commands.
    .e      Start the editor defined in pcelm.rc.
    .p      Print the message you have typed so far.
    .q      Quit. Aborts the mail.
    .r file Reads the file "file" into the message buffer. If "file"
            contains wildcards (i.e. '*' or '?'), you will be shown
            a list of files matching your command.
    .m num  Inserts the mail number "num" into the message buffer.
    ..      Put a dot in the first column of a line.
    .       End message.


    PCElm also sports a builtin full screen editor, which is selected
    if either no editor was defined in pcelm.rc and the environment
    variable EDITOR is not set or if you selected 'builtin+' as editor
    in pcelm.rc.
    This editor is included as 'editor of last resort'. It is definitely
    not perfect yet, but we liked it so much we included it.

    Commands understood by the fullscreen editor:
    Arrow keys, Pg Up, Pg Dn, Home, End
            those work as you would expect and move you around in the text.
    Alt-D   delete line
    Alt-F   find a string
    Alt-L   set left margin
    Alt-N   insert line.
    Alt-Q   quit, saving text.
    Alt-R   set right margin
    Alt-T   set tab size.
    Alt-W   toggle word wrap.
    Alt-X   quit _without_ saving text.
    Bsp     (backspace) delete character left from cursor.
    Del     delete character under cursor.
    F1      help screen

    Quirks:
    Maximum linelength is 160 characters.
    The bottom line on the screen is sometimes duplicated if you are scrolling;
    this affects only the screen though, the text is ok.

    If you are using the builtin full screen editor and are annoyed at its
    lack of functionality or bugs, tough :-). The simple fix is to use another
    editor.

    Display Commands
    ----------------
    When reading a mail, PCElm normally displays the mail one page at a
    time.

    The following keys have special meanings:

    Return  one line forward

    ?       Shows what commands are available.

    a       Show the current mail again.

    h       Show complete header of the mail you are currently reading.
            This is useful if you have configured a weed-out list so that
            you don't normally get to see the header, but want to have a
            peek at a mail's header none the less. Pressing 'h' again
            will switch back to the original display.

    q       quit to menu

    /       Search. You are prompted for a string to search for. The
            searching routine remembers the last item you searched for,
            so you can just press Return on subsequent invocations of '/'.


5) Troubleshooting
    Some of the things that can (and will, Murphy being what he is)
    go wrong and proposed solutions:

    Problem:
    PCElm says 'New mail has arrived' and beeps, though there is no
    new mail.

    Solution:
    You probably edited your mailbox with an editor once, and now there
    is a Control-Z at the end of it. This means that the mailbox file
    is now one character longer than all the single mails added up, so
    PCElm concludes that a new mail must have arrived in the meantime.
    Using a proper editor, zap the Control-Z.

    Problem:
    PCElm stubbornly says 'No Mail!', although you have verified there
    _is_ mail.

    Solution:
    1) The mail directory is configured wrong (check parameter SMTP in
       pcelm.rc)
    2) Your username is not what you think it is (check NAME in pcelm.rc)
    3) The extension for your mailbox file is incorrect (check HAM-EXT
        and UUCP-EXT in pcelm.rc)
    4) The Start-Of-Header (SOH) is wrong, and PCElm therefore can't
       parse mail headers correctly (check SOH-HAM and SOH-UUCP).

    Problem:
    Mails have parts of their header missing or have parts of the header
    at the _end_ of the mailbody or generally look strange.

    Solution:
    The Start-Of-Header (SOH) is wrong, and PCElm therefore can't
    parse mail headers correctly (check SOH-HAM and SOH-UUCP).

    Problem:
    Reading mail is ok, but I can't send UUCP mail.

    Solution:
    1) Check the uucpcall parameter in pcelm.rc. Verify that this commandline
       works by typing it in at the DOS prompt, expanding the ! and % macros
       by hand. For example, send a mail to yourself this way. If this
       doesn't work, check if the uucp mailer (mail.exe or rmail.exe) is
       in the path, and if the commandline is correct for your mailer
       (consult your uucp documentation for this).
    2) There may not be enough memory left to execute the mailer under
       PCElm. Get rid of some TSR programs or decrease the MAXLET
       parameter in pcelm.rc and try again.

    Problem:
    When writing mail, my favorite editor does not start up when using
    the .e comand.

    Solution:
    The editor is either not in the path or there is not enough memory left
    to start the editor. Check the path and/or get rid of some TSR programs
    or decrease the MAXLET parameter in pcelm.rc and try again.

    Problem:
    When writing mail, the original mail is not included when using an
    exterior editor when using the 'R' command and/or everything typed
    in the editor is lost.

    Solution:
    PCElm needs an editor that can take a filename to edit as a commandline
    argument. Check if this works by typing "<your_editor> filename" at
    the DOS prompt.
    Check if your editor is a pure ASCII editor. If you use a text
    processing system, maybe it starts up in document mode and thus uses
    a non-ASCII document representation.

    Problem:
    When reading MIME mail, the multimedia parts are not shown or played,
    although you have verified that multimedia is setup correctly.

    Solution:
    This is usually due to one of two things:
    1) Not enough memory. Try using another program to display images or
    play sounds that uses less memory. Alternatively, there are "swap"
    programs available as shareware that can swap PCElm out of memory to
    a disk file while displaying images or playing sounds, and load it back
    into memory later.

    2) If you are using metamail to display MIME mails, either metamail
    cannot find the mailcap file or metamail cannot find the programs it
    needs to display (or play) the mail.

6) Notes for interfacing PCElm with UUCP programs
    Since this seems to be the most difficult thing to set up, some notes
    on how PCElm feeds mail to UUCP.

    PCElm is basically a User Agent. It needs another program to actually
    _do_ something with the mail generated by PCElm; in uucp mode, PCElm
    executes a uucp mailer to do the hard work. This mailer is usually
    called 'rmail.exe'; note the 'usually', your mailer might have a
    different name.

    PCElm requires that the mailer be in the path; that the mailer
    accepts as argument the uucp address of the recipient and that
    there is some way to get the mail into the mailer, either by
    specifying the file containing the mailbody on the command line
    or by feeding it to the mailer via input redirection.

    The mailer must be able to paste the header lines and the mailbody
    created by PCElm to the headers it generates itself _without_
    mangling them and without inserting an empty line between its own header
    lines and the header supplied by PCElm.
    PCElm generates the From:, To:, Subject: and Message-Id: lines itself
    and feeds mail to the mailer in standard UUCP format.

    Why execute an exterior mailer at all?
    The rationale behind this is that (due to the many different types
    and versions of uucp software out there) it is nigh impossible to
    use all the features of the MTA directly from PCElm. Only your
    uucp mailer knows if you can do path aliasing and what headers are
    necessary for your particular network.
    On the other hand, we still want to have at least the mandatory header
    lines even if the mailer is real stupid and can't generate them itself.


    Reading mail:
    It seems that new versions of UUPC use MMDF style mailboxes, i.e.
    mails are separated by Control-A's. Whether or not this is a cool
    thing to do is a matter of opinion. Anyway, PCElm can handle this;
    use the special keyword mmdf in the SOH-UUCP parameter line
    in pcelm.rc to switch PCElm into MMDF mode.
    (i.e., the line in pcelm.rc should read
    SOH-UUCP mmdf
    ).

7) Notes for interfacing PCElm with Waffle
    I am not an expert on Waffle; I have never even used it myself. Other
    people have invested much effort into making PCElm work with Waffle
    though. There are 2 ways that I know of to make PCElm and Waffle
    talk to each other:

    - There is an ELM4WAF kit, done by Ian Justman (ianj%ijpc.uucp@pacbell.com),
      available by mailserver from listserver%ijpc.uucp@pacbell.com.
      This transmutates Waffles idea of a mailbox to something PCElm can
      live with.

    - Jack Otto (Jack.Otto@vuw.ac.nz) does it in a different way. He wrote the
      following paragraph on how to interface PCElm with WAFFLE:

    Here's more details for those who asked.

    Getting PCElm and Waffle to work together.

    Changes in PCElm.RC

    -----
    #SOH-UUCP mmdf
    SOH-UUCP "^A^A^A^A"
    SOH-ham "^A^A^A^A"
    ham-ext "."
    uucp-ext ".F"
    START uucp
    #uucpcall "rmail -f $ %"
    uucpcall "uusend $ %"
    -----

    where ^A is Control-A, ASCII character 1.  So the start of header is
    only four ASCII character Control-A's.  While this will read Waffle's
    messages, PCElm written messages of only 4 ^A's (mmdf setting) on the
    line, will give a null header with Waffle.  Netmail messages in Waffle
    usually have "^A^A^A^AFrom ..." as SOH.

    For a message file with at least one message in it, Waffle expects 4 (?)
    ^A's with no terminating CR/LF at the end of the file, ready for the
    next SOH. At least something to that effect, I gather.  If you save such
    a file with PCElm, it will add the CR/LF, which doesn't bother PCElm,
    but Waffle would treat that as NO header for the next message appended.

    If the ^A's are not at the end of a file of messages, Waffle's RMail
    does not write any and puts the next message as if it were still the
    body of the previous message.  This can happen in two ways. 1) The empty
    message was deleted in PCElm.  2) Another message was appended to the
    file with PCElm which does not append the ^A's.

    * IMPORTANT *  To avoid this in PCElm: don't delete that last empty
    message; don't save a message to a file which Waffle writes to.

    In PCElm, if you save a message to name.f, it keeps the SOH.  Using SOH
    of mmdf, does not write the 4 ^A's.

    uusend is uusend.bat, for Waffle's RMail, containing at least:

    -----
    RMail -u<your-username> %2 <your-mailsent-username> <%1
    -----

    where <your-mailsent-username> is optional, effectively a CC: to your
    mailsent file in Waffle format.  eg, if it is mailsent, a copy of the
    message is written to mailsent.f   %2 is the address to be sent to, %1
    is the message with headers.

    Mine is: RMail -ujackotto %2 mailsent <%1

    Be careful with long & multiple addresses that may reach the limit of
    Dos's line length.  Using aliases from Waffle's alias file instead of
    PCElm's helps there.

    Waffle's *.i file won't be accurate, but I understand that there is a
    utility to redo the *.i files.

    Set the maildirectory to the dir with the *.f files, with smtp in
    PCElm.RC or environment setting MailDir.  The username for PCElm will
    have to be your actual username, so you'll have to change to the
    mailbox.f file once in PCElm. Or ...

    Edit your aliases file in ...\Waffle\System\ to have RMail deposit your
    mail to a pathfilename of your choice, instead of to mailbox in the
    ...\Waffle\User\Username\ dir.  This way, all your *.f files can be in
    the one directory. Eg, for me:

    jackotto        = C:\Mail\JackOtto
    news            = C:\Mail\News
    mailsent        = C:\Mail\MailSent

    I also alias root, system, etc to jackotto, so everything should go to
    C:\Mail\JackOtto.F  If you use your username for the filename, PCElm
    will start with the file your incoming mail is sent to.

    To send to a newsgroup from PCElm, have lines like the following in
    aliases as well.

    <alias> | ...\Bin\RNews -m -n<newsgroup> -unews -f<your-address>

    Eg,
    vuw-events | D:\Progs\RNews -m -nvuw.events -unews -fJack.Otto@vuw.ac.nz

    The -f switch is optional, I think.  Handy to use if your return address
    for the network is not what PCElm or RMail puts in the From: line.

    One annoying bug with PCElm is that it doesn't handle Header lines
    greater than (about) 127 characters too well.  I wrote a program (C2M)
    that splits such lines and does a few other things as well.  I now
    process all files written by Waffle's RMail with it, writing to files
    with other names and never use PCElm to access those original files.  It
    also overcomes the problem with RMail expecting trailling ^A's.

    So I have:

    jackotto        = C:\Mail\JackIn

    and convert it to C:\Mail\JackOtto for PCElm to read, deleting JackIn.F
    after the conversion.  That bug should be fixed with the next version of
    PCElm.

    Otherwise, the rest is straight forward for setting up Waffle and PCElm.

    Try it and let me know if I've missed something out or haven't quite
    explained something properly.

    Please let me know if this has been enought detail for you to get it
    working.

    Jack.

    ------------------------------------------------------------------------
    Jack Otto  (Chaplaincy)             Telephone: Extn 8655  (a/h) 472-3257
    Victoria University of Wellington, NZ       E-Mail:  Jack.Otto@vuw.ac.nz


    The long header lines bug Jack talks about is fixed in releases 3.1 and
    later versions. Also, some changes were made to the MMDF mode to make it
    more robust when using PCElm with Waffle. There is probably still room
    for improvement, though - write if you are having trouble.

8) Notes for interfacing PCElm with UNIX servers
    For this, you need PC-NFS ((C) SUN Microsystems), PC-DFS ((C) Siemens
    Nixdorf Informationssysteme AG) or some other NFS package for PCs.
    On the UNIX host, export the mail directory to your PC (consult your
    system administrator on how to do this). On the PC, mount the mail
    directory as a network drive, and tell PCElm that this is the drive
    where the mailboxes reside (Parameter SMTP in the pcelm.rc file).
    Voila - you can read mail.
    To send mail, use the command "rsh <name> % < $" as UUCPCALL parameter
    in the pcelm.rc file. For instance, if your server is called charlie,
    "rsh charlie % < $" would be the right thing to use.

    However, be warned that the NFS lockdemons on some UNIX systems do not
    work properly, i.e. you might lose mail that arrives at the exact moment
    when you are quitting PCElm, when both PCElm and the MTA will try to
    write to the mailbox.

9) Notes on Multimedia Mail
    PCElm tries to do something meaningful with mails that are MIME-
    compliant. MIME is defined in RFCs 1341 to 1344; if you want to
    use MIME intensively, I suggest that you at least browse through
    these RFCs to get an idea for what MIME is and what it can do for
    you.

    Let me warn you that the MIME-stuff in PCElm is not for the faint
    of heart. I developed the MIME-interface for PCElm because I was asked
    to hold a seminar on MIME at a convention and wanted some hands-on
    experience with it. Obviously, MS-DOS is not the operating system of
    choice for multimedia applications; MS-Windows, OS/2 or Unix are much
    better suited for this.
    OK, for those I did not frighten away yet, here goes...

    PCElm normally makes use of the "metamail" program to do something with
    MIME-mails. This is part of the "Let other programs do the dirty
    work" maxim that PCElm follows when sending mails; this has two
    advantages: you can select a program of your choice to do something
    with the multimedia mails, and it is standardized in RFC 1343.

    "metamail" is available by anonymous FTP from thumper.bellcore.com,
    in directory /pub/nsb/mm/dos. I was not sure if I can legally
    include it in the PCElm distribution, so I did not.

    As detailed in Chapter 3, you tell PCElm what program to use to
    display MIME-mails by specifying the name of the program with the
    multimedia parameter. PCElm can tell that the mail you are reading
    now is a MIME-compliant mail by looking at the MIME-Version header
    line of the mail. If it is there, it is a MIME mail.
    To determine what _kind_ of MIME mail it is, metamail (which is
    spawned by PCElm) then looks at the Content-Type header line.
    Depending on what metamail finds there, metamail then spawns a
    GIF- or JPEG-viewer for pictures, a MOD-player for audio mails or
    whatnot. To find out what program to spawn for what type of mail,
    metamail looks into a configuration file called mailcap.

    Mailcap entries are quite simple: on the left hand of a line, you
    specify what the Content-Type header line looks like, and on the right
    hand you specify what program is used to "display" the mail.

    An example mailcap file might look like this:

    # Copyright (c) 1991 Bell Communications Research, Inc. (Bellcore)
    #
    # Permission to use, copy, modify, and distribute this material
    # for any purpose and without fee is hereby granted, provided
    # that the above copyright notice and this permission notice
    # appear in all copies, and that the name of Bellcore not be
    # used in advertising or publicity pertaining to this
    # material without the specific, prior written permission
    # of an authorized representative of Bellcore.  BELLCORE
    # MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY
    # OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS",
    # WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
    #
    # Prototype Mailcap file
    # Note that support for text & multipart are "built in" to metamail,
    # as are rudimentary support for message, and application.
    # However, any of these may be overridden in mailcap.
    #
    # Note that users may override or extend this with a .mailcap
    # file in their own directory.  However, there is NO NEED
    # for them to copy entries from this file, as metamail will
    # pick up entries from both the system and personal mailcap files.
    #
    audio/*; audio %s

    image/jpeg; hiview %s
    image/gif; svga %s
    image/*; cview %s+
    message/partial; showpart %s %{id} %{number} %{total}
    message/external-body; showext %s %{access-type} %{name} %{site} %{directory} %{mode} ; needsterminal

    # If you have an interactive Postscript interpreter, you should think carefully
    # before replacing lpr with it in the following line, because PostScript
    # can be an enormous security hole.  It is RELATIVELY harmless
    # when sent to the printer...
    application/postscript ; print %s ; label="A Postscript File"

    Note that the Content-Type and the program names and possible options
    are seperated by ";".

    Metamail looks for the mailcap file in both the root and the "current"
    directories.

    One special case for MSDOS is the message/partial subtype. This MIME
    Content-Type is used to cope with multipart mails, i.e. mails that
    would have been too long for a single mail message and have therefore
    been split into several parts. PCElm can cope with this by using the
    'showpart.bat' batchfile included in this distribution; however,
    showpart.bat can only handle one multipart message at a time in
    PCElm 3.2.

    Please check the above mentioned RFCs for more information about MIME
    and about metamail and how to set it up. You might also find the
    newsgroup comp.mail.mime interesting if you are on Usenet.

    You can, of course, use other programs than metamail to display
    MIME mails. Just put the name of your favourite program in the
    pcelm.rc file, in the parameter 'multimedia'.

    Well, to conclude this chapter, I have successfully decoded both
    single- and multipart pictures and audio mails with PCElm, so I guess
    that the simpler applications of MIME work with PCElm. Be warned,
    however, that many of the nicer things in MIME won't work with MSDOS,
    be it because of memory constraints (640 kB just is not enough), be it
    because MS-DOS is a singletasking operating system. Also, sending MIME
    mails is not supported yet. Yet!

10) Languages
    PCElm can be configured to speak other languages than English. This
    is possible because all messages displayed on the screen are contained
    in a seperate message file, 'pcelm.msg'. Currently, message files
    in English ('pcelm.eng'), German ('pcelm.deu'), Dutch ('pcelm.ned')
    and Spanish ('pcelm.esp') exist - if you create your own message file
    in another language, be sure to send it to us, so that we can include
    it (with proper credit) in the next distribution.
    The appropriate message file must be copied (or renamed) to 'pcelm.msg'
    before using PCElm.

    The message file has the following format:
    Empty lines and lines starting with a hash '#' are ignored.
    Other lines have the form
    <number>:<text>, for example
    150:"This is a line"

    Never change the message number - PCElm uses this number to be able
    to display the right message at the right time.
    You can change the text in quotes to your liking, but be warned that
    PCElm displays all and every message just as it appears in the message
    file. If you do something wrong, you will end up with a fancy-looking
    display. Keep a copy of the original message file for safety's sake.

    You can use escaped decimals in the message file (e.g. \\32 is ' ') as
    described in chapter 3.1.

    You can also change the keys that are used as command keys in the main
    menu - message 83 holds all keys (except function keys) that work.
    This is a good thing if you want to keep the commands intuitive;
    'c' for 'change mailbox' is good to remember in English, but (for example)
    a German user would want 'W' for 'Wechsele Postfach' as a hotkey.

    If you create a message file in a new language, we would like to have
    it and to include it (with proper credit given) in a future release
    of PCElm.

    This manual is for the English version of PCElm. Foreign language versions
    use different hotkeys for most of the commands. At the time of this
    writing, this manual exists only in English, but you should be able
    to figure out which keys do what from the help screen (press F1 to
    see the help screen, regardless of what language you have configured).
    Initial setup is the same for all versions of PCElm however.


11) Credits
    We would like to thank Dave Taylor for programming the original ELM
    and for the idea for the user interface used both in ELM and PCElm.
    Thanks to Syd Weinstein, coordinator of the USENET ELM, for his
    good work.
    Thanks to Barksdale Garbee II, N3EUA, Gerard van der Grinten, PA0GRI,
    Phil Karn, KA9Q, and Dave Trulli, NN2Z, for creating BM.

    Thanks to Andrew Hardie, ash@omega.uucp, who suffered through the
    early beta versions and wins grand prize in bug-finding :-).

    Thanks to Daniel Santos y Guillen (daniel@labdig.edu.ar) for the
    spanish message file, Onno Hardebol (ohb@oceonics.nl) for the Dutch
    message file, Ian Justman (ianj@ijpc.uupc) and Jack Otto
    (Jack.Otto@vuw.ac.nz) for their work on interfacing PCElm with Waffle.

    We would also like to point out that PCElm is (apart from the idea
    for the user interface) not in any way derived from or connected
    with ELM. If you are using USENET news, the group comp.mail.elm
    is NOT the place to ask questions about PCElm.

12) The Future
    Just some things that _might_ be incorporated in PCElm in a future
    release and some that won't be:

    - a Windows 3.1 aware PCElm. Ask Wolfgang Siebeck (siebeck@infoac.rmi.de)
        for details. A beta version exists.

    - a version of PCElm for OS/2. PCElm _might_ run under OS/2 in the
        DOS window; I (still) have no way of finding out.

    - if I have the time (and user feedback is positive), I'd like to
      improve the MIME stuff and make PCElm really MIME-compatible.

    - incorporating a newsreader into PCElm - this has been on the wish-
      list for some time, but as there are some quite good newsreaders
      out there by now, as nobody seems to be really hot for this and as
      I face (again) the dilemma that every news-package out there seems
      to use its own format for storing articles I'll probably scrap this.

