DECLARE SUB GetFileNames ()
'This Program is used to convert an Address book from pine to
'   a text format that can be read by other Mail programs
'   such as Pegasus
'Assumes that arguments in a line on pine are separated by Tabs (ascii 9)
'
'sample input text line from pine address book:
'
'Bill   Bill Farmer farmer@esslink.com
'
'Sample Text output:
'
'Name:            Bill Farmer
'Key:             Bill
'E-mail address:  farmer@esslink.com
'--
'
'This program was written for Ms Basic PDS 7.1
' to convert this to Qbasic, Remove the "CONST" part of the CONST statements
' below
'
DECLARE SUB SplitLine (NumArgs%, Args$(), MaxArgs%, Split%, Cl$)
DEFINT A-Z

DIM SHARED a$(1 TO 3)
CONST BLANK = 32, CR = 13, LF = 10, TABC = 9

	CALL GetFileNames 'Get File names into array a$()

	OPEN a$(1) FOR INPUT AS 1
	OPEN a$(2) FOR OUTPUT AS 2
	

	DO UNTIL EOF(1)
		LINE INPUT #1, x$
	'Get the values into array
						 '(NumArgs, Args$(), MaxArgs, Split, Cl$)
		CALL SplitLine(N, a$(), 3, TABC, x$)

		PRINT #2, "Name:            " + a$(2)
		PRINT #2, "Key:             " + a$(1)
		PRINT #2, "E-mail address:  " + a$(3)
		PRINT #2, "--"
		PRINT #2, ""
	LOOP
	CLOSE
SYSTEM

SUB GetFileNames
	'Get the command line arguments into array
						 '(NumArgs, Args$(), MaxArgs, Split, Cl$)
		CALL SplitLine(N, a$(), 2, BLANK, COMMAND$)
GetFile:
	IF N = 0 THEN
		LINE INPUT "Enter Name of Pine Address file: ", a$(1)
		LINE INPUT "Enter Name of Pegasus Address output file:", a$(2)
	END IF
	IF LTRIM$(RTRIM$(UCASE$(a$(1)))) = LTRIM$(RTRIM$(UCASE$(a$(2)))) THEN
		PRINT "Output File Cannot be the same as the input file"
		GOTO GetFile
	END IF
END SUB

'SUB procedure to get a text line and split into arguments.
'Parameters:  NumArgs : Number of command line args found.
'             Args$() : Array in which to return arguments.
'             MaxArgs : Maximum number of arguments array can return.
'             Split   : Ascii value of Split character
'             Cl$     : String to split
SUB SplitLine (NumArgs, Args$(), MaxArgs, Split, Cl$) STATIC

	NumArgs = 0
	Cl$ = RTRIM$(Cl$)
	FOR i = 1 TO MaxArgs
		Cl$ = LTRIM$(Cl$)
		L = LEN(Cl$)
		IF L = 0 THEN EXIT SUB
		x = INSTR(Cl$, CHR$(Split))
		IF x > 0 THEN
			a$(i) = LEFT$(Cl$, x)
			Cl$ = RIGHT$(Cl$, L - x)
		ELSE
			a$(i) = Cl$
		END IF
		NumArgs = NumArgs + 1
	NEXT i
END SUB

