Unit mouse;

{------------------------------------------------------------}
{ For Turbo Pascal Release 4.n. Won't work with older levels }
{ IMplements calls to mouse device driver.  Works with the   }
{ Logitech and Microsoft mice, and anything else compatible. }
{                                                            }
{                           NOTE!!!                          }
{      COMPILER OPTIONS MUST BE SET TO FORCE FAR CALLS!      }
{      If not, user defined task installed by minstTask      }
{                   will crash the system.                   }
{------------------------------------------------------------}

Interface

Uses DOS;                     { For interrupts and registers }

Const
  MDD = $33;             { Interrupt for mouse device driver }

Type
  resetRec = record        { Initialized by mouse function 0 }
    exists   : Boolean;           { TRUE if mouse is present }
    nButtons : integer;                 { # buttons on mouse }
  End;

  locRec = record    { Initialized by mouse fcns 3, 5, and 6 }
    buttonStatus,    { bits 0-2 on if corresp button is down }
    opCount,               { # times button has been clicked }
                             { opCount not returned by fcn 3 }
    column,                                       { position }
    row      : integer;
  End;

  moveRec = record             { Initialized by mouse fcn 11 }
    hCount,                        { net horizontal movement }
    vCount : integer;                { net vertical movement }
 End;

Var  Reg : Registers;

{ These are the Microsoft mouse functions }
Procedure mReset (var mouse : resetRec);       { function  0 }
Procedure mShow;                               { function  1 }
Procedure mHide;                               { function  2 }
Procedure mPos (var mouse : locRec);           { function  3 }
Procedure mMoveto (col, row : integer);        { function  4 }
Procedure mPressed (button : integer;
                    var mouse : locRec);       { function  5 }
Procedure mReleased (button : integer;
                    var mouse : locRec);       { function  6 }
Procedure mColRange (min, max : integer);      { function  7 }
Procedure mRowRange (min, max : integer);      { function  8 }
Procedure mGraphCursor (hHot, vHot : integer;
                   maskSeg, maskOfs : word);   { function  9 }
Procedure mTextCursor (ctype, p1, p2 : word);  { function 10 }
Procedure mMotion (var moved : moveRec);       { function 11 }
Procedure mInstTask (mask,
                     taskSeg, taskOfs : word); { function 12 }
Procedure mLpenOn;                             { function 13 }
Procedure mLpenOff;                            { function 14 }
Procedure mRatio (horiz, vert : integer);      { function 15 }
{------------------------------------------------------------}

IMPLEMENTATION

Function lower (n1, n2 : integer) : integer;  { Local to unit}
Begin
  If n1 < n2 then lower := n1
  Else lower := n2;
End;

Function upper (n1, n2 : integer) : integer;  { Local to unit}
Begin
  If n1 > n2 then upper := n1
  Else upper := n2;
End;
{ --------------------------- }
Procedure mReset;        { Resets mouse to default condition }
Begin
  reg.ax := 0;
  intr (MDD, reg);
  if reg.ax <> 0 then
    mouse.exists := TRUE
  else
    mouse.exists := FALSE;
  mouse.nButtons := reg.bx;
End;
{ --------------------------- }
Procedure mShow;                 { Make mouse cursor visible }
Begin
  reg.ax := 1;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mHide;               { Make mouse cursor invisible }
Begin
  reg.ax := 2;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mPos;              { Get mouse status and position }
Begin
  reg.ax := 3;
  intr (MDD, reg);
  mouse.buttonStatus := reg.bx;
  mouse.column := reg.cx;
  mouse.row := reg.dx;
End;
{ --------------------------- }
Procedure mMoveto;       { Move mouse cursor to new location }
Begin
  reg.ax := 4;
  reg.cx := col;
  reg.dx := row;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mPressed;  { Get pressed info about a given button }
Begin
  reg.ax := 5;
  reg.bx := button;
  intr (MDD, reg);
  mouse.buttonStatus := reg.ax;
  mouse.opCount := reg.bx;
  mouse.column := reg.cx;
  mouse.row := reg.dx;
End;
{ --------------------------- }
Procedure mReleased;      { Get released info about a button }
Begin
  reg.ax := 6;
  reg.bx := button;
  intr (MDD, reg);
  mouse.buttonStatus := reg.ax;
  mouse.opCount := reg.bx;
  mouse.column := reg.cx;
  mouse.row := reg.dx;
End;
{ --------------------------- }
Procedure mColRange;            { Set column range for mouse }
Begin
  reg.ax := 7;
  reg.cx := lower(min,max);
  reg.dx := upper(min,max);
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mRowRange;               { Set row range for mouse }
Begin
  reg.ax := 8;
  reg.cx := lower(min,max);
  reg.dx := upper(min,max);
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mGraphCursor;          { Set mouse graphics cursor }
Begin
  reg.ax := 9;
  reg.bx := hHot;
  reg.cx := vHot;
  reg.dx := maskOfs;
  reg.es := maskSeg;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mTextCursor;               { Set mouse text cursor }

   { NOTES:                                            }
   { Type 0 is the software cursor. When specified, p1 }
   {   and p2 are the screen and cursor masks.         }
   { Type 1 is the hardware cursor. When specified, p1 }
   {   and p2 are the start and stop scan lines, i.e.  }
   {   the cursor shape.                               }

Begin
  reg.ax := 10;
  reg.bx := ctype;
  reg.cx := p1;
  reg.dx := p2;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mMotion;   { Net movement of mouse since last call }
                             { Expressed in mickeys (1/100") }
Begin
  reg.ax := 11;
  intr (MDD, reg);
  moved.hCount := reg.cx;
  moved.vCount := reg.dx;
End;
{ --------------------------- }
Procedure mInstTask;             { Install user-defined task }
Begin
  reg.ax := 12;
  reg.cx := mask;
  reg.dx := taskOfs;
  reg.es := taskSeg;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mLpenOn;   { Turn on light pen emulation (default) }
Begin
  reg.ax := 13;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mLpenOff;           { Turn off light pen emulation }
Begin
  reg.ax := 14;
  intr (MDD, reg);
End;
{ --------------------------- }
Procedure mRatio;                { Set mickey to pixel ratio }
Begin

   { NOTES:                                       }
   { Ratios are R/8.                              }
   { Default is 16 for vertical, 8 for horizontal }

  reg.ax := 15;
  reg.cx := horiz;
  reg.dx := vert;
  intr (MDD, reg);
End;
{ --------------------------- }

End.
