unit rnrmenu;  {menus for rnr}

{$I rnr-def.pas}


interface

uses rnrglob,rnrconf,genericf,rnrio;

{ don't add more than one space in a row to a menu }
{ don't add a space at the beginning or the end }

procedure menuempty;
procedure menutitle(title: string);
procedure addtomenu(key: char; title: string; reminder: string);
procedure addspacetomenu;

function getmenu: char;

implementation

const
  maxmenuitems=15;
  menuitemlen=30;

{from linedraw.pas}
  singletlcornerchar=#218;         {top left corner}
  singletrcornerchar=#191;         {top right corner}
  singleblcornerchar=#192;         {bottom left corner}
  singlebrcornerchar=#217;         {bottom right corner}
  singlehlinechar=#196;            {horizontal line}
  singlevlinechar=#179;            {vertical line}

  singleljointchar=#195;           {joint, on left side}
  singlerjointchar=#180;           {joint, on right side}
  singletjointchar=#194;           {joint, on top}
  singlebjointchar=#193;           {joint, on bottom}

  singlecrosschar=#197;            {where two lines cross}

type
  menustring=string[menuitemlen];

  menuelementt=
    record
      key: char;
      title: menustring;
    end;

  menut=
    record
      title: menustring;
      numelements: integer;
      elements: array[1..maxmenuitems] of menuelementt;
    end;

var
  themenu: menut;

  tlcornerchar: char;
  trcornerchar: char;
  blcornerchar: char;
  brcornerchar: char;
  hlinechar: char;
  vlinechar: char;
  ljointchar: char;
  rjointchar: char;
  tjointchar: char;
  bjointchar: char;
  crosschar: char;

procedure menuempty;

begin
  themenu.numelements := 0;
  themenu.title := '(error - no title)';
end;

procedure menutitle;

begin
  themenu.title := copy(title,1,menuitemlen);
end;

procedure addtomenu;

begin
  if themenu.numelements<maxmenuitems then
    begin
      inc(themenu.numelements);

      themenu.elements[themenu.numelements].key := key;
      themenu.elements[themenu.numelements].title :=
       copy(title,1,menuitemlen);

      if length(title)+length(reminder)<menuitemlen then
        themenu.elements[themenu.numelements].title :=
         copy(title,1,menuitemlen)+
         rightjustify(reminder,menuitemlen-length(title),' ');
    end;
end;

procedure addspacetomenu;

begin
  addtomenu(nul,'','');
end;

function getmenu;

const
  menurow=3;
  menucol=1;

var
  result: char;
  gotakey: boolean;
  currpos: integer;
  tempy: integer;

begin
  result := nul;

  if console then
    begin
      tlcornerchar := singletlcornerchar;
      trcornerchar := singletrcornerchar;
      blcornerchar := singleblcornerchar;
      brcornerchar := singlebrcornerchar;
      hlinechar := singlehlinechar;
      vlinechar := singlevlinechar;
      ljointchar := singleljointchar;
      rjointchar := singlerjointchar;
      tjointchar := singletjointchar;
      bjointchar := singlebjointchar;
      crosschar := singlecrosschar;
    end
  else
    begin
      tlcornerchar := '+';
      trcornerchar := '+';
      blcornerchar := '+';
      brcornerchar := '+';
      hlinechar := '-';
      vlinechar := '|';
      ljointchar := '+';
      rjointchar := '+';
      tjointchar := '+';
      bjointchar := '+';
      crosschar := '+';
    end;

  xlowvideo;

  xgotoxy(menucol,menurow);
  xwritesss(
   tlcornerchar,
   replicate(hlinechar,menuitemlen+2),
   trcornerchar);

  xgotoxy(menucol,menurow+1);
  xwritessss(vlinechar,'= ',replicate(space,menuitemlen),vlinechar);
  writexy(menucol+3,menurow+1,themenu.title);

  xgotoxy(menucol,menurow+2);
  xwritesssss(
   ljointchar,
   hlinechar,
   tjointchar,
   replicate(hlinechar,menuitemlen),
   rjointchar);

  for currpos := 1 to themenu.numelements do
    begin
      xgotoxy(menucol,menurow+currpos+2);
      xwritesssss(
       vlinechar,
       space,
       vlinechar,
       replicate(space,menuitemlen),
       vlinechar);

      if themenu.elements[currpos].key=nul then
        begin
          xgotoxy(menucol,menurow+currpos+2);
          xwritesssss(
           ljointchar,
           hlinechar,
           crosschar,
           replicate(hlinechar,menuitemlen),
           rjointchar);
        end
      else
        begin
          xgotoxy(menucol+1,menurow+currpos+2);
          xwritesss(
           themenu.elements[currpos].key,
           vlinechar,
           themenu.elements[currpos].title);
        end;
    end;

  xgotoxy(menucol,menurow+themenu.numelements+1+2);
  xwritesssss(
   blcornerchar,
   hlinechar,
   bjointchar,
   replicate(hlinechar,menuitemlen),
   brcornerchar);

  currpos := 1;

{ if there's nothing to choose from, then we've got all we ever will }
  gotakey := (themenu.numelements<=0);
  while not gotakey do
    begin
      xhighvideo;

      xgotoxy(menucol,menurow+currpos+2);
      xwrites('>');

      xgotoxy(menucol+2,menurow+currpos+2);
      xwritess('<',themenu.elements[currpos].title);

      xlowvideo;

      xgotoxy(menucol+1,menurow+currpos+2);

{ with the mouse:  force column 2, don't force the row }
{ do this from row (menurow+) 1 through numelements+3 (the border+the title) }

      result := xreadkeyextended(2,0,menurow,menurow+themenu.numelements+3);

{ left goes back a menu }
      if result=keyleft then
        result := esc;

{ so does `=', so you can have something to click on }
      if result='=' then
        result := esc;

{ right goes forward a menu }
      if result=keyright then
        result := cr;

      if result=esc then
        gotakey := true;

      if result=cr then
        result := themenu.elements[currpos].key;

      if result=keydown then
        begin
          xgotoxy(menucol,menurow+currpos+2);
          xwrites(vlinechar);

          xgotoxy(menucol+2,menurow+currpos+2);
          xwritess(vlinechar,themenu.elements[currpos].title);

          inc(currpos);
          if currpos>themenu.numelements then
            currpos := 1;
          if themenu.elements[currpos].key=nul then
            inc(currpos);
          if currpos>themenu.numelements then
            currpos := 1;
        end;

      if result=keyup then
        begin
          xgotoxy(menucol,menurow+currpos+2);
          xwrites(vlinechar);

          xgotoxy(menucol+2,menurow+currpos+2);
          xwritess(vlinechar,themenu.elements[currpos].title);

          dec(currpos);

          if currpos<1 then
            currpos := themenu.numelements;
          if themenu.elements[currpos].key=nul then
            dec(currpos);
          if currpos<1 then
            currpos := themenu.numelements;
        end;

      for tempy := 1 to themenu.numelements do
        if result=themenu.elements[tempy].key then
          gotakey := true;
    end;

  for currpos := -1 to themenu.numelements+1+1 do
    writexy(menucol,menurow+currpos+1,replicate(space,menuitemlen+6));

  getmenu := result;
end;

end.
