{$N+}

Unit InvUse10;

interface

uses app,dialogs,drivers,msgbox,objects,views;

type pExtended     = ^Extended;
     pInvertedList = ^tInvertedList;
     tInvertedList = object(tSortedCollection)
                      Constructor Init;
                      Function Compare(Key1,Key2:Pointer):integer; virtual;
                     end;
     pInvertedView = ^tInvertedView;
     tInvertedView = object(tListViewer)
                      pInvList : pInvertedList;
                      Constructor Init(var Bounds:tRect;ANumCols:integer; AHScrollBar,AVScrollBar:pScrollBar);
                      Function GetText(Item,MaxLen:integer):string; virtual;
                     end;
     pInvLine      = ^tInvline;
     tInvLine      = object(tView)
                      Procedure Draw; virtual;
                     end;
     pInverted     = ^tInverted;
     tInverted     = object(tdialog)
                      pInvList : pInvertedList;
                      pInvView : pInvertedView;
                      Constructor Init(var Bounds:tRect);
                      Procedure AddNew;
                      Procedure HandleEvent(var Event:tEvent); virtual;
                      Function GetNrOfPoints:integer;
                     end;
     pMyScroll     = ^tMyScroll;
     tMyScroll     = object(tScrollBar)
                      Constructor Init(var Bounds:tRect);
                     end;
     pResultView   = ^tResultView;
     tResultView   = object(tListViewer)
                      List : pCollection;
                      pScrl : pMyScroll;
                      Function GetText(Item,MaxLen:integer):string; virtual;
                      Procedure HandleEvent(var Event:tEvent); virtual;
                     end;
     pGraphSize    = ^tGraphSize;
     tGraphSize    = object(tdialog)
                      yLow,yHigh,YStep,
                      XLow,XHigh,XStep : pinputline;
                      Constructor Init(Print:boolean);
                      Procedure HandleEvent(var Event:Tevent); virtual;
                      Procedure EndModal(Command:word); virtual;
                     end;

const cmInvAddNew = 1000;hcInvList = 1002;
      cmInvDelOld = 1001;
      cmPlot      = 1002;
      cmPrintPlot = 1003;

var Lx,Hx,Ly,Hy : extended;

implementation

Function t(aa : extended;b:word):string;

Var txt : string;
    tel : word;
    Power : extended;

begin
 Power := 1;
 for tel := 1 to b do
  Power := Power*10;

 if ((Abs(aa) <= Power/100) and (Abs(aa) >= 100/Power)) or (aa=0) then
   str(aa:15:20,txt)
 else
   str(aa:b-1,txt);
 if aa >= 0 then
  txt := ' '+txt;
 t := copy(txt,1,b);
end;

Constructor tInvertedList.Init;

begin
 inherited init(1,1);
 Duplicates := true;
end;

Constructor tInvertedView.Init(var Bounds:tRect;ANumCols:integer; AHScrollBar,AVScrollBar:pScrollBar);

begin
 inherited Init(Bounds,ANumCols,AHScrollBar,AVScrollBar);
 GrowMode := gfGrowAll+gfGrowRel;
end;

Function tInvertedView.GetText(Item,MaxLen:integer):string;

var txt : string;

begin
 if Extended(pInvList^.At(Item)^) < 1e4000 then
 begin
  str(Item+1:3,txt);
  txt := txt + '' + t(pExtended(pInvList^.At(Item))^,22);
  GetText := copy(txt,1,MaxLen);
 end
 else
 begin
  txt := 'New Point...';
  GetText := Copy(txt,1,MaxLen);
 end;
end;

Function tInvertedList.Compare(Key1,Key2:Pointer):integer;

begin
 if pExtended(Key1)^ < pExtended(Key2)^ then
  Compare := -1;
 if pExtended(Key1)^ = pExtended(Key2)^ then
  Compare := 0;
 if pExtended(Key1)^ > pExtended(Key2)^ then
  Compare := 1;
end;

Procedure tInvLine.Draw;

var tDraw : tDrawbuffer;

begin
 MoveStr(tDraw,' nr.                                                                        ',63);
 WriteBuf(0,0,Size.X,1,tDraw);
 MoveStr(tDraw,'Mesured Y Value',63);
 WriteBuf(6+((Size.X div 2-6) - (Length('Mesured Y Value') div 2)),0,
          6+ (Size.X div 2-6) + (Length('Mesured Y Value') div 2),1,tDraw);
end;

Constructor tInverted.Init(var Bounds:tRect);

var R :tRect;
    pScrl : pScrollBar;
    Event : tEvent;
    p     : pInvLine;

begin
 inherited init(Bounds,'Inverted Points');
 Flags := wfMove+wfGrow;
 R.assign(1,1,Size.X-1,2);
 p := new(pInvLine,init(R));
 p^.GrowMode := gfGrowAll+gfGrowRel;
 Insert(p);
 R.assign(Size.X-1,1,Size.X,Size.Y-1);
 pScrl := new(pScrollBar,init(R));
 Insert(pScrl);
 R.assign(1,2,Size.X-1,Size.Y-1);
 pInvView := New(pInvertedView,init(R,1,nil,pScrl));
 pInvList := New(pInvertedList,init);
 pInvView^.pInvList := pInvList;
 Insert(pInvView);
 HelpCtx := hcInvList;
 Message(@Self,evCommand,cmInvAddNew,Nil);
end;

Procedure tInverted.HandleEvent(var Event:tEvent);

Var txt : string;
    error : integer;
    pExtra: pExtended;

 Procedure InvDel;

 var Event2 : tEvent;
     CurPos : integer;

 begin
  CurPos := pInvView^.Focused;
  if MessageBox(^C'Delete Inverted Point?',nil,mfConfirmation+mfYesButton+mfNoButton)
     = cmYes then
  begin
   pInvList^.AtDelete(CurPos);
   pInvView^.SetRange(pInvList^.COunt);
   pInvVIew^.DrawView;
  end;
  Event2.What := evCommand;
  Event2.Command := cmInvAddnew;
  Event2.InfoPtr := nil;
  PutEvent(Event2);
 end;

begin
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  case Event.Command of
   cmInvAddNew : AddNew;
   cmInvDelOld : begin
                  InvDel;
                 end;
  else
   exit;
  end;
  Clearevent(Event);
 end;
 if (Event.What = evBroadCast) and
    (Event.Command in [cmDefault,cmListItemSelected]) and
    (GetState(sfActive)) then
 begin
  if Extended(pInvList^.At(pInvView^.Focused)^) < 1e4000 then
   txt := t(Extended(pInvList^.At(pInvView^.Focused)^),20)
  else
   txt := '';
  if InputBox('Enter Inverted Point','Inverted Point:',txt,40)
   = cmOk then
  begin
   new(pExtra);
   val(txt,pExtra^,error);
   if error <> 0 then
   begin
    MessageBox(^C'Invalid Nummeric Format. Input Ignored.',nil,mfError+mfOkButton);
    exit;
   end;
   pInvList^.Insert(pExtra);
   pInvView^.SetRange(pInvLIst^.count);
   pInvView^.FocusItem(pInvList^.Count-1);
   pInvVIew^.DrawView;
  end;
 end;
end;

Procedure tInverted.AddNew;

var pExtra : pExtended;

begin
 if pInvList^.Count = 0 then
 begin
  new(pExtra);
  pExtra^ := 1e4000;
  pInvList^.Insert(pExtra);
  pInvView^.SetRange(pInvList^.Count);
  pInvView^.DrawView;
  exit;
 end;
 if Extended(pInvList^.At(pInvList^.Count-1)^) < 1e4000 then
 begin
  new(pExtra);
  pExtra^ := 1e4000;
  pInvList^.Insert(pExtra);
 end;
 pInvView^.SetRange(pInvList^.Count);
 pInvView^.DrawView;
end;

Function tInverted.GetNrOfPoints:integer;

begin
 if pExtended(pInvLIst^.At(pInvList^.Count-1))^ < 1e4000 then
  GetNrOfPoints := pInvList^.Count
 else
  GetNrOfPoints := pInvList^.Count-1;
end;

Constructor tMyScroll.Init(var Bounds:tRect);

begin
 Inherited Init(Bounds);
 SetRange(1,20);
end;

Function tResultView.GetText(Item,MaxLen:integer):string;

var txt : string;

begin
 txt := string(List^.At(Item)^);
 GetText := copy(txt,1,MaxLen);
end;

Procedure tResultView.HandleEvent(var Event:tEvent);

begin
 inherited HandleEvent(Event);
 if Event.What = evKeyDown then
 begin
  if Event.KeyCode = kbLeft then
   pScrl^.SetValue(pScrl^.Value-1);
  if Event.KeyCode = kbRight then
   pScrl^.SetValue(pScrl^.Value+1);
 end;
end;

Constructor tGraphSize.Init(Print:boolean);

var R :tRect;
    txt:string;
    aa,bb: real;
    err: integer;

begin
 R.assign(1,1,45,13);
 inherited init(R,'Chromatogram options');
 options := options or ofCentered;
 R.assign(2,1,26,2);
 insert(new(pstatictext,init(r,'Vertical axis...')));

 R.assign(8,2,26,3);
 ylow := new(pinputline,init(r,15));
 str(Ly:12:12,txt);
 txt := copy(txt,1,15);
 ylow^.Setdata(txt);
 insert(ylow);
 R.assign(2,2,7,3);
 insert(new(plabel,init(r,'~L~ow: ',ylow)));

 R.assign(8,3,26,4);
 yHigh := new(pinputline,init(r,15));
 str(Hy:12:12,txt);
 txt := copy(txt,1,15);
 yHigh^.Setdata(txt);
 insert(yHigh);
 R.assign(2,3,8,4);
 insert(new(plabel,init(R,'~H~igh: ',yHigh)));

 R.assign(2,6,26,7);
 insert(new(pstatictext,init(r,'Horizontal axis...')));
 R.assign(8,7,26,8);
 xLow := new(pinputline,init(r,15));
 str(Lx:12:12,txt);
 txt := copy(txt,1,15);
 xLow^.Setdata(txt);
 insert(xLow);
 R.assign(2,7,7,8);
 insert(new(plabel,init(r,'L~o~w: ',xLow)));
 R.assign(8,8,26,9);
 xHigh := new(pinputline,init(r,15));
 str(Hx:12:12,txt);
 txt := copy(txt,1,15);
 xHigh^.Setdata(txt);
 insert(xHigh);
 R.assign(2,8,8,9);
 insert(new(plabel,init(R,'H~i~gh: ',xHigh)));

 if Print then
 begin
  R.assign(26,2,Size.X-2,3);
  insert(new(pbutton,init(R,'~P~rint Plot',cmPrintPlot,bfNormal)));
 end
 else
 begin
  R.assign(26,2,Size.X-2,4);
  insert(new(pbutton,init(R,'~P~lot',cmPlot,bfDefault)));
 end;
 R.assign(26,4,Size.X-2,6);
 insert(new(pbutton,init(R,'C~a~ncel',cmCancel,bfNormal)));
 SelectNext(True);
end;

Procedure tGraphSize.HandleEvent(var Event:Tevent);

begin
 if (Event.What = evBroadCast) then
  if Event.Command = cmDefault then
  begin
   if xLow^.GetState(sfSelected) or
      xHigh^.GetState(sfSelected) or
      xStep^.GetState(sfSelected) or
      yLow^.GetState(sfSelected) or
      yHigh^.GetState(sfSelected) or
      yStep^.GetState(sfSelected) then
   begin
    SelectNext(False);
    ClearEvent(Event);
   end;
  end;
 inherited HandleEvent(Event);
 if Event.What = evCommand then
 begin
  case Event.Command of
   cmCancel: EndModal(cmCancel);
   cmPlot  : EndModal(cmPlot);
   cmPrintPlot:EndModal(cmPrintPlot);
  else
   exit;
  end;
  ClearEvent(Event);
 end;
end;

Procedure tGraphSize.EndModal(Command:word);

var err : integer;
    txt : string;
    error : boolean;

 Procedure NumError(item:string);

 begin
  if err <> 0 then
  begin
   messagebox(^C'Invalid number for'#13 + ^C'"'+item+'".',nil,mfError+mfOkButton);
   error := true;
  end;
 end;

begin
 error := false;

 yHigh^.getdata(txt);
 val(txt,Hy,err);
 NumError('Vertical axis... HIGH');

 yLow^.getdata(txt);
 val(txt,Ly,err);
 NumError('Vertical axis... LOW');

 xHigh^.getdata(txt);
 val(txt,Hx,err);
 NumError('Horizontal axis... HIGH');

 xLow^.getdata(txt);
 val(txt,Lx,err);
 NumError('Horizontal axis... LOW');

 if error then
 begin
  inherited EndModal(cmCancel);
  exit;
 end;

 if (Hx-Lx <= 0) then
 begin
  Messagebox(^C'Invalid X-axis.',nil,mfError+mfOkButton);
  inherited EndModal(cmCancel);
  exit;
 end;

 if (Hy-Ly <= 0) then
 begin
  Messagebox(^C'Invalid Y-axis.',nil,mfError+mfOkButton);
  inherited EndModal(cmCancel);
  exit;
 end;

 inherited EndModal(Command);
end;

end.