/*	mathl.h

	Definitions for the long double version
	of the math floating point package.

	Copyright (c) Borland International 1989
	All Rights Reserved.
*/

/*----------------------------------------------------------------*\
This file is a modification of <math.h>, with declarations for
long double functions as recommended by ANSI X3J11.  All of the
functions below are currently supported.

Error handling is somewhat different from the TC <math.h>
functions, but within the ANSI guidelines.  If <math.h> function
have a domain or range error, _matherr is called, and errno is
set.  The functions in this file do not call any error handlers
or set errno.  When an overflow or underflow occurs, infinities
and zeroes are used appropriately.  If no reasonable value can be
found, NAN (Not-A-Number) is used.

\*----------------------------------------------------------------*/

#if __STDC__
#define _Cdecl
#else
#define _Cdecl	cdecl
#endif

#undef _Cdecl
#define _Cdecl pascal

long double	_Cdecl acosl  (long double x);
long double	_Cdecl asinl  (long double x);
long double	_Cdecl atanl  (long double x);
long double	_Cdecl atan2l (long double y, long double x);
long double	_Cdecl atofl  (const char *s);
long double	_Cdecl ceill  (long double x);
long double	_Cdecl cosl   (long double x);
long double	_Cdecl coshl  (long double x);
long double	_Cdecl expl   (long double x);
long double	_Cdecl fabsl  (long double x);
long double	_Cdecl floorl (long double x);
long double	_Cdecl fmodl  (long double x, long double y);
long double	_Cdecl frexpl (long double x, int *exponent);
long double	_Cdecl ldexpl (long double x, int exponent);
long double	_Cdecl logl   (long double x);
long double	_Cdecl log10l (long double x);
long double	_Cdecl modfl  (long double x, long double *ipart);
long double	_Cdecl powl   (long double x, long double y);
long double	_Cdecl sinl   (long double x);
long double	_Cdecl sinhl  (long double x);
long double	_Cdecl sqrtl  (long double x);
long double	_Cdecl strtodl(const char *s, char **endptr);
long double	_Cdecl tanl   (long double x);
long double	_Cdecl tanhl  (long double x);

#if !__STDC__
long double	_Cdecl hypotl(long double x, long double y);
long double	_Cdecl polyl (long double x, int degree, long double coeffs[]);
long double	_Cdecl pow10l(int p);

struct complexl	    /* as used by "cabsl" function */
{
    long double  x, y;
};

#define cabsl(z)     (hypotl ((z).x, (z).y))

#endif	/* __STDC__ */

#undef _Cdecl
