/* TESTFIT.C sample C dynamic-link library for Nonlinear Fitter */

#include <windows.h>	// this must be removed when using Borland Power Pack
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "fittypes.h"

TDataArray X,Y,Z,R;

int DataInitialized=0;

int far pascal _export INITDATA(char *ParamFile,
		                int *DataPoints,
				int *OutVectors,
				int *AddOutValues,
                                TOutVectorsArr OutVectorsArray,
                                TVectNameArr OutVectorsNames,
				TAddNameArr AddNames,
				TErrMsg ErrMsg)
{ int k; FILE *F;

  if (DataInitialized) return 0;

  *DataPoints=0;
  *OutVectors=4;
  *AddOutValues=1;

  strcpy(AddNames[0],"a+b+c+d");

  OutVectorsArray[0]=&X;
  OutVectorsArray[1]=&Y;
  OutVectorsArray[2]=&Z;
  OutVectorsArray[3]=&R;

  strcpy(OutVectorsNames[0],"X");
  strcpy(OutVectorsNames[1],"Y");
  strcpy(OutVectorsNames[2],"Computed");
  strcpy(OutVectorsNames[3],"Residual");

  if ((F=fopen(ParamFile,"r"))==NULL)
  {
    strcpy(ErrMsg,"Cannot open file");
    return (-1);
  };

  k=0;
  while (! feof(F))
  {
    if (fscanf(F,"%lE %lE \n",&X[k],&Y[k])!=2)
    {
      strcpy(ErrMsg,"Error reading file");
      fclose(F);
      return (-2);
    };
    k++;
  };
  fclose(F);
  *DataPoints=k;
  DataInitialized=1;

  return 0;
};

int far pascal _export APPROX(TParamArr Params,
			      TDataArray Residuals,
			      TAddParArr AddValues,
			      int DataPoints,
                              int TypeOfCall,
                              TErrMsg ErrMsg)
{ int k;

  if (TypeOfCall==2) {
    for (k=0;k<DataPoints;k++) R[k]=Residuals[k];
    return 0;
  }

  for (k=0;k<DataPoints;k++) {
    Z[k]=Params[0]*sin(Params[1]*X[k])+Params[2]*cos(Params[3]*X[k]);
    Residuals[k]=Z[k]-Y[k];
  }

  if (TypeOfCall==3) return 0;

  AddValues[0]=Params[0]+Params[1]+Params[2]+Params[3];
  return 0;
};

// The next function must be removed when using Borland Power Pack

int far pascal LibMain( HINSTANCE hInstance, WORD wDataSegment,
                                   WORD wHeapSize, LPSTR lpszCmdLine )
{ return 1; }

