//-------------------------------------------------------------------//

// Synopsis:	Rotate a matrix by 90 degrees.

// Syntax:	rot90 ( A )
//		rot90 ( A , K )

// Description:

//	If K is omitted, then A (M x N) is rotated by 90
//	degrees. Otherwise, A is rotated by K*90 degrees. K can take
//	on positive or negative values. 

//	rot90 is useful with plmesh() and plot3d(). Using rot90, the
//	user can rotate the surface by 90 degrees in either direction.

//-------------------------------------------------------------------//

rot90 = function ( A , k )
{
  local (k, B, m, n)

  m = A.nr; n = A.nc;
  if (!exist (k)) 
  {
    k = 1; 		// default
  else
    k = mod(k,4);	// take out 360 deg. rotations
    if (k < 0)
    {
      k = k + 4;	// Force positve
    }
  }

  if (k == 1)
  {
    B = A'[n:1:-1;];		// 90
  else if (k == 2) {
    B = A[m:1:-1;n:1:-1];	// 180
  else if (k == 3) {
    B = (A[m:1:-1;])';		// 270
  else
    B = A;			// 360
  }}}

  return B;
};
