		TITLE		LIM--Lotus Intel Microsoft routines

	if1
		include	prolog.mac
		endif

pgroup		group		prog
dgroup		group		data
		assume		cs:pgroup, ds:dgroup, es:dgroup

prog		segment		byte public 'PROG'

		public		emmchk
;
;	int emmchk()
;
;	return nonzero if emm system is present.
;
emmchk		proc		near
		prolog
		xor		ax,ax		; return(0) if no emm there
		call		emm_chk
		jnc		ret1		; there - return(1) 

emcr:		epilog
		ret

ret1:		mov		ax,1
		jmp		emcr
emmchk		endp

;
;  Taken from Page 5-4 of the Enhanced Memory Specification manual, AST
;
;  GET INTERUPT VECTOR TECHNIQUE
;
;  Function:   Used to determine if the EMM is present in the system.
;	       Carry flag is set upon return if no EMM system present.
;
;  No registers destroyed;
;
emm_chk		proc   		near

       		push		ax
       		push		es
       		push		ds

       		push		cs
       		pop		ds

       		mov		ax,3567h  	; "DOS: Get Vector, 67H please"
       		int		21h
       		mov		di,device_name
       	       	lea		si,emm_signature
       	       	mov		cx,8
       	       	cld
	       	repe		cmpsb
       	       	jne   		emm_err2
       	       	clc

retcfe:	       	pop		ds
       	       	pop		es
       	       	pop		ax
       	       	ret

emm_err2:      	stc
       	       	jmp		retcfe

device_header		struc
next_device_ptr		dd	0
attribute		dw 	0
strategy_ptr		dw	0
interrupt_ptr		dw	0
device_name   		db	0
device_header  		ends

emm_signature: 	db	'EMMXXXX0'

emm_chk	       	endp

prog	       	ends	

data		segment		word public 'DATA'
data		ends

	       	end
