#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef MSC
#include <direct.h>
#endif
#ifdef MSC4
#include <direct.h>
#endif
#ifdef TC
#include <dir.h>
#endif
#ifdef TCPP
#include <dir.h>
#endif
#ifdef LATTICE
#include <errno.h>
#endif
#include "xspawn.h"

void main()
{
    char *env;
    char cwd[ 67 ];                    /* current working directory */

    /*
     *  If the user has a "TMP" environment variable, it very possibly is set
     *  to the drive name of a ramdrive.  Construct an example _swappath.
     *  Since _useems is 0 by default, _swappath may not be used.
     */
    if (( env = getenv( "TMP" )) != NULL && getcwd( cwd, 66 ) != NULL &&
        ( _swappath = ( char * )malloc( strlen( env ) + strlen( cwd ) + 2 )) !=
        NULL )
    {
        strcpy( _swappath, env );      /* try this path first */
        strcat( _swappath, ";" );
        strcat( _swappath, cwd );      /* try this path last */
    }

    _swap = 1;                         /* turn swap off */

    printf( "\nxspawnlp mm.com without swap\n" );
    if ( xspawnlp( P_WAIT, "mm.com", "mm.com", NULL ) == -1 )
    {
        printf( "xspawnlp failed, errno = %d", errno );
        exit( 1 );
    }

    _swap = 0;                         /* turn swap on */

    printf( "\nxspawnlp mm.com with swap\n" );
    if ( xspawnlp( P_WAIT, "mm.com", "mm.com", NULL ) == -1 )
    {
        printf( "xspawnlp failed, errno = %d", errno );
        exit( 1 );
    }

    exit( 0 );
}
