;
; (C) Copyright 1990 Whitney Software, Inc.
;            All Rights Reserved
;
; Source for MM.COM.  Displays the largest executable program size.  If
; expanded memory is available, displays the total amount and the free amount.
;

_TEXT           SEGMENT word public 'CODE'

                ORG     100h

                ASSUME  cs:_TEXT
                ASSUME  ds:_TEXT
                ASSUME  es:_TEXT
                ASSUME  ss:_TEXT

; calculate largest executable program size

begin:          mov     ax,cs:[2]               ; end of allocation block
                mov     bx,cs
                sub     ax,bx                   ; subtract PSP segment
                mov     bx,16                   ; convert to bytes
                call    printi                  ; print integer
                mov     cx,msg1len              ; length
                mov     dx,offset msg1          ; message 1
                call    printm                  ; print message

; determine whether expanded memory is available

                call    chkems                  ; check expanded memory
                or      ah,ah
                jnz     exit                    ; jump if no expanded memory
                mov     ah,42h                  ; get number of pages
                int     67h
                or      ah,ah
                jnz     exit                    ; jump if unsuccessful
                push    bx                      ; save unallocated pages

; print total bytes EMS memory

                mov     ax,dx                   ; total pages
                mov     bx,16384                ; convert to bytes
                call    printi                  ; print integer
                mov     cx,msg2len              ; length
                mov     dx,offset msg2          ; message 2
                call    printm                  ; print message

; print free bytes EMS memory

                pop     ax                      ; unallocated pages
                mov     bx,16384                ; convert to bytes
                call    printi                  ; print integer
                mov     cx,msg3len              ; length
                mov     dx,offset msg3          ; message 3
                call    printm                  ; print message

exit:           mov     ax,4C00h                ; terminate with 0 return code
                int     21h

printm          PROC    near

; Call with:    CX = message length
;               DX = message

                mov     ah,40h                  ; write file or device
                mov     bx,1                    ; standard output device handle
                int     21h
                ret

printm          ENDP

printi          PROC    near

; Call with:    AX = multiplicand
;               BX = multiplier

                mul     bx

; print integer (DX:AX)

                mov     cx,10                   ; radix equals 10
                mov     si,offset buffer + 11   ; end of buffer
                push    si

printi1:        push    ax                      ; divide integer by 10
                mov     ax,dx
                xor     dx,dx
                div     cx
                mov     bx,ax
                pop     ax
                div     cx
                xchg    bx,dx                   ; DX:AX = quotient
                                                ; BL = remainder
                add     bl,'0'                  ; convert remainder to ASCII
                dec     si                      ; back up through buffer
                mov     [si],bl                 ; store character in buffer
                mov     bx,ax                   ; is integer 0 yet?
                or      bx,dx
                jnz     printi1

                pop     cx                      ; end of buffer
                sub     cx,si                   ; calculate string length
                mov     dx,si                   ; beginning of string
                call    printm                  ; print string
                ret

printi          ENDP

chkems          PROC    near

; determine whether expanded memory is available

                mov     dx,offset device        ; EMM device driver name
                mov     ax,3D00h                ; open file read only
                int     21h
                jc      check2                  ; expanded memory unavailable

; determine whether we opened the EMM device driver or a file

                mov     bx,ax                   ; handle
                mov     ax,4400h                ; IOCTL - get device info
                int     21h
                jc      check1                  ; expanded memory unavailable
                test    dx,80h                  ; test bit 7
                jz      check1                  ; expanded memory unavailable

                mov     ax,4407h                ; IOCTL - get output status
                int     21h
                jc      check1                  ; expanded memory unavailable
                or      al,al
                jz      check1                  ; expanded memory unavailable

; close EMM device driver to reclaim handle

                mov     ah,3Eh                  ; close file
                int     21h

; determine whether the EMM is functional

                mov     ah,40h                  ; get manager status
                int     67h
                or      ah,ah
                jnz     check2                  ; expanded memory unavailable
                ret

; close EMM device driver or file to reclaim handle

check1:         mov     ah,3Eh                  ; close file
                int     21h

check2:         mov     ah,1                    ; expanded memory unavailable
                ret

chkems          ENDP

buffer          db      11 dup (?)

device          db      'EMMXXXX0',0            ; EMM device driver name

msg1            db      ' largest executable program size',0Dh,0Ah,0Dh,0Ah
msg1len         EQU     $-msg1

msg2            db      ' bytes total EMS memory',0Dh,0Ah
msg2len         EQU     $-msg2

msg3            db      ' bytes free EMS memory',0Dh,0Ah
msg3len         EQU     $-msg3

_TEXT           ENDS

                END     begin
