;
; (C) Copyright 1990 Whitney Software, Inc.
;            All Rights Reserved
;
; Source for MP.COM.  Displays a list of the interrupt vectors that point to
; interrupt handlers in the parent process.
;

arena           struc                           ; arena header
sig             db      0                       ; 'M' or 'Z' if last block
own             dw      0                       ; PSP of owner or 0 if free
siz             dw      0                       ; size not including header
arena           ends

_TEXT           SEGMENT word public 'CODE'

                ORG     100h

                ASSUME  cs:_TEXT
                ASSUME  ds:_TEXT
                ASSUME  es:_TEXT
                ASSUME  ss:_TEXT

begin:          mov     cx,36                   ; length
                mov     dx,offset msg1          ; message 1
                call    printm                  ; print message
                mov     di,ds:[16h]             ; parent's PSP segment
                dec     di
                mov     es,di                   ; parent's arena header
                inc     di                      ; parent's PSP segment
                mov     dx,di
                add     dx,es:[siz]             ; next block
                xor     cx,cx                   ; interrupt number

; top of loop for each interrupt (0-FF)

display1:       mov     ah,35h                  ; get interrupt vector
                mov     al,cl                   ; interrupt number
                int     21h
                mov     ax,es                   ; vector segment
                push    cx                      ; interrupt number
                mov     cl,4                    ; shift count
                shr     bx,cl                   ; divide vector offset by 16
                pop     cx                      ; interrupt number
                add     ax,bx                   ; AX = segment + offset / 16
                cmp     ax,di                   ; vector < parent's PSP?
                jb      display2                ; yes, jump
                cmp     ax,dx                   ; vector >= next block?
                jae     display2                ; yes, jump
                push    cx                      ; interrupt number
                push    dx                      ; next block
                mov     ax,cx                   ; integer = interrupt number
                call    printi                  ; print integer
                pop     dx                      ; next block
                pop     cx                      ; interrupt number

display2:       inc     cx                      ; next interrupt
                or      ch,ch                   ; is interrupt number <= 255?
                jz      display1                ; yes, jump
                mov     cx,2                    ; length
                mov     dx,offset msg2          ; message 2 (CR/LF)
                call    printm                  ; print message
                mov     ax,4C00h                ; terminate with 0 return code
                int     21h

printm          PROC    near

; Call with:    CX = message length
;               DX = message

                mov     ah,40h                  ; write file or device
                mov     bx,1                    ; standard output device handle
                int     21h
                ret

printm          ENDP

printi          PROC    near

; Call with:    AX = integer

                mov     cl,16                   ; radix equals 16
                mov     si,offset buffer + 2    ; end of buffer
                push    si

printi1:        div     cl                      ; divide integer by 16
                add     ah,'0'                  ; convert remainder to ASCII
                cmp     ah,'9'                  ; is it 0-9?
                jle     printi2                 ; yes, jump
                add     ah,'A'-'9'-1            ; it is A-F, correct

printi2:        dec     si                      ; back up through buffer
                mov     [si],ah                 ; store character in buffer
                xor     ah,ah
                or      al,al                   ; is integer 0 yet?
                jnz     printi1                 ; no, get next character

                pop     cx                      ; end of buffer
                sub     cx,si                   ; calculate string length
                inc     cx                      ; trailing space
                mov     dx,si                   ; beginning of string
                call    printm                  ; print string
                ret

printi          ENDP

buffer          db      2 dup (?),' '

msg1            db      'list of parent''s interrupt vectors'

msg2            db      0Dh,0Ah                 ; also part of message 1

_TEXT           ENDS

                END     begin
