# Microsoft 6.0a Makefile for rtt modules

CFLAGS= -AL -c -Oiltn -Gm -Lp -G2 -Gt -Aw -DRttx -DRTT -DTokDotH
CC=cl
LDFLAGS = /Fm /Lp /G2 /AL /Fertt /F 7FFF 

RTT_OBJ = rttparse.obj rttmain.obj rttlex.obj rttsym.obj rttnode.obj \
	  rttout.obj rttmisc.obj rttdb.obj rttinlin.obj rttilc.obj

PP_DIR = ../preproc/
P_DOT_H = $(PP_DIR)preproc.h $(PP_DIR)pproto.h ltoken.h ..\h\cproto.h\
	..\h\define.h ..\h\config.h ..\h\typedefs.h ..\h\proto.h\
	..\h\cstructs.h ..\h\cpuconf.h
P_OBJ = p_out.obj pchars.obj  p_err.obj pmem.obj  bldtok.obj macro.obj \
	preproc.obj evaluate.obj files.obj gettok.obj p_init.obj

COMMON = ..\common\getopt.obj ..\common\time.obj ..\common\filepart.obj\
	  ..\common\memory.obj ..\common\identify.obj ..\common\strtbl.obj\
	  ..\common\rtdb.obj ..\common\clocal.obj ..\common\alloc.obj \
	  ..\common\literals.obj ..\common\long.obj

OBJ = $(RTT_OBJ) $(P_OBJ) $(COMMON)

rtt:	$(OBJ)
	cl $(LDFLAGS) *.obj $(COMMON) rtt.def -link /NOE 
	copy rtt.exe ..\..\bin

$(RTT_OBJ): rtt.h rtt1.h rttproto.h $(P_DOT_H)

rttdb.obj: ../h/version.h 

p_out.obj: $(PP_DIR)p_out.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)p_out.c

pchars.obj: $(PP_DIR)pchars.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)pchars.c

p_err.obj: $(PP_DIR)p_err.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)p_err.c

pmem.obj: $(PP_DIR)pmem.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)pmem.c

bldtok.obj: $(PP_DIR)bldtok.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)bldtok.c

macro.obj: $(PP_DIR)macro.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)macro.c

preproc.obj: $(PP_DIR)preproc.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)preproc.c

evaluate.obj: $(PP_DIR)evaluate.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)evaluate.c

files.obj: $(PP_DIR)files.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)files.c

gettok.obj: $(PP_DIR)gettok.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)gettok.c

p_init.obj: $(PP_DIR)p_init.c $(P_DOT_H)
	$(CC) $(CFLAGS) $(PP_DIR)p_init.c
