/*
 *  util.c -- general utility functions.
 */

#include <ctype.h>
#include "../h/gsupport.h"
#include "tproto.h"
#include "globals.h"
#include "trans.h"
#include "tree.h"

#ifdef Xver
xver(util.1)
#endif					/* Xver */

extern int optindex;

#ifndef Xver
extern char *ofile;
#endif					/* Xver */


/*
 * Information about Icon functions.
 */

/*
 * Number of arguments.
 */

#ifdef Xver
xver(util.2)
#endif					/* Xver */

/*
 * Names of Icon functions.
 */
char *ftable[] = {
#define FncDef(p,n) Lit(p),
#define FncDefV(p) Lit(p),
#include "../h/fdefs.h"
#undef FncDef
#undef FncDefV
   };

int ftbsize = sizeof(ftable)/sizeof(char *);

/*
 * tcalloc - allocate and zero m*n bytes
 */
pointer tcalloc(m,n)
unsigned int m, n;
   {
   pointer a;

   if (!(a = calloc(m,n)))
      quit("out of memory");
   return a;
   }

/*
 * trealloc - realloc a table making it half again larger and zero the
 *   new part of the table.
 */
pointer trealloc(table, tblfree, size, unit_size, min_units, tbl_name)
pointer table;      /* table to be realloc()ed */
pointer tblfree;    /* reference to table free pointer if there is one */
unsigned int *size; /* size of table */
int unit_size;      /* number of bytes in a unit of the table */
int min_units;      /* the minimum number of units that must be allocated. */
char *tbl_name;     /* name of the table */
   {
   word new_size;
   word num_bytes;
   word free_offset;
   word i;
   char *new_tbl;

   new_size = (*size * 3) / 2;
   if (new_size - *size < min_units)
      new_size = *size + min_units;
   num_bytes = new_size * unit_size;

#if IntBits == 16
    {
    word max_bytes = 64000;

    if (num_bytes > max_bytes) {
       new_size = max_bytes / unit_size;
       num_bytes = new_size * unit_size;
       if (new_size - *size < min_units)
          quitf("out of memory for %s", tbl_name);
       }
    }
#endif					/* IntBits == 16 */

   if (tblfree != NULL)
      free_offset = DiffPtrs(*(char **)tblfree,  (char *)table);

   if (!(new_tbl = (char *)realloc(table, (unsigned)num_bytes)))
      quitf("out of memory for %s", tbl_name);

   for (i = *size * unit_size; i < num_bytes; ++i)
      new_tbl[i] = 0;

   *size = new_size;
   if (tblfree != NULL)
      *(char **)tblfree = (char *)(new_tbl + free_offset);

   return (pointer)new_tbl;
   }

/*
 * quit - immediate exit with error message
 */

novalue quit(msg)
char *msg;
   {
   quitf(msg,"");
   }

/*
 * quitf - immediate exit with message format and argument
 */
novalue quitf(msg,arg)
char *msg, *arg;
   {

#ifdef Xver
xver(util.3)
#endif					/* Xver */

#ifndef Xver
   extern char *progname;
   fprintf(stderr,"%s: ",progname);
   fprintf(stderr,msg,arg);
   fprintf(stderr,"\n");
#endif					/* Xver */

#ifndef VarTran
#ifndef Xver
   if (ofile)
      unlink(ofile);			/* remove bad icode file */
#endif					/* Xver */
#endif					/* VarTran */

   exit(ErrorExit);
   }

/*
 * tsyserr is called for fatal errors.  The message s is produced and the
 *  translator exits.
 */
novalue tsyserr(s)
char *s;
   {

#ifdef Xver
xver(util.4)
#endif					/* Xver */

#ifndef Xver
   if (tok_loc.n_file)
      fprintf(stderr, "File %s; ", tok_loc.n_file);
   fprintf(stderr, "Line %d # %s\n", in_line, s);
#endif					/* Xver */

   exit(ErrorExit);
   }


/*
 * round2 - round an integer up to the next power of 2.
 */
unsigned int round2(n)
unsigned int n;
   {
   unsigned int b = 1;
   while (b < n)
      b <<= 1;
   return b;
   }

#ifdef Xver
xver(util.5)
#endif					/* Xver */

