	include model.inc

	include farnear.inc			; define far or near call sequence
	include smalhuge.inc			; define far or near data access

; Our program will read the mouse data by referring to addresses relative
; to the procedure MouseData(). This must be declared as:
;
;		void far MouseData();
;
; After this, execute this code
;
; MOUSTRAP far *data
; data = (MOUSETRAP far *)MouseData;
;
; And now refs like data->what, data->buttons will work.
;

	PUBLIC	_MouseData

; the data structure

DGROUP	group		_DATA

_DATA		segment  word public 'DATA'
_MouseData	LABEL	FAR		; creates a fake procedure

What			DW		0
Buttons		DW		0
X_pos			DW		0
Y_pos			DW		0
X_mickeys	DW		0
Y_mickeys	DW		0

_DATA		ends

_TEXT	segment  word public 'CODE'

		assume	cs:_TEXT,ds:DGROUP

; the interrupt handler

	PUBLIC	_handler
_handler		PROC	FAR
	cli
	push	ds
	push	ax
	mov	ax,DGROUP
	mov	ds,ax
	pop	ax
	mov	What,ax
	mov	Buttons,bx
	mov	X_pos,cx
	mov	Y_pos,dx
	mov	X_mickeys,di
	mov	Y_mickeys,si
	pop	ds
	sti
	ret

_handler	ENDP
_TEXT		ends

	END
