// Block code file (BLOCK.CPP)
//
// Written 1996, 1997 by Roland Acton - public domain.
//
// This file is part of the Game Music System 1.1 distribution.

#define COMPILING_BLOCK

#include "globals.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "block.h"
#include "song.h"
#ifdef EDITOR_HOOKS
  #include "specgad2.h"
  #include "statbar.h"
#endif



block::block(unsigned int lines) {
  unsigned int counter;

  highest_line = lines - 1;
  for (counter = 0;counter < MAX_TRACKS;counter++)
    if (counter <= song::highest_track)
      track_pointer[counter] = make_blank_track(lines);
    else
      track_pointer[counter] = 0;
}



block::~block() {
  unsigned int counter, stepper, trackstep;
  unsigned int track_used_elsewhere;

  for (trackstep = 0;trackstep <= song::highest_track;trackstep++)
    if (track_pointer[trackstep]) {
      track_used_elsewhere = NO;
      for (stepper = 0;stepper <= song::highest_block;stepper++)
        if (song::block_pointer[stepper] != this)
          for (counter = 0;counter <= song::highest_track;counter++)
            if (song::block_pointer[stepper]->track_pointer[counter]
              == track_pointer[trackstep])
              track_used_elsewhere = YES;
      if (!track_used_elsewhere)
        free(track_pointer[trackstep]);
    }
}



/* Creates an empty track with the specified number of lines and effect
   slots per line. */
unsigned char *block::make_blank_track(unsigned int lines,
    unsigned int num_effects) {
  unsigned char *new_track;
  unsigned char *track_init;
  unsigned int stepper;
  unsigned int counter;

  if (num_effects == 0)
#ifdef EDITOR_HOOKS
    num_effects = max_effects_obj.num_effects;
#else
    num_effects = 1;
#endif
  new_track = (unsigned char *) malloc((2 + (num_effects * 2)) * lines);
#ifdef EDITOR_HOOKS
  if (!new_track) {
    status_bar_obj.message_output("EMERGENCY: Out of memory during track alloc, -PROGRAM HALTED-");
// Can't just quit out since the interrupt routine is still going.
    while (1);
  }
#else
  assert(new_track);
#endif
  track_init = new_track;
  for (stepper = 0;stepper < lines;stepper++) {
    *(track_init++) = 128;
    *(track_init++) = 128;
    for (counter = 1;counter < num_effects;counter++) {
      *(track_init++) = 128;
      *(track_init++) = 0;
    }
    *(track_init++) = 0;
    *(track_init++) = 0;
  }
  return new_track;
}



/* Replaces one of the block's tracks with a new track, and returns the old
   one. The new track needs to be as long as the rest of the block (or
   zero). */
unsigned char *block::swap_track(unsigned char *new_track,
    unsigned int old_track_number) {
  unsigned char *old_track;

  old_track = track_pointer[old_track_number];
  track_pointer[old_track_number] = new_track;
  return old_track;
}
