program playply;

{$L ppoly_s}

{uses polyfunc;}

const
		  DEFTEMP = 1024;
		  FILENAMEEXT = '.ply';

var
	tempval, badchar : integer;
	infile : file;

procedure poly(s,o:word); external;

procedure playpoly(filename:string; defaulttempo:word);
var
	tune : pointer;
	fsize : longint;
	p : ^word;
	infilename : string;

begin
	infilename := filename;
	if pos('.', filename) = 0 then
		infilename := infilename+FILENAMEEXT;
	assign(infile, infilename);
	reset(infile,1);
	fsize := filesize(infile);
	getmem( p, word(fsize)+1 );
	p^ := defaulttempo;
	tune := p;
	p := ptr(seg(p^),ofs(p^)+2);
	blockread(infile,p^,word(fsize));
	close(infile);
	poly(seg(tune^),ofs(tune^));
	freemem(tune,word(fsize));
end;


procedure message;
begin
	writeln('Usage: PlayPoly <plyfile> [tval]');
	writeln;
	writeln('where:');
	writeln('   <plyfile> = the name of the file to play.');
	writeln('   [tval]    = [optional] starting tempo value, 1 (fast) - 65535 (slow)');
	writeln;
	writeln('PlayPoly.EXE and its original source code is Copyright (c) 1989 - ');
	writeln('GrigaSoft Productions. PlayPoly may not be included in any commercial');
	writeln('software package without explicit written permission from the author.');
	writeln('This package is an unregistered evaluation copy for demo use only.');
	writeln('Register your copy today!');
end;

begin
	if paramcount > 0 then begin
		if paramcount > 1 then begin
			val(paramstr(2),tempval,badchar);
			if badchar = 0 then
				playpoly( paramstr(1), tempval )
			else begin
				message;
				halt(2);
			end;
		end else
			playpoly(paramstr(1),DEFTEMP);
	end else begin
		message;
		halt(1);
	end;
end.
