/************************* APPL1 ****************************/
#include "include.h"             /* @0224 */
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <state1.h>
#define RESRU 19
#define RESRH 16
extern struct segprf *preqseg(int n);
extern struct rqb *preqrq(int n);
extern unsigned long findnau(void *np,void **naupp);
extern void pattach(int n,char far *pdata,int len);
extern void prelseg(struct segprf *wseg);

struct hscb *crhscb( char *mylu, char *partlu);
struct hscb *findhscb( unsigned long ccor );
struct rqb *memget( struct rqb *wrqb);
struct rqb *rqopndst( struct rqb *wrqb);
struct rqb *send( struct rqb *wrqb);
struct rqb *rqclsdst( struct rqb *wrqb);
struct rqb *exname( struct rqb *wrqb);


     struct rqb *appl1(wrqbg)
     struct rqb *wrqbg;
     {
        char parm;
        struct rqb *memget();
        parm=wrqbg->th.ra.rparm.parm.parm1;
        switch (parm) {
	    case 0: return(rqopndst(wrqbg));
	    case 1: return(send(wrqbg));
	    case 3: return(rqclsdst (wrqbg));
            case 5: return(memget(wrqbg)); /* only for DOS */
            case 6: return(exname(wrqbg));
            default:
	     return (NULL);
                      }

 }/**************** end of appl1 *********************************/
/********************** EXNAME ***********************************/
struct rqb *exname(wrqb)
      struct rqb *wrqb;
       {
        struct nau *wnau;
        unsigned long rc;

              rc=findnau(&(wrqb->th.ra.wa.area[0]),&wnau);
              if (rc == 0){
                     pattach(0,NULL,0);
                     return(wrqb);
              }
              return (NULL);
       }
 /****************************************************************/
 /********************* MEMGET ***********************************/
 struct rqb *memget(wrqb)
      struct rqb *wrqb;
       {
         struct segprf *wseg;
         struct rqb *wrqbn;
             if (wrqb->th.ra.wa.rqba.rsrlen == 0)
                     wrqb->th.ra.wa.rqba.area1=preqrq(1);
              else
                    {wseg=preqseg(wrqb->th.ra.wa.rqba.rsrlen);
                     if (wseg==NULL) {
                        wrqb->th.ra.wa.rqba.area1=NULL;
		     }
                      else
			{ wrqbn=(char *)wseg+12;         /* 5001 */
                          wrqb->th.ra.wa.rqba.area1=wrqbn;
                        }
                     }
         wrqb->th.ra.code|=FROM;
         return(wrqb);
       }
 /***************** end of memget ********************************/
 /******************** OPNDST ************************************/
 struct rqb *rqopndst (wrqbg)
 struct rqb *wrqbg;
{
    struct nib *wnib;
    unsigned long rc;
    struct nau *wnau;
    struct segprf *wseg, *wsegb;
    struct rqb *wrqbb,*wrqbq;
    struct bind *wbind;
    struct rh *wrhb;
    struct th *wthb;
    struct hscb *whscb;
    union ru *wru;
    short i;
    char *p, *t_wnib;
     char bindhdr[3];


     bindhdr[0]=0x6B;
     bindhdr[1]=0x80;
     bindhdr[2]=0x01;

    wru=(char*)wrqbg+RESRU;
    if ((t_wnib=preqseg(sizeof(struct nib)-16)) == NULL) /* 5001 */

      {
	 return 0;
      }
    wnib=t_wnib+12;                        /* 5001 */
    memcpy(wnib,wru,sizeof(struct nib));   /* 5001 */
    rc=findnau(wnib->mode,&wnau);
    if (rc!=NULL)
                return (NULL);
     whscb=crhscb( wnib->mode,wnib->sym);
     whscb->cor = whscb;
     wsegb=preqseg(sizeof(struct bind)+3);     /*1350*/ /*5002*/
     if (wsegb==NULL) {
          return 0;}
     wrqbb=(struct rqb *)((char*)wsegb+12);
     wrhb=(char*)wrqbb+RESRH;
     for (i=0;i<3;i++)
       wrhb->rh[i]=bindhdr[i];
     wbind=(char*)wrqbb+RESRU;
     wbind->cmd=0x31;
     wbind->bim.old.type=0x01;
     wbind->crypt=0;
     wbind->plulen=0x10;
     wbind->slulen=0x10;
       memcpy (wbind->plu,wnib->mode,8);       /* 1075 */
       memcpy (wbind->slu,wnib->sym,8);       /* 1075 */
       wbind->urclen=0x00;
       wbind->usrlen=0x00;
    memcpy (&(wrqbg->th.ra.wa.hh.rswa),&(wnib->user),4);
    memcpy(&(wrqbg->th.ra.wa.area[0]),&(wnau->sid),2); /* @2005 */

    if(wnau->opnq==NULL)   /*place OPNDST RQB in queue*/
           {wnau->opnq=wrqbg;
            goto PATT;
           }
    wrqbq=wnau->opnq;
    while(wrqbq->link!=NULL)
            wrqbq=wrqbq->link;
    wrqbq->link=wrqbg;
    PATT:
    p = wnib;
    memset(p + 8, 0, 8);
    prelseg(t_wnib);
     wrqbb->th.ra.wa.hh.hscb=whscb;
     wrqbb->th.ra.rparm.parm.parm1=0x08;
     wthb=&(wrqbb->th.th);
    memcpy(&(wthb->t912.old.snf),&(wnau->sid),2); /* @2005 */
    wnau->sid++;
     wthb->t912.old.dcf=(sizeof(struct bind)+3);     /*@2003 */
     wthb->t13.lan.fid=FID8+EFI;         /* @0172 */
     wthb->t13.lan.fid |= 0x0c;          /* 1068 */
     wrhb=(char*)wrqbb+RESRH;
     wrhb->rh[2]|=0x01;
     wrqbb->th.ra.stcb=SESSA_CODE;
     wrqbb->th.ra.code=0x02;
     wrqbb->th.ra.code|=FROM;
     wsegb->len = wthb -> t912.old.dcf;
     pattach(1,wrqbb,wthb->t912.old.dcf);
     return (wrqbg);
    BADRSP:
         /*building response RQB for LU62*/
         wrqbg->th.ra.stcb=wrqbg->th.ra.wa.rqba.rsrlen+ST_N;
	 memcpy (&(wrqbg->th.ra.wa.hh.rswa),&(wnib->user),4);
         wrqbg->th.ra.rparm.parm.parm1=5;
         wrqbg->th.ra.rparm.parm.parm2=0xff;
         wrqbg->th.ra.code=0xca;
         return (NULL);
  } /**********************end of opndst ****************************/
  /*********************** SEND **************************************/
  struct rqb *send (wrqbg)
  struct rqb*wrqbg;
 {
    struct segprf *wseg;
    struct rh *wrh;
    struct th *wth;
    wseg=(struct segprf *)((char*)wrqbg-12);
    wrqbg->th.ra.rparm.parm.parm1=0;       /*@2001 */
    wrh=(char*)wrqbg+RESRH;
    wth=&(wrqbg->th.th);           /* @2005 */
    wth->t912.old.dcf=wseg->len;          /* @2005 */

    wseg->un.th[0]=0x8c;
    wrqbg->th.ra.stcb=DFC_CODE;
    wrqbg->th.ra.code=0x02;
    wrqbg->th.ra.code |= FROM;
    pattach(1,wrqbg,wseg->len);
       return (wrqbg);
    } /************************** end of send ************************/
    /******************** CLSDST *************************/
    struct rqb *rqclsdst(wrqbg)
    struct rqb *wrqbg;
    {
        struct segprf *wseg;
        struct rqb *wrqb;
        short i;
	char unbndhdr[3];
        struct rh *wrh;
        struct th *wth;
        struct hscb *whscb;
        struct unbind *wun;

        unbndhdr[0]=0x6b;
	unbndhdr[1]=0x80;
	unbndhdr[2]=0x01;
           whscb=findhscb(wrqbg->th.ra.wa.hh.hscb);
           wseg=preqseg(25); /*segment request for unbind */
           if (wseg==NULL)
		{
                  return (NULL);
                }
           wrqb=(struct rqb *)((char*)wseg+12);
           wrh=(char*)wrqb+RESRH;
           for (i=0;i<3;i++)
                wrh->rh[i]=unbndhdr[i];
           wun=(char*)wrqb+RESRU;
           wun->cmd=0x32;
           wun->type=0x01;
           wrqb->th.ra.wa.hh.hscb=whscb->cor;
           wth=&(wrqb->th.th);
           wth->t13.lan.fid=0x8d;
           wth->t912.old.dcf=(sizeof(struct unbind)+3);  /* @2005 */
           wrqb->th.ra.stcb=SESSA_CODE;
           wrqb->th.ra.code=0x02;
           wrqb->th.ra.code |= FROM;
           pattach(1,wrqb,wth->t912.old.dcf);
              return ( wrqbg);
   }/************************* end of clsdst ************************/
  /******************* THE END ******************************************/
