/*
  Free the MCBs

  Function: This procedure frees all the MCBs which are belong to
            LU module.

  CopyRight 1995. Nicholas Poljakov all rights reserved.

 */

#include <dos.h>

extern unsigned ProgPrefix;

freeMCB()
{
	unsigned int seg_mcb;
        struct mcb {
                unsigned char type;
                unsigned int  Owner;
                unsigned int  size;
        } *p_mcb;

        _asm {
                mov  ax, 5200h
                int  21h
                mov  ax, word ptr es:[bx - 2]
		mov  word ptr seg_mcb[0], ax
        }

	FP_SEG( p_mcb ) = seg_mcb;
        FP_OFF( p_mcb ) = 0;

        while (p_mcb -> type == 0x4d) { /* middle MCB */
            if (p_mcb -> Owner == ProgPrefix) {
		  _dos_freemem( seg_mcb + 1 );
            }
	    seg_mcb += p_mcb -> size;
	    seg_mcb++;
	    FP_SEG( p_mcb ) = seg_mcb;
	    FP_OFF( p_mcb ) = 0;
        }
}
