;*********************************************************
;*                                                       *
;*                Int6f                                  *
;*                                                       *
;*  Function   : Setup user handler for 6fh interrupt.   *
;*  Input      : None.                                   *
;*  Output     : None.                                   *
;*                                                       *
;*  Last modifycation : 12/02/92 10:58pm.                *
;*                                                       *
;* CopyRight 1995. Nicholas Poljakov all rights reserved.*
;*                                                       *
;*********************************************************
.MODEL TINY
.DOSSEG

include c:\m61\include\dos.inc
include c:\m61\include\macros.inc

EXTRN  int6f:PROC

PUBLIC zproc, OldInt6f, OffInt6f, SegInt6f, MyPSP

.CODE
zproc     PROC
          jmp  SetStart

OldInt6f  dd   ?
          org  OldInt6f
OffInt6f  dw   ?
SegInt6f  dw   ?
MyPSP     dw   0
Dcl       db   'Interface miniPORT/IPX now is active.', 10,13,'$'

SetStart:
          push es
          mov  ax, 10h
          mov  es, ax
          les  bx, DWORD PTR es:[0bch]
          mov  ax, es
          pop  es
          and  ax, bx
          jz   SetHandler

          mov  ah, 33h
          int  6fh
          cmp  ax, 5555h
          jne  SetHandler

          @Exit
SetHandler:
          push es
          cli
;*
;*  Save Old Int6fh vector
;*
          mov  ax, 10h
          mov  es, ax
          mov  ax, WORD PTR es:[0bch]  ; Old INT6f, offset
          mov  OffInt6f, ax
          mov  ax, WORD PTR es:[0beh]  ; Old INT6f, segment
          mov  SegInt6f, ax
;*
;*  Set New Int6f value
;*
          mov  ax, offset int6f
          mov  WORD PTR es:[0bch], ax  ; INT6f, offset
          mov  ax, cs
          mov  WORD PTR es:[0beh], ax  ; INT6f, segment

          sti
          pop  es

          mov  ax, es
          mov  MyPSP, ax     ; set MyPSP value == ES

          push es
          mov  ax, word ptr es:[2ch]
          mov  es, ax
          mov  ax, 4900h
          int  21h           ; Free DOS environment
          pop  es

	  @ShowStr Dcl
          mov  dx, offset SetStart + 1
          int  27h

zproc     ENDP
          END
