;;****************************************************************************
;;                      declare.inc         declare.inc
;;****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; Due to limitations in TURBO ASSEMBLER, we have to compile PCroute in 
;; pieces.  declare.inc is a 'header' file that constains the declarations
;; of all compile-time information that is shared among seperately compiled
;; pieces.  
;;
;;  AUTHOR: Vance Morrison  
;;  DATE:   4/28/89  
;;****************************************************************************

    .MODEL SMALL

    JUMPS                       ;; deal with long jump displacements 
                                ;; automatically
    .CODE                       ;; extablish the default segment

    include debug.inc
    include bridge.inc
    include buffer.inc
    include queue.inc
    include if.inc
    include memory.inc

    include wd8003e.inc			;; can be commented out if not used
    include qif.inc
    include slip.inc
    include i8250.inc
    include packet.inc
    include 3c507.inc

	cur_if = 1
;;*************************************************************************
;; start declaration section.   Comment in your coices

        ;; the first WD8013EBT card
 ;   WDE_DECLARE %cur_if, 280H, 0D000H, 0H, 1, 64, 1  ;; promiscuous ,16K, 16bit
 ;   IF_DECLARE %cur_if, %cur_if, WDE
 ;   cur_if = cur_if + 1

        ;; the second WD8013EBT card
 ;   WDE_DECLARE %cur_if, 2A0H, 0D800H, 0H, 1, 64, 1  ;; promiscuous ,16K, 16bit
 ;   IF_DECLARE %cur_if, %cur_if, WDE
 ;   cur_if = cur_if + 1

        ;; the third WD8013EBT card
 ;   WDE_DECLARE %cur_if, 2C0H, 0A000H, 0H, 1, 64, 1  ;; promiscuous ,16K, 16bit
 ;   IF_DECLARE %cur_if, %cur_if, WDE
 ;   cur_if = cur_if + 1

        ;; the first WD8003EBT card
 ;   WDE_DECLARE %cur_if, 280H, 0D000H, 0H, 1, 128    ;; promiscuous,  32K
 ;   IF_DECLARE %cur_if, %cur_if, WDE
 ;   cur_if = cur_if + 1
    
        ;; the second WD8003EBT card
 ;   WDE_DECLARE %cur_if, 2A0H, 0D800H, 0H, 1, 128    ;; promiscuous,  32K
 ;   IF_DECLARE %cur_if, %cur_if, WDE
 ;   cur_if = cur_if + 1
    
        ;; the first WD8003E Ethernet card or WD8003S(H) Starlan card
     WDE_DECLARE %cur_if, 280H, 0D000H, 0H, 1, 32     ;; promiscuous,  8K
     IF_DECLARE %cur_if, %cur_if, WDE
     cur_if = cur_if + 1

        ;; a second WD8003E Ethernet card or WD8003S(H) Starlan card
     WDE_DECLARE %cur_if, 2A0H, 0D800H, 0H, 1, 32     ;; promiscuous,  8K
     IF_DECLARE %cur_if, %cur_if, WDE
     cur_if = cur_if + 1

        ;; a serial card for a remote bridge
 ;   I8250_DECLARE %cur_if, SLIP, %cur_if, IBM_COM1_PORT, IBM_COM1_IRQ, 0
 ;   tmp = cur_if*10                                 ;; generate temp names
 ;   BUFF_DECLARE %(tmp+1), 3200                      ;; the read buffer
 ;   QUEUE_DECLARE %(tmp+2), 5, %(size qif_entry)     ;; the read queue
 ;   BUFF_DECLARE %(tmp+3), 10240                     ;; the write buffer
 ;   QUEUE_DECLARE %(tmp+4), 16, %(size qif_entry) ;; the write queue
 ;   SLIP_DECLARE %cur_if,%cur_if,%(tmp+1),%(tmp+2),%(tmp+3),%(tmp+4)
 ;   MY_SET_MTU %cur_if, 1518                         ;; overide default MTU
 ;   Q_IF_DECLARE %cur_if,%(tmp+1),%(tmp+2),%(tmp+3),%(tmp+4),SLIP,%cur_if
 ;   IF_DECLARE %cur_if, %cur_if, Q
 ;   cur_if = cur_if + 1

        ;; a packet driver entry
 ;   PKT_DECLARE %cur_if, 60H, 01, 1    ;; <name> <Int num> <Class (Eth=1), prom
 ;   IF_DECLARE %cur_if, %cur_if, PKT
 ;   cur_if = cur_if + 1

        ;; a second packet driver entry
 ;   PKT_DECLARE %cur_if, 61H, 01, 1    ;; <name> <Int num> <Class (Eth=1), prom
 ;   IF_DECLARE %cur_if, %cur_if, PKT
 ;   cur_if = cur_if + 1

        ;; a 3C507 card entry 64K of memory at D0000H
 ;   C507_DECLARE %cur_if, 280H, 0D000H, 10000H, 1   ;; name,io,seg,len,prom
 ;   IF_DECLARE %cur_if, %cur_if, C507
 ;   cur_if = cur_if + 1

        ;; a 3C507 card entry 64K of memory at C0000H
 ;   C507_DECLARE %cur_if, 2A0H, 0C000H, 10000H, 1   ;; name,io,seg,len,prom
 ;   IF_DECLARE %cur_if, %cur_if, C507
 ;   cur_if = cur_if + 1

;; end declaration section
;;*************************************************************************

   num_dls = cur_if - 1
   mybridge = 1
   BDG_DECLARE %mybridge, 1, %num_dls, 1
