;;****************************************************************************
;; at.inc

;; This file contains definitions for calling the appletalk driver that
;; comes with a TOPS flashcard

AsyncMask = 8000H

PapQuantum = 200H

EOMbit = 10H
XObit = 20H
STSbit = 8H
ChkSum = 1H
InfiniteRetry = 0

ATInit = 1H
ATKill = 2H
ATGetNetInfo = 3H
ATGetClockTicks = 4H
ATStartTimer = 5H
ATResetTimer = 6H
ATCancelTimer = 7H

LAPInstall = 10H
LAPRemove = 11H
LAPWrite = 12H
LAPRead = 13H
LAPCancel = 14H

DDPOpenSocket = 20H
DDPCloseSocket = 21H
DDPWrite = 22H
DDPRead = 23H
DDPCancel = 24H

NBPRegister = 30H
NBPRemove = 31H
NBPLookup = 32H
NBPConfirm = 33H
NBPCancel = 34H

ZIPGetZoneList = 35H
ZIPGetMyZOne = 36H
ZIPTakedown = 37H
ZIPBringup = 38H

ATPOpenSocket = 40H
ATPCloseSocket = 41H
ATPSendRequest = 42H
ATPGetRequest = 43H
ATPSendResponse = 44H
ATPAddResponse = 45H
ATPCancelTrans = 46H
ATPCancelResponse = 47H
ATPCancelRequest = 48H

ASPGetParms = 50H
ASPCloseSession = 51H
ASPCancel = 52H
ASPInit = 53H
ASPKill = 54H
ASPGetSession = 55H
ASPGetRequest = 56H
ASPCmdReply = 57H
ASPWrtContinue = 58H
ASPWrtReply = 59H
ASPCloseReply = 5aH
ASPNewStatus = 5bH
ASPAttention = 5cH
ASPGetStatus = 5dH
ASPOpenSession = 5eH
ASPCommand = 5fH
ASPWrite = 60H
ASPGetAttention = 61H

PAPOpen = 70H
PAPClose = 71H
PAPRead = 72H
PAPWrite = 73H
PAPStatus = 74H
PAPRegName = 75H
PAPRemName = 76H
PAPInit = 77H
PAPNewStatus = 78H
PAPGetNextJob = 79H
PAPKill = 7aH
PAPCancel = 7bH

NoErr = 0

MAXCOLISERR = -1
MAXDEFERERR = -2

LAP_LENERR = -30
LAP_TYPERR = -31
TABFULLERR = -32
LAP_NOTFND = -33
LAP_CANCELLED = -34

DDP_SKTERR = -40
DDP_LENERR = -41
NOBRDGERR = -42
DDP_CANCELLED = -43

ATP_REQFAILED = -100
ATP_NOSENDRESP = -101
ATP_BADSOCKET = -102
ATP_NORELEASE = -103
ATP_OVERFLOW = -104
ATP_CANCELLED = -105

NO_MEM_ERROR = -120
BAD_PARAMETER = -121
STACKERROR = -122
ATNOTINITIALIZED = -123
CALLNOTSUPPORTED = -124
HARDW = -125

NBP_NEWSOCKET = -200
NBP_NOCONFIRM = -201
NAME_IN_USE = -202
NBP_NO_ROOM = -203
BAD_NAME = -204
NBP_NOTFOUND = -205
NBP_CANCELLED = -206
TMR_NOTFOUND = -215
TMR_CANCELLED = -216

PAP_BADCONNID = -300
PAP_NOCONNIDS = -301
PAP_DIED = -302
PAP_LENERR = -303
PAP_CANCELLED = -304
PAP_WRITE_ACTIVE = -310
PAP_READ_ACTIVE = -311

BuffPtr STRUC
    buff_off        DW 0
    buff_seg        DW 0
BuffPtr ENDS

FuncPtr STRUC
    func_off        DW 0
    func_seg        DW 0
FuncPtr ENDS


InfoParams STRUC
    inf_command     DW 0
    inf_status      DW 0
    inf_compfun     FuncPtr <>
    inf_network     DW 0
    inf_nodeid      DB 0
    inf_abridge     DB 0
    inf_config      DW 0
    inf_buffptr     BuffPtr <>
    inf_buffsize    DW 0
InfoParams  ENDS


;; bits in inf_config 
TimerMask = 1H
LAPMask = 2H
DDPMask = 4H
NBPMask = 8H
ATPMask = 10H
ZIPMask = 20H
PAPWksMask = 40H
PAPSrvrMask = 80H
ASPWksMask = 100H
ASPSrvrMask = 200H

ATErrorStatus   STRUC
    bufflen         DD 0
    packets         DD 0
    crcerrs         DD 0
    overruns        DD 0
    deferrals       DD 0
    collisions      DD 0
    timeouts        DD 0
    totalsent       DD 0
    goodrecptns     DD 0
    pktlenerrs      DW 0
    badlappkt       DW 0
    buffoverflow    DW 0
ATErrorStatus   ENDS

AddrBlk STRUC
    network     DW 0
    nodeid      DB 0
    socket      DB 0
AddrBlk ENDS

NBPTuple    STRUC
    ent_address AddrBlk <>
    ent_enum    DB 0
    ent_name    DB 64 DUP (0)
NBPTuple    ENDS

NBPTabEntry STRUC
    tab_next        BuffPtr <>
    tab_tuple       NBPTuple <>
NBPTabEntry ENDS

NBPParams   STRUC
    nbp_command     DW 0
    nbp_status      DW 0
    nbp_compfun     FuncPtr <>
    nbp_addr        AddrBlk <>
    nbp_toget       DW 0
    nbp_buffptr     BuffPtr <>
    nbp_buffsize        DW 0
    nbp_interval        DB 0
    nbp_retry       DB 0
    nbp_entptr      BuffPtr <>
NBPParams   ENDS

BDSElement  STRUC
    bds_buffptr     BuffPtr <>
    bds_buffsize        DW 0
    bds_datasize        DW 0
    bds_usrs        DB 4 DUP (0)
BDSElement  ENDS

ATPParams   STRUC
    atp_command     DW 0
    atp_status      DW 0
    atp_compfun     FuncPtr <>
    atp_addrblk     AddrBlk <>
    atp_socket      DB 0
    atp_fill        DB 0
    atp_buffptr     BuffPtr <>
    atp_buffsize        DW 0
    atp_interval        DB 0
    atp_retry       DB 0
    atp_flags       DB 0
    atp_seqbit      DB 0
    atp_tranid      DW 0
    atp_users       DB 4 DUP (0)
    atp_bdsbuffs        DB 0
    atp_bdsresps        DB 0
    atp_bdsptr      BuffPtr <>
ATPParams   ENDS

LAPParams   STRUC
    lap_command     DW 0
    lap_status      DW 0
    lap_compfun     FuncPtr <>
    lap_fill1       DW 0
    lap_destnode        DB 0
    lap_fill2       DW 0
    lap_type        DB 0
    lap_buffptr     BuffPtr <>
    lap_buffsize        DW 0
LAPParams   ENDS

DDPParams   STRUC
    ddp_command     DW 0
    ddp_status      DW 0
    ddp_compfun     FuncPtr <>
    ddp_addr        AddrBlk <>
    ddp_socket      DB 0
    ddp_type        DB 0
    ddp_buffptr     BuffPtr <>
    ddp_buffsize        DW 0
    ddp_chksum      DB 0
DDPParams   ENDS

ZIPParams   STRUC
    zip_command     DW 0
    zip_status      DW 0
    zip_compfun     FuncPtr <>
    zip_fill        DD 0
    zip_zones       DW 0
    zip_buffptr     BuffPtr <>
    zip_buffsize        DW 0
ZIPParams   ENDS

ASPParams   STRUC
    asp_command     DW 0
    asp_status      DW 0
    asp_compfun     FuncPtr <>
    asp_maxcmdsize      DW 0
    asp_quantum     DW 0
ASPParams   ENDS

ASPSrvrParams   STRUC
    asps_command        DW 0
    asps_status     DW 0
    asps_compfun        FuncPtr <>
    asps_u          AddrBlk <>
    asps_sesrefnum      DW 0
    asps_buffptr        BuffPtr <>
    asps_buffsize       DW 0
    asps_reqrefnum      DW 0
ASPSrvrParams   ENDS

ASPWksParams    STRUC
    aspw_command        DW 0
    aspw_status     DW 0
    aspw_compfun        FuncPtr <>
    aspw_u          AddrBlk <>
    aspw_sesrefnum      DW 0
    aspw_cmdblock       BuffPtr <>
    aspw_cmdblocksize   DW 0
    aspw_replybuff      BuffPtr <>
    aspw_replysize      DW 0
    aspw_actreply       DW 0
    aspw_writebuff      BuffPtr <>
    aspw_writesize      DW 0
    aspw_actwritten     DW 0
ASPWksParams    ENDS

TimerParams STRUC
    tmr_command     DW 0
    tmr_status      DW 0
    tmr_compfun     FuncPtr <>
    tmr_ticks       DD 0
    tmr_time        DW 0
    tmr_params      BuffPtr <>
TimerParams ENDS

PAPStatusRec    STRUC
    pap_system      DD 0
    pap_reply       DB 256 DUP (0)
PAPStatusRec    ENDS

PAPParams   STRUC
    pap_command     DW 0
    pap_status      DW 0
    pap_compfun     FuncPtr <>
    pap_addr        AddrBlk <>
    pap_refnum      DW 0
    pap_buffptr     BuffPtr <>
    pap_buffsize        DW 0
    pap_eof         DB 0
    pap_srefnum     DB 0
    pap_entptr      BuffPtr <>
PAPParams   ENDS

ipgpAssign = (1 SHL 24)
ipgpName = (2 SHL 24)
ipgpServer = (3 SHL 24)
ipgpError = -1

IPGP    STRUC
    opcode      DD 0
    ipaddress   DD 0      ;; me 
    ipname      DD 0      ;; name server
    ipbroad     DD 0      ;; broadcast address
    ipfile      DD 0      ;; file server
    ipother     DD 4 DUP (0)
    stringe     DB 128 DUP(0)   ;; error message
IPGP    ENDS
 
