;;****************************************************************************
;;                     queue.inc              queue.inc
;;****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*************************************************************************
;;
;;  queue.inc implements a simple, general purpose, fixed lenght queue.
;;
;; AUTHOR: Vance Morrison
;; DATE:   5/24/89
;; ADDRESS: morrison@accuvax.nwu.edu
;;****************************************************************************

queue_data STRUC 
    head    DW ?
    tail    DW ?
queue_data ENDS 


;;**************************************************************************
;; QUEUE_DECLARE declares a queue called 'name' that can hold 'len' entries
;; of size 'size'
;;
QUEUE_DECLARE MACRO name, len, size

    .DATA
    queue_&name&_len = len + 1
    queue_&name&_size = size
    global queue_&name&_data:queue_data
    global queue_&name&_entries:byte
    queue_&name&_end = queue_&name&_entries+(queue_&name&_size*queue_&name&_len)
    .CODE
ENDM


;;**************************************************************************
;; QUEUE_DEFINE allocates the necessary memory and initializes the queue
;;
QUEUE_DEFINE MACRO name
ifdef queue_&name&_len
    .DATA
    queue_&name&_data queue_data <>
    queue_&name&_entries DB (queue_&name&_size * queue_&name&_len) dup (0)

    .CODE
    mov queue_&name&_data.head, offset queue_&name&_entries
    mov queue_&name&_data.tail, offset queue_&name&_entries
endif
ENDM


;;**************************************************************************
;; QUEUE_HEAD_out_SI returns the pointer to the head of the queue in SI.
;; if the queue is empty this macro jumps to 'empty'
;;
QUEUE_HEAD_out_SI_const_AX_BX_CX_DX_BP_DI_ES MACRO name, empty

    mov SI, word ptr queue_&name&_data.head
    cmp SI, word ptr queue_&name&_data.tail
    jz empty
ENDM


;;**************************************************************************
;; QUEUE_DEQUEUE_in_SI removes the head entry pointed to by SI from the
;; queue.  (SI was assumed to be inititialized by QUEUE_HEAD)
;;
QUEUE_DEQUEUE_in_SI_const_AX_BX_CX_DX_BP_DI_ES MACRO name
    local no_wrap

    add SI, offset queue_&name&_size
    cmp SI, offset queue_&name&_end
    jb no_wrap
        mov SI, offset queue_&name&_entries
    no_wrap:
    mov word ptr queue_&name&_data.head, SI
ENDM


;;**************************************************************************
;; QUEUE_ENQUEUE enqueues a buffer and returns its pointer in DI.  The
;; entry can then be filled in as desired.
;;
QUEUE_ENQUEUE_out_DI_const_BX_CX_DX_BP_SI_ES MACRO name, full
    local no_wrap

    mov DI, queue_&name&_data.tail          ;; increment with wrap
    mov AX, DI                              ;; save DI
    add DI, offset queue_&name&_size
    cmp DI, offset queue_&name&_end
    jb no_wrap
        mov DI, offset queue_&name&_entries
    no_wrap:
    cmp DI, word ptr queue_&name&_data.head
    jz full
    mov queue_&name&_data.tail, DI
    mov DI, AX
ENDM

