#ifndef EXTERN
#define EXTERN extern
#endif
EXTERN enum asc_val {CTRLD=4,TAB=9,CR=13,CTRLS=19,ESC=27,SPACE=32};
EXTERN enum ext_val {F1=59,F2,F3,F4,F5,F6,F7,F8,F9,F10,
		     UP=72,LEFT=75,RIGHT=77,DOWN=80};
EXTERN char neurfname[39];      /* current neuron filename */
EXTERN char envfname[39];       /* current environment filename */
EXTERN struct Iint {		/* intrinsic current structure */
       int type;		/* type: 0=Vinf; 1=rand */
       float IL;		/* low intrinsic current, Ae-9 */
       float pL[3];		/* parameters for LIC function */
       float IH;		/* high intrinsic current, Ae-9 */
       float pH[2];		/* parameters for HIC function */
       int H;                   /* TRUE if high intrinsic current on */
       float tint;		/* time since intrinsic current changed */
       float tmax;              /* maximum time since current changed */
       };
EXTERN struct Iint *Iinta;	/* intrinsic current structure area pointer */
EXTERN int ni;			/* number of intrinsic current blocks */
EXTERN struct con {		/* neuron connections structure */
       char sname[7];           /* sending neuron name */
       int s;			/* sending neuron index */
       float Isr;		/* current multiplier from s */
       int ctype;		/* connection type: 0=reg; 1=gate; 2=mod */
       char cname[7];           /* compound synapse neuron name */
       int c;			/* compound synapse neuron index */
       float Icr;		/* compound current constant */
       int U;			/* ungated state, 0 or 1 */
       struct con *next;	/* next connection */
       };
EXTERN struct con *cona;	/* connections area pointer */
EXTERN int nc;			/* number of connections */
EXTERN enum senst {NONE=0,LAF,LAB,AC,OS,EC,MC};
EXTERN struct neuron {		/* basic neuron structure */
       char name[7];		/* name of neuron */
       float Gmem;		/* membrane conductance, Se-6=(1/ohm)e-6 */
       float Cmem;		/* membrane capacitance, pF=Fe-9 */
       float Vt;		/* threshold voltage, mV=Ve-3 */
       float Fmin;		/* minimum firing frequency, dimensionless */
       float Gain;		/* firing frequency gain, 1/mV = 1/(Ve-3) */
       struct Iint *Iint;	/* pointer to intrinsic current parameters */
       enum senst Isens;	/* sensory current function name */
       float pI[2];             /* sensory current parameters */
       int mtype;		/* motor type: 0=none; 1=force; 2=state */
       int mname;		/* mtr name: 0=fwd|foot; 1=bck|mouth; 2=lat */
       float mconst;		/* motor constant */
       struct con *con;		/* neuron interconnections */
       };
EXTERN struct neuron *ns;	/* pointer to neuron list */
EXTERN int nn;			/* number of neurons */
EXTERN struct neurcalc {	/* calculated quantities for neurons */
       double V;		/* voltage */
       double Vlast;            /* last voltage */
       double F;		/* firing frequency */
       double Flast;
       double I;                /* current */
       };
EXTERN struct neurcalc *nsc;	/* pointer to neuron calculation list */
EXTERN float attang[6];         /* leg attachment angle */
EXTERN float attl[6];           /* leg attachment length */
EXTERN float legl[6];           /* leg length when up */
EXTERN float legang[6];         /* leg angles */
EXTERN int lfoot[6];            /* last foot state */
EXTERN int antenna[2];          /* antenna contact */
EXTERN float antcang[2];        /* antenna contact angle */
EXTERN float antang[2];         /* antenna angle to bug, constant */
EXTERN float antl;              /* antenna length from bug center, constant */
EXTERN int cercus[2];           /* cercus contact */
EXTERN float cercang[2];        /* cercus angle to bug, constant */
EXTERN float cercl;             /* cercus length from bug center, constant */
EXTERN float mouthodor;         /* odor strength at mouth */
EXTERN float odor[2];           /* odor strength at each antenna */
EXTERN float energy;            /* energy capacity */
EXTERN int mouth;               /* mouth contact */
EXTERN float maxlegang[6];      /* maximum leg angles */
EXTERN float minlegang[6];      /* minimum leg angles */
EXTERN float DT;                /* time step */
EXTERN float AspR;              /* aspect ratio */
EXTERN float hdsang[2];
EXTERN float hdsl;
EXTERN float hdtang;
EXTERN float hdtl;
EXTERN float hdbang;
EXTERN float hdbl;
EXTERN float btang[2];
EXTERN float btl;
EXTERN float bmang[2];
EXTERN float bml;
EXTERN float bbang[2];
EXTERN float bbl;
EXTERN float cerbang[2];
EXTERN float cerbl;
EXTERN float antbang[2];
EXTERN float antbl;
EXTERN int nfood;               /* number of food patches */
EXTERN int foodx[NFOOD];        /* food x coordinates */
EXTERN int foody[NFOOD];        /* food y coordinates */
EXTERN int foodsize[NFOOD];     /* food sizes */
EXTERN float foodr[NFOOD];      /* radius of food */
EXTERN float ofoodr[NFOOD];     /* old food radius */
EXTERN int nblock;              /* number of blocks */
EXTERN int blockx[NBLOCK];      /* block x coordinates */
EXTERN int blocky[NBLOCK];      /* block y coordinates */
EXTERN struct graph {           /* graph structure */
       int gtype;               /* graph types: 0-none, 1-var, 2-gait */
       char gneur[7];           /* graph neuron name */
       int g;                   /* graph neuron index */
       int gvar;                /* graph variable: 0-V, 1-F, 2-I */
       int gscale;              /* graph scale */
       } gr[5];
EXTERN int Iextgr;              /* graph whose neuron has external current */
EXTERN int Iextind;             /* index of neuron for external current */
EXTERN float Iextint;           /* external current/10E-9 */
EXTERN struct bug {             /* bug location, etc. */
       float x;                 /* bug x */
       float y;                 /* bug y */
       float ang;               /* bug angle */
       int foot[6];             /* foot states */
       float footx[6];          /* foot x's */
       float footy[6];          /* foot y's */
       antx[2];                 /* antenna x's */
       anty[2];                 /* antenna y's */
       cercx[2];                /* cercus x's */
       cercy[2];                /* cercus y's */
       mouthx;                  /* mouth x */
       mouthy;                  /* mouth y */
       mouthst;                 /* mouth state: 0-closed, 1-open */
       };
EXTERN struct bug bug;          /* bug data */
EXTERN struct bug obug;         /* old bug data */
EXTERN int drawmult;            /* multiple of steps, before draws bug */
EXTERN int edget[2];            /* time left for edge turning */
EXTERN float edgecang[2];       /* angle of bug to edge while turning */
EXTERN int plottype;            /* plot type: 0=graphs; 1=neuron activity */
EXTERN struct bugpts {		/* structure of calculted bug pts */
       int head[8];		/* points of head */
       int body[12];		/* points of body */
       int footx[6];		/* foot x's */
       int footy[6];		/* foot y's */
       int legx[6];		/* leg attachment x's */
       int legy[6];		/* leg attachment y's */
       int antx[2];		/* antenna x's */
       int anty[2];		/* antenna y's */
       int antax[2];		/* antenna attachment x's */
       int antay[2];		/* antenna attachment y's */
       int cercx[2];		/* cercus x's */
       int cercy[2];		/* cercus x's */
       int cercax[2];		/* cercus attachment x's */
       int cercay[2];		/* cercus attachment y's */
       };
EXTERN struct bugpts bugp;	/* bug pts */
EXTERN char recpath[39];	/* path for recording file */
EXTERN int recnum;		/* if 1-10, recording */
EXTERN int reccnt;		/* record being filled */
EXTERN struct recbug {		/* record for one bug recording */
       char Iextname[7];	/* external current name, if changed */
       int Iext;		/* external current, if changed */
       int energy;		/* energy */
       char graphx;		/* graph x pos */
       char graphy1[5];		/* 1st graph y pos */
       char graphy2[5];		/* 2nd graph y pos */
       char footst;		/* foot states */
       char mouthfood;		/* mouth & food states */
       int x;			/* x pos of front of bug */
       int y;			/* y pos of front of bug */
       signed char head[6];	/* points of head */
       signed char body[12];	/* points of body */
       signed char footx[6];	/* foot x's */
       signed char footy[6];	/* foot y's */
       signed char legx[6];	/* leg attachment x's */
       signed char legy[6];	/* leg attachment y's */
       signed char antx[2];	/* antenna x's */
       signed char anty[2];	/* antenna y's */
       signed char antax[2];	/* antenna attachment x's */
       signed char antay[2];	/* antenna attachment y's */
       signed char cercx[2];	/* cercus x's */
       signed char cercy[2];	/* cercus x's */
       signed char cercax[2];	/* cercus attachment x's */
       signed char cercay[2];	/* cercus attachment y's */
       } rc[NREC];
EXTERN struct recgraph {	/* graph structure for recording */
       int gtype;               /* graph types: 0-none, 1-var, 2-gait */
       char gneur[7];           /* graph neuron name */
       int gvar;                /* graph variable: 0-V, 1-F, 2-I */
       int gscale;              /* graph scale */
       } rgr[5];
EXTERN struct recinit {		/* initial data structure for recording */
       int foodr[NFOOD];	/* initial food radius */
       int foodx[NFOOD];	/* initial food x's */
       int foody[NFOOD];	/* initial food y's */
       int nblock;		/* number of blocks */
       int blockx[NBLOCK];	/* block x's */
       int blocky[NBLOCK];	/* block y's */
       } rin;
