/* Copyright 1991 by 
   by Bruce Colletti
   (Richmond VA)
   GEnie      b.colletti
   CompuServe 71121,1452

   This code presents a one-page course on Neural Networks by drawing a
   neural net and then commenting on aspects of it.  The code was written
   in PDCPROLOG 3.21, a product of:
   
        The PROLOG Development Center
        568 14th Street NW
        Atlanta GA  30318
        
        404-873-1366
        BBS 404-872-5358 2400N81
        
   This code is entirely the work of its author.  The executable and source
   codes may be freely distributed PROVIDED THAT no charge is made except
   to cover costs such as distribution, envelopes, etc.
   
   Executable/source codes and README file must be distributed together.
*/

bgidriver "_EGAVGA_driver_far"
bgidriver "_HERC_driver_far"
bgifont "_triplex_font_far"

constants
  bgipath = "c:\\pdcprolo\\bgi"
  ylayer1 = 180
  ylayer2 = 125
  ylayer3 = 70
  font1   = default_FONT
      
include "c:\\pdcprolog\\include\\bgi.pre"

domains
  x,y,layer,node,color,textsize,font = integer
  length = integer
  stringlist = string*
    
database
  a(x,y)
  neuron(layer,node,x,y)

predicates
  do(node)                    % set color to draw synapses in
  ok(integer,integer,integer) % determine if graphics mode is acceptable
  harrow(x,y,length,color)    % draw horizontal arrow
  draw_synapse(layer,layer)   % draw a synapse
  uparrow(x,y,length,color)   % draw vertical arrow
  xwrite(x,y,color,textsize,font,stringlist) % output text
  xwrite(stringlist)          % output several lines of text
    
clauses % locate network neurons
  
  neuron(1,1,170,ylayer1).
  neuron(1,2,330,ylayer1).
  neuron(1,3,490,ylayer1).

  neuron(2,1,116,ylayer2).   
  neuron(2,2,222,ylayer2).
  neuron(2,3,328,ylayer2).
  neuron(2,4,434,ylayer2).
  neuron(2,5,540,ylayer2).
  
  neuron(3,1,275,ylayer3).
  neuron(3,2,381,ylayer3).
    
clauses
  do(Node) if
    0 = Node mod 2,!,
    setcolor(yellow);
    
    setcolor(lightgray).
    
  ok(ega,egahi,egahi)                if !.
  ok(ega64,ega64hi,ega64hi)          if !.
  ok(egamono,egamonohi,egamonohi)    if !.
  ok(hercmono,hercmonohi,hercmonohi) if !.
  ok(vga,Mode,vgamed)                if Mode > 0,!.
  ok(_,_,_) if
    write("\nSorry, but the supported modes are:"),
    write("\n\n   - hercules monochrome"),
    write("\n   - EGA/VGA modes of 640x350+ dimensions."),
    exit.
    
  harrow(X,Y,Length,Color) if
    setcolor(Color),
    setfillstyle(solid_fill,Color),
    X1 = X + Length,
    line(X,Y,X1,Y),
    Y1 = Y-3,
    Y2 = Y+3,
    X2 = X1+3,
    fillpoly([X1,Y1,X2,Y,X1,Y2]).

  uparrow(X,Y,Length,Color) if
    setcolor(Color),
    setfillstyle(solid_fill,Color),
    Y1 = Y - Length,
    line(X,Y,X,Y1),
    X1 = X-3,
    X2 = X+3,
    Y2 = Y1 - 3,
    fillpoly([X1,Y1,X,Y2,X2,Y1]).
    
  draw_synapse(TLayer,BLayer) if
    neuron(TLayer,TNode,XT,YT),
    do(TNode),
    neuron(BLayer,BNode,XB,YB),
    line(XB,YB,XT,YT),
    fail;
    
    1=1.

  xwrite(X,Y,Color,TextSize,Font,List) if
    assert(a(X,Y)),
    setcolor(Color),
    settextstyle(Font,horiz_DIR,TextSize),
    xwrite(List).

  xwrite([]) if retractall(a(_,_)),!.
  
  xwrite([H|T]) if
    retract(a(X,Y)),
    Y1 = Y + 10,
    asserta(a(X,Y1)),!,
    outtextxy(X,Y,H),
    xwrite(T).
        
% This is where the program begins.  The clauses above can be viewed as the
% subroutines.  If this were a C program, the goal section would be MAIN().

goal
  detectgraph(Driver,Mode),
  ok(Driver,Mode,Mode1),
  initgraph(Driver,Mode1,_,_,bgipath),
  fail;
  
  settextjustify(left_TEXT,center_TEXT),
  rectangle(165,3,467,35),
  xwrite(175,15,white,4,triplex_FONT,["A Neural Network"]),
  xwrite(1,ylayer1,white,1,font1,["Input Layer"]),
  xwrite(1,ylayer2,white,1,font1,["Hidden Layer"]),
  xwrite(1,ylayer3,white,1,font1,["Output Layer"]),
  fail;

% draw connections
  setcolor(yellow),
  draw_synapse(2,1),
  draw_synapse(3,2),
  fail;

% draw neurons  
  neuron(_,_,X,Y),
  fillellipse(X,Y,10,8),
  fail;
  
% write comments
  harrow(400,ylayer3,10,white),
  xwrite(420,ylayer3,white,1,font1,["a neuron"]),

  Y1 = (ylayer2+ylayer3) / 2.3,
  harrow(440,Y1,10,yellow),
  xwrite(465,Y1,yellow,1,font1,["a synaptic connection"]),
      
  fail;

% data flow is "bottom up" arrow

  setfillstyle(solid_fill,lightblue),
  Y1 = ylayer2-10,
  setcolor(lightblue),
  fillpoly([580,ylayer1,580,ylayer2,560,ylayer2,590,Y1,620,ylayer2,
            600,ylayer2,600,ylayer1]),
  Y2 = ylayer1 + 10,
  xwrite(540,Y2,white,1,font1,["Data flow is","  bottom up"]),
  fail;
  
% training set
  
  setcolor(lightblue),
  Y = ylayer1 + 27,
  uparrow(170,Y,10,lightblue),
  uparrow(330,Y,10,lightblue),
  uparrow(490,Y,10,lightblue),

  Y1 = ylayer1 + 35,
  xwrite(135,Y1,lightblue,1,font1,["Training Set enters here one observation at a time"]),  
  fail;
  
% output layer

  Y = ylayer3-15,
  uparrow(275,Y,5,lightblue),
  uparrow(381,Y,5,lightblue),
  xwrite(392,Y,lightblue,1,font1,["computed vs. correct outputs"]),
  fail;

% author ID

  xwrite(440,290,lightcyan,1,font1,
                 ["Copyright 1991 (v1.1)","by Bruce Colletti",
                  "(Richmond VA)",
                  "GEnie      b.colletti",
                  "CompuServe 71121,1452",
                  "Free Distribution"]),
  fail;
  
% a neuron "up close"

  xwrite(50,240,white,2,triplex_font,
       ["A hidden layer neuron up-close"]),

  setcolor(lightgray),
  rectangle(1,225,428,347),
  uparrow(55,275,15,lightblue),
  xwrite(60,260,lightblue,1,font1,[" output goes to each Output Layer neuron"]),
  H = 50,
  Dx = H*sin(45.0*pi/180),
  X1 = 55-Dx,
  X2 = 55+Dx,
  Y = 295 + H*cos(45.0*pi/180),
  setcolor(yellow),
  line(55,295,X1,Y),
  line(55,295,X2,Y),
  line(55,295,55,Y),
  xwrite(5,340,lightcyan,1,font1,["Inputs from bottom layer neurons"]),
  fail;
  
  setfillstyle(solid_fill,white),
  fillellipse(55,295,17,14),  
  xwrite(50,297,black,2,font1,["F"]),
  fail;
  
  xwrite(80,280,white,1,font1,["- multiply each input by connection weight"]),
  xwrite(80,290,white,1,font1,["- add all these products"]),
  xwrite(80,300,white,1,font1,["- pass sum to function F (the \"sigmoid\")"]),
  xwrite(80,310,lightblue,1,font1,["- send output of F to each neuron in",
                                   "  the top layer"]),
  fail;
  
  xwrite(440,230,white,1,font1,
         ["Each connection has a",
          "a numeric \"weight\"."," ",
          "Weights constantly change",
          "during training."]),
  readchar(_),
  closegraph().
  
  