/*-----------------------------------------------------------------------*
 * Greg Stevens                                                  6/24/93 *
 *                               nnstruct.c                              *
 *                                             [file 3 in a series of 6] *
 *                                                                       *
 *  This file contains the data structure declarations for a neural net, *
 * as well as the declaration for the initialization procedure for it,   *
 * as well as defining the global variable NUMNODES, which is initialized*
 * in the net initialization procedure.                                  *
 *                                                                       *
 *                                                                       *
 *  USE OF InitNet:                                                      *
 *                                                                       *
 * At the beginning of your program should appear a variable declaration *
 *                                                                       *
 *  NNETtype N;   /* any variable name here *\                           *
 *                /* NUMNODES is already declared *\                     *
 *  N = InitNet( NUMNODES );                                             *
 *                                                                       *
 *-----------------------------------------------------------------------*/
#include "nninputs.c"                 /* includes constant definitions   */
#include "stdlib.h"                   /* for randomizing functions       */

typedef struct
          {
             float state;               /* activation state value of node*/
             float weights[ MAXNODES ]; /* input connection weights      */
             float thresh;              /* threshhold input value        */
             int actfn;                 /* activation functn: 0=linear,  */
                                        /*                    1=logistic */
           } node;

/* NOTE: for any connections that do not exist, the value of that weight */
/*       is zero.                                                        */

typedef struct
          {
             node unit[ NUMLAYERS ][ MAXNODES ];
          } NNETtype;

/* NOTE: a net need only declared as type NNETtype, and all information  */
/*       can be accessed through the single field unit, thus, a call to  */
/*       the activation state of the second unit in the third layer is:  */
/*                                                                       */
/*       nnet.unit[3][2].state                                           */
/*                                                                       */

/* global variable declaration */
int NUMNODES[ NUMLAYERS ];

/* prototype for InitNet */
NNETtype InitNet( int NMND[ NUMLAYERS ] );

/* definition for InitNet */
NNETtype InitNet( int NMND[ NUMLAYERS ] )
{
   NNETtype N;                /* hold the initialized net value to return*/
   int c,d,f;                 /* counters for looping through the array  */

   srand(1);                  /* initializes the random number generator */

 /* Initialize NUMNODES */

   NMND[0] = INPUT_LAYER_SIZE;

   for ( c=1; (c<(NUMLAYERS-1)); ++c )
      {
         if (c==1) NMND[c] = HL_SIZE_1;
         if (c==2) NMND[c] = HL_SIZE_2;
         if (c==3) NMND[c] = HL_SIZE_3;
         if (c==4) NMND[c] = HL_SIZE_4;
         if (c==5) NMND[c] = HL_SIZE_5;
         if (c==6) NMND[c] = HL_SIZE_6;
         if (c==7) NMND[c] = HL_SIZE_7;
         if (c==8) NMND[c] = HL_SIZE_8;
         if (c==9) NMND[c] = HL_SIZE_9;
         if (c==10) NMND[c] = HL_SIZE_10;
      }

   NMND[ NUMLAYERS-1 ] = OUTPUT_LAYER_SIZE;

 /* Initialize N */

   /* WEIGHTS: random weights between connected nodes, all others 0       */
   /* STATES:  set to 1 if an actual node, set to -5 if not               */
   /* THRESH:  set initially to a random value                            */
   /* ACTFN:   all hidden units set to logistic (1), outputs to linear (0)*/
   /*          and input units and non-units set to (-1)                  */

   for (c=0; (c<NUMLAYERS); ++c)
    for (d=0; (d<MAXNODES); ++d)         /* for each node in each layer...*/
      if (d<NMND[c])                     /* IF it's an actual node...     */
        {
           /* ACTIVATION STATES */
  
           N.unit[c][d].state = 1;              /* set initial state = 1  */

           if (c==0)                            /* if its input layer...  */
             {
               N.unit[c][d].actfn = -1;         /* no activation function */

               for (f=0; (f<MAXNODES); ++f)
                {
                  N.unit[c][d].weights[f] = 0;  /*no weights to 1st layer */
                  N.unit[c][d].thresh     = -5; /*no threshhold for 1st   */
                }
             }
            else
             {
               /* ACTIVATION FUNCTION */

               if (c==NUMLAYERS-1)              /* if  the output layer   */
                 {                              /*    its logistic unit   */
                   N.unit[c][d].actfn = 1;
                 }
                else
                 {                              /* otherwise, logistic    */
                   N.unit[c][d].actfn = 1;
                 }

               /* THRESHHOLD (randomize)*/

               N.unit[c][d].thresh = (rand() % 100) / 100.0;

               /* WEIGHTS */

               for (f=0; (f<MAXNODES); ++f)     /* for each node in the   */
                                                /* weight list            */
               if (f<NMND[c-1])                 /* if from actual node,   */
                  N.unit[c][d].weights[f] = (rand() % 100) / 100.0;
                                                        /* set to ran num */
                                                        /* 0-1, to 0.##   */
                else                                    /* if not actual  */
                  N.unit[c][d].weights[f] = 0;          /* node, turn off */
             }   /* end if input layer */
        }
       else                              /* If it isn't an actual node... */
        {
           N.unit[c][d].state = -5;                /* set act state to -5 */
	   N.unit[c][d].thresh= -5;                /* no threshhold       */
           N.unit[c][d].actfn = -1;                /* no activation func. */

           for (f=0; (f<MAXNODES); ++f)            /*turn off connex to it*/
             N.unit[c][d].weights[f] = 0;
       }

   return( N );
}
