
/****************************************************************************
*   Function:    int sockrn(int fd, char *bufptr, int toread)               *
*   Operation:   to read n bytes from socket fd into bufptr                 *
*   Returns:     the number of bytes read, or -1 for error                  *
*   Parameters:  fd, socket file descriptor                                 *
*                bufptr, address of character array to read into            *
*                toread, the actual number of bytes to read into bufptr     *
****************************************************************************/

extern int errno;

# include <io.h>
#include <time.h>

int sockrn(fd, bufptr, toread)
  register int fd;
  register char *bufptr;
  register int toread;
{
  int togo, nread;
  long itimer, ctimer;

  togo = toread;
  while (togo > 0) {
    time(&itimer);	/* Reset initial timer */
timingit:
    if ((nread = read(fd, bufptr, togo)) < 0) {
      if (errno == 35) {
	time(&ctimer);	/* Reset current timer */
	if (ctimer > itimer + 2) {	/* Too long? */
	  break;	/* EOD indicated */
	} else {
	  goto timingit;	/* go wait... */
	}
      }
    }
    if (nread == 0)
      break;	/* a 0 indicates EOF */
    togo -= nread;
    bufptr += nread;
  }
  *bufptr = 0;
  return (toread - togo);
}
