/****************************************************************************
*   Function:    int sockr(int fd, char *ptr, int maxlen)                   *
*   Operation:   to read bytes from socket fd into ptr up to a newline      *
*   Returns:     a 0 for OK, or -1 for error                                *
*   Parameters:  fd, socket file descriptor                                 *
*                ptr, address of character array to read into               *
*                maxlen, the maximum number of characters to read into ptr  *
****************************************************************************/
#include "socko.h"

#include <stdio.h>

#ifdef UNIX
# include <sys/time.h>
#else
# include <io.h>
# include <sys/nfs_time.h>
#endif

#ifdef UNIX
#include <sys/types.h>
#include <errno.h>
extern int errno;
#else
#include <tklib.h>
#include <tk_errno.h>
#endif

#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>

struct timeval wait_time;
fd_set rwfds;

int sockr(fd, ptr, maxlen)
  register int fd;
  register char *ptr;
  register int maxlen;
{
  int n, rc;
  char c;
  n = 0;
  for (;;) {
    if (n > maxlen) 
      break; 
    if ((rc = recv(fd, &c, 1, 0)) == 1) {
      ptr[n] = c;
      n++;
      if (c == '\n')
	break;
    } else if (rc < 0) {	/* No byte read this round */
#ifndef SYSV
      if (errno == EWOULDBLOCK) {
#endif

#ifdef SEQ
      if (errno == EWOULDBLOCK) {
#endif

        FD_ZERO(&rwfds);
        FD_SET(fd, &rwfds); 
        wait_time.tv_sec = 25;
        wait_time.tv_usec = 0;
        if ((select(32, &rwfds, (fd_set*) 0, (fd_set *) 0, &wait_time)) < 1)        
          return(-1);
#ifndef SYSV
      } else
        return(-1);
#endif

#ifdef SEQ
      } else
        return(-1);
#endif
   
    } else {	/* rc == 0, means socket closed */
      *ptr = 0;
      return (-1);	/* return a -1 for socket error */
    }
  }
  ptr[n] = 0;

  if( ptr[strlen(ptr)-1] == '\n' )
      ptr[strlen(ptr)-1] = 0;   /* stripping newline */
  if( ptr[strlen(ptr)-1] == '\r' )
      ptr[strlen(ptr)-1] = 0;   /* stripping carriage return */
  if( ptr[strlen(ptr)-1] == '\n' )
      ptr[strlen(ptr)-1] = 0;   /* stripping newline */
  strcat(ptr, "\n");	/* assure a newline */

  return (0);
}
