@echo off
echo .
echo This batch file is a sample of how you can delete a user object.
echo . It assumes: 
echo .  Main network drive is H:
echo .  The batch files are located in SYS:\
echo .
goto end

@echo off
echo  .
echo  Purpose:  Delete the User's object and the appropiate user files
echo  .
echo  .             = Description =       = Type =         = Sample =
echo  Parameter: 1  User object name      common           dcollins
echo  Parameter: 2  Default container     distinguished    mercury.hq.dart
echo  Parameter: 3  Default server        common           mercury
echo  .
echo  Note:  if the sample does not have a leading period (.) then don't
echo  use one.  (use exactly the same syntax.)
echo  .

if [%1] == [] goto end
if [%2] == [] goto error
if [%3] == [] goto error

Rem  If user object does not exist then 'error' out.
n4object %1 "/c=user" /l
if not errorlevel 1 goto error

Rem  If server object does not exist then 'error' out.
n4object %3 "/c=ncp server" /l
if not errorlevel 1 goto error

echo  .  Press anykey to start the 'add' or else CTRL-C
pause

rem  Log the command parameter used to help in later debugging.
nlogmsg h:\del-me.log "%1 %2 %3"

@echo on

map i:=%3/sys:
map j:=%3/vol1:
if not exist i:\public\*.* goto error

I:
CD\

n4objmgr del %1.%2
if errorlevel 1 goto error

pause

Rem  Delete user from their personal user directory

I:
cd\
md I:\usr\%1
cd I:\usr
h:\public\robot\deltree i:\usr\%1

Rem  Delete user from their personal email directory

I:
cd\
md I:\mhs\mail\users\%1
cd I:\mhs\mail\users\%1
flag *.flg n /sub
cd I:\mhs\mail\users
h:\public\robot\deltree i:\mhs\mail\users\%1

h:
cd \logic

rem  To 'authenticate' to Venus for Office Logic.
map k:=venus/sys:

@echo off
echo .
echo . Ok, now, you will need to:
echo .
echo .  Rconsole to IO, Load NGMAdmin, delete the user from the correct 
echo         Passive server.  
echo .  Delete the user in Office Logic Email.
echo .

h:
cd \logic

goto end

:error
h:
cd\
@echo off
echo  Error occurred!

:end

